/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ram.utils;

import java.io.ByteArrayOutputStream;
import org.qubership.atp.ram.model.GridFsFileData;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;

public final class FilesDownloadHelper {
    public static HttpHeaders addDownloadToFileSystemHeaders(String fileName) {
        HttpHeaders responseHeaders = new HttpHeaders();
        responseHeaders.add("Content-Disposition", String.format("attachment; filename=\"%s\"", fileName));
        responseHeaders.add("Access-Control-Expose-Headers", "Content-Disposition");
        return responseHeaders;
    }

    public static ResponseEntity<Object> getGridFsFileResponseEntity(GridFsFileData fileData) {
        ByteArrayOutputStream outputStream = fileData.getOutputStream();
        String fileName = fileData.getFileName();
        HttpHeaders responseHeaders = FilesDownloadHelper.addDownloadToFileSystemHeaders(fileName);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(responseHeaders)).body((Object)outputStream.toByteArray());
    }

    private FilesDownloadHelper() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

