/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ram.utils;

import java.beans.FeatureDescriptor;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class PatchHelper {
    private static final Logger log = LoggerFactory.getLogger(PatchHelper.class);
    public static final FieldFilter nullProperties = PatchHelper::getNullPropertyNames;
    public static final FieldFilter emptyCollectionsProperties = PatchHelper::getEmptyCollectionPropertiesNames;
    public static final FieldFilter emptyMapsPropertiesFilter = PatchHelper::getEmptyMapPropertiesNames;

    public Object partialUpdate(Object source, Object target, FieldFilter ... fieldFilters) {
        log.debug("Patching object {} with {} using filters {}", new Object[]{target, source, Arrays.asList(fieldFilters)});
        BeanWrapperImpl wrappedSource = new BeanWrapperImpl(source);
        String[] ignoredProperties = (String[])((Stream)Arrays.stream(fieldFilters).parallel()).map(arg_0 -> PatchHelper.lambda$partialUpdate$0((BeanWrapper)wrappedSource, arg_0)).reduce(Stream::concat).orElseGet(Stream::empty).toArray(String[]::new);
        log.trace("Ignore properties: {}", Arrays.asList(ignoredProperties));
        BeanUtils.copyProperties((Object)source, (Object)target, (String[])ignoredProperties);
        return target;
    }

    public FieldFilter getConcretePropertiesFilter(List<String> properties) {
        return wrappedSource -> PatchHelper.getConcretePropertyNames(wrappedSource, properties);
    }

    private static Stream<String> getNullPropertyNames(BeanWrapper wrappedSource) {
        return Stream.of(wrappedSource.getPropertyDescriptors()).map(FeatureDescriptor::getName).filter(propertyName -> wrappedSource.getPropertyValue(propertyName) == null);
    }

    private static Stream<String> getEmptyCollectionPropertiesNames(BeanWrapper wrappedSource) {
        return ((Stream)Stream.of(wrappedSource.getPropertyDescriptors()).parallel()).filter(propertyDescriptor -> Collection.class.isAssignableFrom(propertyDescriptor.getPropertyType())).filter(propertyDescriptor -> CollectionUtils.isEmpty((Collection)((Collection)wrappedSource.getPropertyValue(propertyDescriptor.getName())))).map(FeatureDescriptor::getName);
    }

    private static Stream<String> getEmptyMapPropertiesNames(BeanWrapper wrappedSource) {
        return ((Stream)Stream.of(wrappedSource.getPropertyDescriptors()).parallel()).filter(propertyDescriptor -> Map.class.isAssignableFrom(propertyDescriptor.getPropertyType())).filter(propertyDescriptor -> CollectionUtils.isEmpty((Map)((Map)wrappedSource.getPropertyValue(propertyDescriptor.getName())))).map(FeatureDescriptor::getName);
    }

    private static Stream<String> getConcretePropertyNames(BeanWrapper wrappedSource, List<String> properties) {
        return Stream.of(wrappedSource.getPropertyDescriptors()).map(FeatureDescriptor::getName).filter(properties::contains);
    }

    private static /* synthetic */ Stream lambda$partialUpdate$0(BeanWrapper wrappedSource, FieldFilter fieldFilter) {
        return fieldFilter.filterFieldsToIgnore(wrappedSource);
    }

    @FunctionalInterface
    public static interface FieldFilter {
        public Stream<String> filterFieldsToIgnore(BeanWrapper var1);
    }
}

