package org.qubership.atp.dataset.clients.dto;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.qubership.atp.dataset.clients.dto.AttributeFlatDto;
import org.qubership.atp.dataset.clients.dto.DataSetFlatDto;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * DataSetListFlatDto
 */

@JsonTypeName("DataSetListFlat")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2025-07-10T06:10:30.324230310Z[Etc/UTC]")
public class DataSetListFlatDto {

  @JsonProperty("attributes")
  @Valid
  private List<AttributeFlatDto> attributes = null;

  @JsonProperty("dataSets")
  @Valid
  private List<DataSetFlatDto> dataSets = null;

  @JsonProperty("id")
  private UUID id;

  @JsonProperty("name")
  private String name;

  public DataSetListFlatDto attributes(List<AttributeFlatDto> attributes) {
    this.attributes = attributes;
    return this;
  }

  public DataSetListFlatDto addAttributesItem(AttributeFlatDto attributesItem) {
    if (this.attributes == null) {
      this.attributes = new ArrayList<>();
    }
    this.attributes.add(attributesItem);
    return this;
  }

  /**
   * Get attributes
   * @return attributes
  */
  @Valid 
  @Schema(name = "attributes", required = false)
  public List<AttributeFlatDto> getAttributes() {
    return attributes;
  }

  public void setAttributes(List<AttributeFlatDto> attributes) {
    this.attributes = attributes;
  }

  public DataSetListFlatDto dataSets(List<DataSetFlatDto> dataSets) {
    this.dataSets = dataSets;
    return this;
  }

  public DataSetListFlatDto addDataSetsItem(DataSetFlatDto dataSetsItem) {
    if (this.dataSets == null) {
      this.dataSets = new ArrayList<>();
    }
    this.dataSets.add(dataSetsItem);
    return this;
  }

  /**
   * Get dataSets
   * @return dataSets
  */
  @Valid 
  @Schema(name = "dataSets", required = false)
  public List<DataSetFlatDto> getDataSets() {
    return dataSets;
  }

  public void setDataSets(List<DataSetFlatDto> dataSets) {
    this.dataSets = dataSets;
  }

  public DataSetListFlatDto id(UUID id) {
    this.id = id;
    return this;
  }

  /**
   * Get id
   * @return id
  */
  @Valid 
  @Schema(name = "id", required = false)
  public UUID getId() {
    return id;
  }

  public void setId(UUID id) {
    this.id = id;
  }

  public DataSetListFlatDto name(String name) {
    this.name = name;
    return this;
  }

  /**
   * Get name
   * @return name
  */
  
  @Schema(name = "name", required = false)
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DataSetListFlatDto dataSetListFlat = (DataSetListFlatDto) o;
    return Objects.equals(this.attributes, dataSetListFlat.attributes) &&
        Objects.equals(this.dataSets, dataSetListFlat.dataSets) &&
        Objects.equals(this.id, dataSetListFlat.id) &&
        Objects.equals(this.name, dataSetListFlat.name);
  }

  @Override
  public int hashCode() {
    return Objects.hash(attributes, dataSets, id, name);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DataSetListFlatDto {\n");
    sb.append("    attributes: ").append(toIndentedString(attributes)).append("\n");
    sb.append("    dataSets: ").append(toIndentedString(dataSets)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

