package org.qubership.atp.dataset.clients.dto;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.HashMap;
import java.util.Map;
import org.qubership.atp.dataset.clients.dto.AbstractParameterDto;
import org.qubership.atp.dataset.clients.dto.DataSetGroupDto;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * DataSetTreeDto
 */

@JsonTypeName("DataSetTree")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2025-07-10T06:10:30.129119415Z[Etc/UTC]")
public class DataSetTreeDto {

  @JsonProperty("groups")
  @Valid
  private Map<String, DataSetGroupDto> groups = null;

  @JsonProperty("parameters")
  @Valid
  private Map<String, AbstractParameterDto> parameters = null;

  public DataSetTreeDto groups(Map<String, DataSetGroupDto> groups) {
    this.groups = groups;
    return this;
  }

  public DataSetTreeDto putGroupsItem(String key, DataSetGroupDto groupsItem) {
    if (this.groups == null) {
      this.groups = new HashMap<>();
    }
    this.groups.put(key, groupsItem);
    return this;
  }

  /**
   * Get groups
   * @return groups
  */
  @Valid 
  @Schema(name = "groups", required = false)
  public Map<String, DataSetGroupDto> getGroups() {
    return groups;
  }

  public void setGroups(Map<String, DataSetGroupDto> groups) {
    this.groups = groups;
  }

  public DataSetTreeDto parameters(Map<String, AbstractParameterDto> parameters) {
    this.parameters = parameters;
    return this;
  }

  public DataSetTreeDto putParametersItem(String key, AbstractParameterDto parametersItem) {
    if (this.parameters == null) {
      this.parameters = new HashMap<>();
    }
    this.parameters.put(key, parametersItem);
    return this;
  }

  /**
   * Get parameters
   * @return parameters
  */
  @Valid 
  @Schema(name = "parameters", required = false)
  public Map<String, AbstractParameterDto> getParameters() {
    return parameters;
  }

  public void setParameters(Map<String, AbstractParameterDto> parameters) {
    this.parameters = parameters;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DataSetTreeDto dataSetTree = (DataSetTreeDto) o;
    return Objects.equals(this.groups, dataSetTree.groups) &&
        Objects.equals(this.parameters, dataSetTree.parameters);
  }

  @Override
  public int hashCode() {
    return Objects.hash(groups, parameters);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DataSetTreeDto {\n");
    sb.append("    groups: ").append(toIndentedString(groups)).append("\n");
    sb.append("    parameters: ").append(toIndentedString(parameters)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

