package org.qubership.atp.dataset.clients.dto;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.ArrayList;
import java.util.List;
import org.qubership.atp.dataset.clients.dto.AbstractEntityResponseDto;
import org.qubership.atp.dataset.clients.dto.PageableDto;
import org.qubership.atp.dataset.clients.dto.SortDto;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * PageAbstractEntityResponseDto
 */

@JsonTypeName("PageAbstractEntityResponse")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2025-07-10T06:10:30.129119415Z[Etc/UTC]")
public class PageAbstractEntityResponseDto {

  @JsonProperty("content")
  @Valid
  private List<AbstractEntityResponseDto> content = null;

  @JsonProperty("empty")
  private Boolean empty;

  @JsonProperty("first")
  private Boolean first;

  @JsonProperty("last")
  private Boolean last;

  @JsonProperty("number")
  private Integer number;

  @JsonProperty("numberOfElements")
  private Integer numberOfElements;

  @JsonProperty("pageable")
  private PageableDto pageable;

  @JsonProperty("size")
  private Integer size;

  @JsonProperty("sort")
  private SortDto sort;

  @JsonProperty("totalElements")
  private Long totalElements;

  @JsonProperty("totalPages")
  private Integer totalPages;

  public PageAbstractEntityResponseDto content(List<AbstractEntityResponseDto> content) {
    this.content = content;
    return this;
  }

  public PageAbstractEntityResponseDto addContentItem(AbstractEntityResponseDto contentItem) {
    if (this.content == null) {
      this.content = new ArrayList<>();
    }
    this.content.add(contentItem);
    return this;
  }

  /**
   * Get content
   * @return content
  */
  @Valid 
  @Schema(name = "content", required = false)
  public List<AbstractEntityResponseDto> getContent() {
    return content;
  }

  public void setContent(List<AbstractEntityResponseDto> content) {
    this.content = content;
  }

  public PageAbstractEntityResponseDto empty(Boolean empty) {
    this.empty = empty;
    return this;
  }

  /**
   * Get empty
   * @return empty
  */
  
  @Schema(name = "empty", required = false)
  public Boolean getEmpty() {
    return empty;
  }

  public void setEmpty(Boolean empty) {
    this.empty = empty;
  }

  public PageAbstractEntityResponseDto first(Boolean first) {
    this.first = first;
    return this;
  }

  /**
   * Get first
   * @return first
  */
  
  @Schema(name = "first", required = false)
  public Boolean getFirst() {
    return first;
  }

  public void setFirst(Boolean first) {
    this.first = first;
  }

  public PageAbstractEntityResponseDto last(Boolean last) {
    this.last = last;
    return this;
  }

  /**
   * Get last
   * @return last
  */
  
  @Schema(name = "last", required = false)
  public Boolean getLast() {
    return last;
  }

  public void setLast(Boolean last) {
    this.last = last;
  }

  public PageAbstractEntityResponseDto number(Integer number) {
    this.number = number;
    return this;
  }

  /**
   * Get number
   * @return number
  */
  
  @Schema(name = "number", required = false)
  public Integer getNumber() {
    return number;
  }

  public void setNumber(Integer number) {
    this.number = number;
  }

  public PageAbstractEntityResponseDto numberOfElements(Integer numberOfElements) {
    this.numberOfElements = numberOfElements;
    return this;
  }

  /**
   * Get numberOfElements
   * @return numberOfElements
  */
  
  @Schema(name = "numberOfElements", required = false)
  public Integer getNumberOfElements() {
    return numberOfElements;
  }

  public void setNumberOfElements(Integer numberOfElements) {
    this.numberOfElements = numberOfElements;
  }

  public PageAbstractEntityResponseDto pageable(PageableDto pageable) {
    this.pageable = pageable;
    return this;
  }

  /**
   * Get pageable
   * @return pageable
  */
  @Valid 
  @Schema(name = "pageable", required = false)
  public PageableDto getPageable() {
    return pageable;
  }

  public void setPageable(PageableDto pageable) {
    this.pageable = pageable;
  }

  public PageAbstractEntityResponseDto size(Integer size) {
    this.size = size;
    return this;
  }

  /**
   * Get size
   * @return size
  */
  
  @Schema(name = "size", required = false)
  public Integer getSize() {
    return size;
  }

  public void setSize(Integer size) {
    this.size = size;
  }

  public PageAbstractEntityResponseDto sort(SortDto sort) {
    this.sort = sort;
    return this;
  }

  /**
   * Get sort
   * @return sort
  */
  @Valid 
  @Schema(name = "sort", required = false)
  public SortDto getSort() {
    return sort;
  }

  public void setSort(SortDto sort) {
    this.sort = sort;
  }

  public PageAbstractEntityResponseDto totalElements(Long totalElements) {
    this.totalElements = totalElements;
    return this;
  }

  /**
   * Get totalElements
   * @return totalElements
  */
  
  @Schema(name = "totalElements", required = false)
  public Long getTotalElements() {
    return totalElements;
  }

  public void setTotalElements(Long totalElements) {
    this.totalElements = totalElements;
  }

  public PageAbstractEntityResponseDto totalPages(Integer totalPages) {
    this.totalPages = totalPages;
    return this;
  }

  /**
   * Get totalPages
   * @return totalPages
  */
  
  @Schema(name = "totalPages", required = false)
  public Integer getTotalPages() {
    return totalPages;
  }

  public void setTotalPages(Integer totalPages) {
    this.totalPages = totalPages;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PageAbstractEntityResponseDto pageAbstractEntityResponse = (PageAbstractEntityResponseDto) o;
    return Objects.equals(this.content, pageAbstractEntityResponse.content) &&
        Objects.equals(this.empty, pageAbstractEntityResponse.empty) &&
        Objects.equals(this.first, pageAbstractEntityResponse.first) &&
        Objects.equals(this.last, pageAbstractEntityResponse.last) &&
        Objects.equals(this.number, pageAbstractEntityResponse.number) &&
        Objects.equals(this.numberOfElements, pageAbstractEntityResponse.numberOfElements) &&
        Objects.equals(this.pageable, pageAbstractEntityResponse.pageable) &&
        Objects.equals(this.size, pageAbstractEntityResponse.size) &&
        Objects.equals(this.sort, pageAbstractEntityResponse.sort) &&
        Objects.equals(this.totalElements, pageAbstractEntityResponse.totalElements) &&
        Objects.equals(this.totalPages, pageAbstractEntityResponse.totalPages);
  }

  @Override
  public int hashCode() {
    return Objects.hash(content, empty, first, last, number, numberOfElements, pageable, size, sort, totalElements, totalPages);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PageAbstractEntityResponseDto {\n");
    sb.append("    content: ").append(toIndentedString(content)).append("\n");
    sb.append("    empty: ").append(toIndentedString(empty)).append("\n");
    sb.append("    first: ").append(toIndentedString(first)).append("\n");
    sb.append("    last: ").append(toIndentedString(last)).append("\n");
    sb.append("    number: ").append(toIndentedString(number)).append("\n");
    sb.append("    numberOfElements: ").append(toIndentedString(numberOfElements)).append("\n");
    sb.append("    pageable: ").append(toIndentedString(pageable)).append("\n");
    sb.append("    size: ").append(toIndentedString(size)).append("\n");
    sb.append("    sort: ").append(toIndentedString(sort)).append("\n");
    sb.append("    totalElements: ").append(toIndentedString(totalElements)).append("\n");
    sb.append("    totalPages: ").append(toIndentedString(totalPages)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

