package org.qubership.atp.dataset.clients.dto;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.UUID;
import org.qubership.atp.dataset.clients.dto.AttributeDto;
import org.qubership.atp.dataset.clients.dto.DataSetDto;
import org.qubership.atp.dataset.clients.dto.FileDataDto;
import org.qubership.atp.dataset.clients.dto.ListValueDto;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * ParameterDto
 */

@JsonTypeName("Parameter")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2025-07-10T06:10:30.324230310Z[Etc/UTC]")
public class ParameterDto {

  @JsonProperty("attribute")
  private AttributeDto attribute;

  @JsonProperty("dataSet")
  private DataSetDto dataSet;

  @JsonProperty("dataSetReference")
  private DataSetDto dataSetReference;

  @JsonProperty("fileData")
  private FileDataDto fileData;

  @JsonProperty("id")
  private UUID id;

  @JsonProperty("listValue")
  private ListValueDto listValue;

  @JsonProperty("text")
  private String text;

  public ParameterDto attribute(AttributeDto attribute) {
    this.attribute = attribute;
    return this;
  }

  /**
   * Get attribute
   * @return attribute
  */
  @NotNull @Valid 
  @Schema(name = "attribute", required = true)
  public AttributeDto getAttribute() {
    return attribute;
  }

  public void setAttribute(AttributeDto attribute) {
    this.attribute = attribute;
  }

  public ParameterDto dataSet(DataSetDto dataSet) {
    this.dataSet = dataSet;
    return this;
  }

  /**
   * Get dataSet
   * @return dataSet
  */
  @NotNull @Valid 
  @Schema(name = "dataSet", required = true)
  public DataSetDto getDataSet() {
    return dataSet;
  }

  public void setDataSet(DataSetDto dataSet) {
    this.dataSet = dataSet;
  }

  public ParameterDto dataSetReference(DataSetDto dataSetReference) {
    this.dataSetReference = dataSetReference;
    return this;
  }

  /**
   * Get dataSetReference
   * @return dataSetReference
  */
  @Valid 
  @Schema(name = "dataSetReference", required = false)
  public DataSetDto getDataSetReference() {
    return dataSetReference;
  }

  public void setDataSetReference(DataSetDto dataSetReference) {
    this.dataSetReference = dataSetReference;
  }

  public ParameterDto fileData(FileDataDto fileData) {
    this.fileData = fileData;
    return this;
  }

  /**
   * Get fileData
   * @return fileData
  */
  @Valid 
  @Schema(name = "fileData", required = false)
  public FileDataDto getFileData() {
    return fileData;
  }

  public void setFileData(FileDataDto fileData) {
    this.fileData = fileData;
  }

  public ParameterDto id(UUID id) {
    this.id = id;
    return this;
  }

  /**
   * Get id
   * @return id
  */
  @NotNull @Valid 
  @Schema(name = "id", required = true)
  public UUID getId() {
    return id;
  }

  public void setId(UUID id) {
    this.id = id;
  }

  public ParameterDto listValue(ListValueDto listValue) {
    this.listValue = listValue;
    return this;
  }

  /**
   * Get listValue
   * @return listValue
  */
  @Valid 
  @Schema(name = "listValue", required = false)
  public ListValueDto getListValue() {
    return listValue;
  }

  public void setListValue(ListValueDto listValue) {
    this.listValue = listValue;
  }

  public ParameterDto text(String text) {
    this.text = text;
    return this;
  }

  /**
   * for attribute with text type
   * @return text
  */
  
  @Schema(name = "text", description = "for attribute with text type", required = false)
  public String getText() {
    return text;
  }

  public void setText(String text) {
    this.text = text;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ParameterDto parameter = (ParameterDto) o;
    return Objects.equals(this.attribute, parameter.attribute) &&
        Objects.equals(this.dataSet, parameter.dataSet) &&
        Objects.equals(this.dataSetReference, parameter.dataSetReference) &&
        Objects.equals(this.fileData, parameter.fileData) &&
        Objects.equals(this.id, parameter.id) &&
        Objects.equals(this.listValue, parameter.listValue) &&
        Objects.equals(this.text, parameter.text);
  }

  @Override
  public int hashCode() {
    return Objects.hash(attribute, dataSet, dataSetReference, fileData, id, listValue, text);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ParameterDto {\n");
    sb.append("    attribute: ").append(toIndentedString(attribute)).append("\n");
    sb.append("    dataSet: ").append(toIndentedString(dataSet)).append("\n");
    sb.append("    dataSetReference: ").append(toIndentedString(dataSetReference)).append("\n");
    sb.append("    fileData: ").append(toIndentedString(fileData)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    listValue: ").append(toIndentedString(listValue)).append("\n");
    sb.append("    text: ").append(toIndentedString(text)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

