package org.qubership.atp.orchestrator.clients.dto;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.qubership.atp.orchestrator.clients.dto.EnrichedCompoundDto;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * EnrichedScenarioDto
 */

@JsonTypeName("EnrichedScenario")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2025-07-10T06:10:29.928430417Z[Etc/UTC]")
public class EnrichedScenarioDto {

  @JsonProperty("testScenarioId")
  private UUID testScenarioId;

  @JsonProperty("testScenarioName")
  private String testScenarioName;

  @JsonProperty("compounds")
  @Valid
  private List<EnrichedCompoundDto> compounds = null;

  public EnrichedScenarioDto testScenarioId(UUID testScenarioId) {
    this.testScenarioId = testScenarioId;
    return this;
  }

  /**
   * Get testScenarioId
   * @return testScenarioId
  */
  @Valid 
  @Schema(name = "testScenarioId", required = false)
  public UUID getTestScenarioId() {
    return testScenarioId;
  }

  public void setTestScenarioId(UUID testScenarioId) {
    this.testScenarioId = testScenarioId;
  }

  public EnrichedScenarioDto testScenarioName(String testScenarioName) {
    this.testScenarioName = testScenarioName;
    return this;
  }

  /**
   * Get testScenarioName
   * @return testScenarioName
  */
  
  @Schema(name = "testScenarioName", required = false)
  public String getTestScenarioName() {
    return testScenarioName;
  }

  public void setTestScenarioName(String testScenarioName) {
    this.testScenarioName = testScenarioName;
  }

  public EnrichedScenarioDto compounds(List<EnrichedCompoundDto> compounds) {
    this.compounds = compounds;
    return this;
  }

  public EnrichedScenarioDto addCompoundsItem(EnrichedCompoundDto compoundsItem) {
    if (this.compounds == null) {
      this.compounds = new ArrayList<>();
    }
    this.compounds.add(compoundsItem);
    return this;
  }

  /**
   * Get compounds
   * @return compounds
  */
  @Valid 
  @Schema(name = "compounds", required = false)
  public List<EnrichedCompoundDto> getCompounds() {
    return compounds;
  }

  public void setCompounds(List<EnrichedCompoundDto> compounds) {
    this.compounds = compounds;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    EnrichedScenarioDto enrichedScenario = (EnrichedScenarioDto) o;
    return Objects.equals(this.testScenarioId, enrichedScenario.testScenarioId) &&
        Objects.equals(this.testScenarioName, enrichedScenario.testScenarioName) &&
        Objects.equals(this.compounds, enrichedScenario.compounds);
  }

  @Override
  public int hashCode() {
    return Objects.hash(testScenarioId, testScenarioName, compounds);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class EnrichedScenarioDto {\n");
    sb.append("    testScenarioId: ").append(toIndentedString(testScenarioId)).append("\n");
    sb.append("    testScenarioName: ").append(toIndentedString(testScenarioName)).append("\n");
    sb.append("    compounds: ").append(toIndentedString(compounds)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

