/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech) (6.2.1).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
package org.qubership.atp.ram.clients.api;

import org.qubership.atp.ram.clients.api.dto.catalogue.JiraComponentDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.JiraIssueCreateRequestDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.JiraIssueCreateResponseDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.JiraIssueDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.JiraIssueSearchRequestDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.JiraIssueSearchResponseDto;
import java.util.List;
import org.qubership.atp.ram.clients.api.dto.catalogue.ProjectSearchRequestDto;
import java.util.Set;
import org.qubership.atp.ram.clients.api.dto.catalogue.TestRunToJiraInfoDto;
import java.util.UUID;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.multipart.MultipartFile;

import javax.validation.Valid;
import javax.validation.constraints.*;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;

@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2025-07-10T06:10:26.223992724Z[Etc/UTC]")
@Validated
@Tag(name = "IntegrationController", description = "Integration Controller")
public interface IntegrationControllerApi {

    /**
     * POST /catalog/api/v1/integrations/autosync/executionrequest/{uuid} : autoSyncExecutionRequestWithJira
     *
     * @param uuid uuid (required)
     * @param syncTestCases syncTestCases (required)
     * @param syncTestRuns syncTestRuns (required)
     * @return Created (status code 201)
     *         or No Content (status code 204)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     * @deprecated
     */
    @Deprecated
    @Operation(
        operationId = "autoSyncExecutionRequestWithJira",
        summary = "autoSyncExecutionRequestWithJira",
        tags = { "integration-controller" },
        responses = {
            @ApiResponse(responseCode = "201", description = "Created"),
            @ApiResponse(responseCode = "204", description = "No Content"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/catalog/api/v1/integrations/autosync/executionrequest/{uuid}"
    )
    ResponseEntity<Void> autoSyncExecutionRequestWithJira(
        @Parameter(name = "uuid", description = "uuid", required = true) @PathVariable("uuid") UUID uuid,
        @NotNull @Parameter(name = "syncTestCases", description = "syncTestCases", required = true) @Valid @RequestParam(value = "syncTestCases", required = true) Boolean syncTestCases,
        @NotNull @Parameter(name = "syncTestRuns", description = "syncTestRuns", required = true) @Valid @RequestParam(value = "syncTestRuns", required = true) Boolean syncTestRuns
    );


    /**
     * POST /catalog/api/v1/integrations/project/{projectId}/executionrequest/{executionRequestId}/autosync : autoSyncTestRunsWithJira
     *
     * @param projectId project identifier (required)
     * @param executionRequestId execution request identifier (required)
     * @param syncTestCases syncTestCases (required)
     * @param syncTestRuns syncTestRuns (required)
     * @param testRunToJiraInfoDto  (optional)
     * @return Created (status code 201)
     *         or No Content (status code 204)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "autoSyncTestRunsWithJira",
        summary = "autoSyncTestRunsWithJira",
        tags = { "integration-controller" },
        responses = {
            @ApiResponse(responseCode = "201", description = "Created"),
            @ApiResponse(responseCode = "204", description = "No Content"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/catalog/api/v1/integrations/project/{projectId}/executionrequest/{executionRequestId}/autosync",
        consumes = { "application/json" }
    )
    ResponseEntity<Void> autoSyncTestRunsWithJira(
        @Parameter(name = "projectId", description = "project identifier", required = true) @PathVariable("projectId") UUID projectId,
        @Parameter(name = "executionRequestId", description = "execution request identifier", required = true) @PathVariable("executionRequestId") UUID executionRequestId,
        @NotNull @Parameter(name = "syncTestCases", description = "syncTestCases", required = true) @Valid @RequestParam(value = "syncTestCases", required = true) Boolean syncTestCases,
        @NotNull @Parameter(name = "syncTestRuns", description = "syncTestRuns", required = true) @Valid @RequestParam(value = "syncTestRuns", required = true) Boolean syncTestRuns,
        @Parameter(name = "TestRunToJiraInfoDto", description = "") @Valid @RequestBody(required = false) List<TestRunToJiraInfoDto> testRunToJiraInfoDto
    );


    /**
     * POST /catalog/api/v1/integrations/propagate/testcases/comment : commentOnE2ETickets
     *
     * @param testRunToJiraInfoDto  (optional)
     * @return Created (status code 201)
     *         or No Content (status code 204)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "commentOnE2ETickets",
        summary = "commentOnE2ETickets",
        tags = { "integration-controller" },
        responses = {
            @ApiResponse(responseCode = "201", description = "Created"),
            @ApiResponse(responseCode = "204", description = "No Content"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/catalog/api/v1/integrations/propagate/testcases/comment",
        consumes = { "application/json" }
    )
    ResponseEntity<Void> commentOnE2ETickets(
        @Parameter(name = "TestRunToJiraInfoDto", description = "") @Valid @RequestBody(required = false) List<TestRunToJiraInfoDto> testRunToJiraInfoDto
    );


    /**
     * POST /catalog/api/v1/integrations/jira/ticket/create : createJiraTicket
     *
     * @param testPlanId  (required)
     * @param jiraIssueCreateRequestDto  (optional)
     * @return Created (status code 201)
     *         or No Content (status code 204)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "createJiraTicket",
        summary = "createJiraTicket",
        tags = { "integration-controller" },
        responses = {
            @ApiResponse(responseCode = "201", description = "Created", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = JiraIssueCreateResponseDto.class))
            }),
            @ApiResponse(responseCode = "204", description = "No Content"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/catalog/api/v1/integrations/jira/ticket/create",
        produces = { "application/json" },
        consumes = { "application/json" }
    )
    ResponseEntity<JiraIssueCreateResponseDto> createJiraTicket(
        @NotNull @Parameter(name = "testPlanId", description = "", required = true) @Valid @RequestParam(value = "testPlanId", required = true) UUID testPlanId,
        @Parameter(name = "JiraIssueCreateRequestDto", description = "") @Valid @RequestBody(required = false) JiraIssueCreateRequestDto jiraIssueCreateRequestDto
    );


    /**
     * POST /catalog/api/v1/integrations/create/testruns : createJiraTicketForTestRun
     *
     * @param UUID  (optional)
     * @return Created (status code 201)
     *         or No Content (status code 204)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "createJiraTicketForTestRun",
        summary = "createJiraTicketForTestRun",
        tags = { "integration-controller" },
        responses = {
            @ApiResponse(responseCode = "201", description = "Created"),
            @ApiResponse(responseCode = "204", description = "No Content"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/catalog/api/v1/integrations/create/testruns",
        consumes = { "application/json" }
    )
    ResponseEntity<Void> createJiraTicketForTestRun(
        @Parameter(name = "UUID", description = "") @Valid @RequestBody(required = false) Set<UUID> UUID
    );


    /**
     * GET /catalog/api/v1/integrations/jira/ticket : getJiraTicketByKey
     *
     * @param testPlanId  (required)
     * @param key  (required)
     * @return OK (status code 200)
     *         or Created (status code 201)
     *         or No Content (status code 204)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getJiraTicketByKey",
        summary = "getJiraTicketByKey",
        tags = { "integration-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = JiraIssueDto.class))
            }),
            @ApiResponse(responseCode = "201", description = "Created"),
            @ApiResponse(responseCode = "204", description = "No Content"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/catalog/api/v1/integrations/jira/ticket",
        produces = { "application/json" }
    )
    ResponseEntity<JiraIssueDto> getJiraTicketByKey(
        @NotNull @Parameter(name = "testPlanId", description = "", required = true) @Valid @RequestParam(value = "testPlanId", required = true) UUID testPlanId,
        @NotNull @Parameter(name = "key", description = "", required = true) @Valid @RequestParam(value = "key", required = true) String key
    );


    /**
     * GET /catalog/api/v1/integrations/testplan/{uuid}/components : getTestPlanJiraComponents
     *
     * @param uuid  (required)
     * @return OK (status code 200)
     *         or No Content (status code 204)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getTestPlanJiraComponents",
        summary = "getTestPlanJiraComponents",
        tags = { "integration-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = JiraComponentDto.class))
            }),
            @ApiResponse(responseCode = "204", description = "No Content"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/catalog/api/v1/integrations/testplan/{uuid}/components",
        produces = { "application/json" }
    )
    ResponseEntity<List<JiraComponentDto>> getTestPlanJiraComponents(
        @Parameter(name = "uuid", description = "", required = true) @PathVariable("uuid") UUID uuid
    );


    /**
     * POST /catalog/api/v1/integrations/propagate/testcases : propagateTestCasesToJira
     *
     * @param UUID  (optional)
     * @return Created (status code 201)
     *         or No Content (status code 204)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "propagateTestCasesToJira",
        summary = "propagateTestCasesToJira",
        tags = { "integration-controller" },
        responses = {
            @ApiResponse(responseCode = "201", description = "Created"),
            @ApiResponse(responseCode = "204", description = "No Content"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/catalog/api/v1/integrations/propagate/testcases",
        consumes = { "application/json" }
    )
    ResponseEntity<Void> propagateTestCasesToJira(
        @Parameter(name = "UUID", description = "") @Valid @RequestBody(required = false) Set<UUID> UUID
    );


    /**
     * POST /catalog/api/v1/integrations/propagate/testplan/{uuid} : propagateTestPlanToJira
     *
     * @param uuid uuid (required)
     * @return Created (status code 201)
     *         or No Content (status code 204)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "propagateTestPlanToJira",
        summary = "propagateTestPlanToJira",
        tags = { "integration-controller" },
        responses = {
            @ApiResponse(responseCode = "201", description = "Created"),
            @ApiResponse(responseCode = "204", description = "No Content"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/catalog/api/v1/integrations/propagate/testplan/{uuid}"
    )
    ResponseEntity<Void> propagateTestPlanToJira(
        @Parameter(name = "uuid", description = "uuid", required = true) @PathVariable("uuid") UUID uuid
    );


    /**
     * POST /catalog/api/v1/integrations/propagate/testruns : propagateTestRunsToJira
     *
     * @param UUID  (optional)
     * @return Created (status code 201)
     *         or No Content (status code 204)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "propagateTestRunsToJira",
        summary = "propagateTestRunsToJira",
        tags = { "integration-controller" },
        responses = {
            @ApiResponse(responseCode = "201", description = "Created"),
            @ApiResponse(responseCode = "204", description = "No Content"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/catalog/api/v1/integrations/propagate/testruns",
        consumes = { "application/json" }
    )
    ResponseEntity<Void> propagateTestRunsToJira(
        @Parameter(name = "UUID", description = "") @Valid @RequestBody(required = false) Set<UUID> UUID
    );


    /**
     * POST /catalog/api/v1/integrations/propagate/executionrequest/{uuid} : propagateTestRunsToJiraByExecutionRequestId
     *
     * @param uuid uuid (required)
     * @return Created (status code 201)
     *         or No Content (status code 204)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "propagateTestRunsToJiraByExecutionRequestId",
        summary = "propagateTestRunsToJiraByExecutionRequestId",
        tags = { "integration-controller" },
        responses = {
            @ApiResponse(responseCode = "201", description = "Created"),
            @ApiResponse(responseCode = "204", description = "No Content"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/catalog/api/v1/integrations/propagate/executionrequest/{uuid}"
    )
    ResponseEntity<Void> propagateTestRunsToJiraByExecutionRequestId(
        @Parameter(name = "uuid", description = "uuid", required = true) @PathVariable("uuid") UUID uuid
    );


    /**
     * POST /catalog/api/v1/integrations/transitions/refresh : resetTransitionMap
     *
     * @return Created (status code 201)
     *         or No Content (status code 204)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "resetTransitionMap",
        summary = "resetTransitionMap",
        tags = { "integration-controller" },
        responses = {
            @ApiResponse(responseCode = "201", description = "Created"),
            @ApiResponse(responseCode = "204", description = "No Content"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/catalog/api/v1/integrations/transitions/refresh"
    )
    ResponseEntity<Void> resetTransitionMap(
        
    );


    /**
     * POST /catalog/api/v1/integrations/jira/ticket/search : searchIssues
     *
     * @param jiraIssueSearchRequestDto  (optional)
     * @return OK (status code 200)
     *         or No Content (status code 204)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "searchIssues",
        summary = "searchIssues",
        tags = { "integration-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = JiraIssueSearchResponseDto.class))
            }),
            @ApiResponse(responseCode = "204", description = "No Content"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/catalog/api/v1/integrations/jira/ticket/search",
        produces = { "application/json" },
        consumes = { "application/json" }
    )
    ResponseEntity<JiraIssueSearchResponseDto> searchIssues(
        @Parameter(name = "JiraIssueSearchRequestDto", description = "") @Valid @RequestBody(required = false) JiraIssueSearchRequestDto jiraIssueSearchRequestDto
    );


    /**
     * POST /catalog/api/v1/integrations/{name}/projects/search : searchProjectByKey
     *
     * @param name name (required)
     * @param projectSearchRequestDto  (optional)
     * @return OK (status code 200)
     *         or Created (status code 201)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "searchProjectByKey",
        summary = "searchProjectByKey",
        tags = { "integration-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = Object.class))
            }),
            @ApiResponse(responseCode = "201", description = "Created"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/catalog/api/v1/integrations/{name}/projects/search",
        produces = { "application/json" },
        consumes = { "application/json" }
    )
    ResponseEntity<Object> searchProjectByKey(
        @Parameter(name = "name", description = "name", required = true) @PathVariable("name") String name,
        @Parameter(name = "ProjectSearchRequestDto", description = "") @Valid @RequestBody(required = false) ProjectSearchRequestDto projectSearchRequestDto
    );


    /**
     * GET /catalog/api/v1/integrations/testplan/{uuid}/projects/search : searchProjectByTestPlanId
     *
     * @param uuid uuid (required)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "searchProjectByTestPlanId",
        summary = "searchProjectByTestPlanId",
        tags = { "integration-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = Object.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/catalog/api/v1/integrations/testplan/{uuid}/projects/search",
        produces = { "application/json" }
    )
    ResponseEntity<Object> searchProjectByTestPlanId(
        @Parameter(name = "uuid", description = "uuid", required = true) @PathVariable("uuid") UUID uuid
    );


    /**
     * POST /catalog/api/v1/integrations/refresh/testcases : updateTestCasesFromJira
     *
     * @param UUID  (optional)
     * @return Created (status code 201)
     *         or No Content (status code 204)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "updateTestCasesFromJira",
        summary = "updateTestCasesFromJira",
        tags = { "integration-controller" },
        responses = {
            @ApiResponse(responseCode = "201", description = "Created"),
            @ApiResponse(responseCode = "204", description = "No Content"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/catalog/api/v1/integrations/refresh/testcases",
        consumes = { "application/json" }
    )
    ResponseEntity<Void> updateTestCasesFromJira(
        @Parameter(name = "UUID", description = "") @Valid @RequestBody(required = false) Set<UUID> UUID
    );


    /**
     * POST /catalog/api/v1/integrations/refresh/testplan/{uuid} : updateTestPlanFromJira
     *
     * @param uuid uuid (required)
     * @return Created (status code 201)
     *         or No Content (status code 204)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "updateTestPlanFromJira",
        summary = "updateTestPlanFromJira",
        tags = { "integration-controller" },
        responses = {
            @ApiResponse(responseCode = "201", description = "Created"),
            @ApiResponse(responseCode = "204", description = "No Content"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/catalog/api/v1/integrations/refresh/testplan/{uuid}"
    )
    ResponseEntity<Void> updateTestPlanFromJira(
        @Parameter(name = "uuid", description = "uuid", required = true) @PathVariable("uuid") UUID uuid
    );


    /**
     * POST /catalog/api/v1/integrations/refresh/testruns : updateTestRunsFromJira
     *
     * @param UUID  (optional)
     * @return Created (status code 201)
     *         or No Content (status code 204)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "updateTestRunsFromJira",
        summary = "updateTestRunsFromJira",
        tags = { "integration-controller" },
        responses = {
            @ApiResponse(responseCode = "201", description = "Created"),
            @ApiResponse(responseCode = "204", description = "No Content"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/catalog/api/v1/integrations/refresh/testruns",
        consumes = { "application/json" }
    )
    ResponseEntity<Void> updateTestRunsFromJira(
        @Parameter(name = "UUID", description = "") @Valid @RequestBody(required = false) Set<UUID> UUID
    );

}
