package org.qubership.atp.ram.clients.api.dto.catalogue;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.qubership.atp.ram.clients.api.dto.catalogue.ActionParameterDto;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * ActionEntityDto
 */

@JsonTypeName("ActionEntity")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2025-07-10T06:10:29.480505068Z[Etc/UTC]")
public class ActionEntityDto {

  /**
   * Gets or Sets engineType
   */
  public enum EngineTypeEnum {
    BV("BV"),
    
    EXECUTOR("EXECUTOR"),
    
    ITFACTION("ITFACTION"),
    
    ITFCALLCHAIN("ITFCALLCHAIN"),
    
    ITFWARMUP("ITFWARMUP"),
    
    NEWMAN_RUNNER("NEWMAN_RUNNER");

    private String value;

    EngineTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static EngineTypeEnum fromValue(String value) {
      for (EngineTypeEnum b : EngineTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  @JsonProperty("engineType")
  private EngineTypeEnum engineType;

  @JsonProperty("id")
  private UUID id;

  @JsonProperty("name")
  private String name;

  @JsonProperty("parameters")
  @Valid
  private List<ActionParameterDto> parameters = null;

  /**
   * Gets or Sets type
   */
  public enum TypeEnum {
    BV("BV"),
    
    COMPOUND("COMPOUND"),
    
    ITF("ITF"),
    
    MIA("MIA"),
    
    NEWMAN("NEWMAN"),
    
    R_B_M("R_B_M"),
    
    REST("REST"),
    
    SQL("SQL"),
    
    SSH("SSH"),
    
    TECHNICAL("TECHNICAL"),
    
    UI("UI");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  @JsonProperty("type")
  private TypeEnum type;

  public ActionEntityDto engineType(EngineTypeEnum engineType) {
    this.engineType = engineType;
    return this;
  }

  /**
   * Get engineType
   * @return engineType
  */
  
  @Schema(name = "engineType", required = false)
  public EngineTypeEnum getEngineType() {
    return engineType;
  }

  public void setEngineType(EngineTypeEnum engineType) {
    this.engineType = engineType;
  }

  public ActionEntityDto id(UUID id) {
    this.id = id;
    return this;
  }

  /**
   * Get id
   * @return id
  */
  @Valid 
  @Schema(name = "id", required = false)
  public UUID getId() {
    return id;
  }

  public void setId(UUID id) {
    this.id = id;
  }

  public ActionEntityDto name(String name) {
    this.name = name;
    return this;
  }

  /**
   * Get name
   * @return name
  */
  
  @Schema(name = "name", required = false)
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public ActionEntityDto parameters(List<ActionParameterDto> parameters) {
    this.parameters = parameters;
    return this;
  }

  public ActionEntityDto addParametersItem(ActionParameterDto parametersItem) {
    if (this.parameters == null) {
      this.parameters = new ArrayList<>();
    }
    this.parameters.add(parametersItem);
    return this;
  }

  /**
   * Get parameters
   * @return parameters
  */
  @Valid 
  @Schema(name = "parameters", required = false)
  public List<ActionParameterDto> getParameters() {
    return parameters;
  }

  public void setParameters(List<ActionParameterDto> parameters) {
    this.parameters = parameters;
  }

  public ActionEntityDto type(TypeEnum type) {
    this.type = type;
    return this;
  }

  /**
   * Get type
   * @return type
  */
  
  @Schema(name = "type", required = false)
  public TypeEnum getType() {
    return type;
  }

  public void setType(TypeEnum type) {
    this.type = type;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ActionEntityDto actionEntity = (ActionEntityDto) o;
    return Objects.equals(this.engineType, actionEntity.engineType) &&
        Objects.equals(this.id, actionEntity.id) &&
        Objects.equals(this.name, actionEntity.name) &&
        Objects.equals(this.parameters, actionEntity.parameters) &&
        Objects.equals(this.type, actionEntity.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(engineType, id, name, parameters, type);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ActionEntityDto {\n");
    sb.append("    engineType: ").append(toIndentedString(engineType)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    parameters: ").append(toIndentedString(parameters)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

