package org.qubership.atp.ram.clients.api.dto.catalogue;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.qubership.atp.ram.clients.api.dto.catalogue.CaseDataSetRequestDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.JiraComponentDto;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * CaseCreationRequestDto
 */

@JsonTypeName("CaseCreationRequest")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2025-07-10T06:10:27.369584967Z[Etc/UTC]")
public class CaseCreationRequestDto {

  @JsonProperty("components")
  @Valid
  private List<JiraComponentDto> components = null;

  @JsonProperty("dataSets")
  @Valid
  private List<CaseDataSetRequestDto> dataSets = new ArrayList<>();

  @JsonProperty("groupId")
  private UUID groupId;

  @JsonProperty("jiraTicket")
  private String jiraTicket;

  @JsonProperty("labelIds")
  @Valid
  private List<UUID> labelIds = null;

  @JsonProperty("name")
  private String name;

  @JsonProperty("projectId")
  private UUID projectId;

  @JsonProperty("scenarioIds")
  @Valid
  private List<UUID> scenarioIds = new ArrayList<>();

  @JsonProperty("testPlanUuid")
  private UUID testPlanUuid;

  @JsonProperty("logCollectorTemplateId")
  private UUID logCollectorTemplateId;

  public CaseCreationRequestDto components(List<JiraComponentDto> components) {
    this.components = components;
    return this;
  }

  public CaseCreationRequestDto addComponentsItem(JiraComponentDto componentsItem) {
    if (this.components == null) {
      this.components = new ArrayList<>();
    }
    this.components.add(componentsItem);
    return this;
  }

  /**
   * Get components
   * @return components
  */
  @Valid 
  @Schema(name = "components", required = false)
  public List<JiraComponentDto> getComponents() {
    return components;
  }

  public void setComponents(List<JiraComponentDto> components) {
    this.components = components;
  }

  public CaseCreationRequestDto dataSets(List<CaseDataSetRequestDto> dataSets) {
    this.dataSets = dataSets;
    return this;
  }

  public CaseCreationRequestDto addDataSetsItem(CaseDataSetRequestDto dataSetsItem) {
    this.dataSets.add(dataSetsItem);
    return this;
  }

  /**
   * Get dataSets
   * @return dataSets
  */
  @NotNull @Valid 
  @Schema(name = "dataSets", required = true)
  public List<CaseDataSetRequestDto> getDataSets() {
    return dataSets;
  }

  public void setDataSets(List<CaseDataSetRequestDto> dataSets) {
    this.dataSets = dataSets;
  }

  public CaseCreationRequestDto groupId(UUID groupId) {
    this.groupId = groupId;
    return this;
  }

  /**
   * Get groupId
   * @return groupId
  */
  @Valid 
  @Schema(name = "groupId", required = false)
  public UUID getGroupId() {
    return groupId;
  }

  public void setGroupId(UUID groupId) {
    this.groupId = groupId;
  }

  public CaseCreationRequestDto jiraTicket(String jiraTicket) {
    this.jiraTicket = jiraTicket;
    return this;
  }

  /**
   * Get jiraTicket
   * @return jiraTicket
  */
  @Pattern(regexp = "((?<!([A-Z]{1,10})-?)[A-Z]+-\\d+)") 
  @Schema(name = "jiraTicket", required = false)
  public String getJiraTicket() {
    return jiraTicket;
  }

  public void setJiraTicket(String jiraTicket) {
    this.jiraTicket = jiraTicket;
  }

  public CaseCreationRequestDto labelIds(List<UUID> labelIds) {
    this.labelIds = labelIds;
    return this;
  }

  public CaseCreationRequestDto addLabelIdsItem(UUID labelIdsItem) {
    if (this.labelIds == null) {
      this.labelIds = new ArrayList<>();
    }
    this.labelIds.add(labelIdsItem);
    return this;
  }

  /**
   * Get labelIds
   * @return labelIds
  */
  @Valid 
  @Schema(name = "labelIds", required = false)
  public List<UUID> getLabelIds() {
    return labelIds;
  }

  public void setLabelIds(List<UUID> labelIds) {
    this.labelIds = labelIds;
  }

  public CaseCreationRequestDto name(String name) {
    this.name = name;
    return this;
  }

  /**
   * Get name
   * @return name
  */
  @NotNull 
  @Schema(name = "name", required = true)
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public CaseCreationRequestDto projectId(UUID projectId) {
    this.projectId = projectId;
    return this;
  }

  /**
   * Get projectId
   * @return projectId
  */
  @NotNull @Valid 
  @Schema(name = "projectId", required = true)
  public UUID getProjectId() {
    return projectId;
  }

  public void setProjectId(UUID projectId) {
    this.projectId = projectId;
  }

  public CaseCreationRequestDto scenarioIds(List<UUID> scenarioIds) {
    this.scenarioIds = scenarioIds;
    return this;
  }

  public CaseCreationRequestDto addScenarioIdsItem(UUID scenarioIdsItem) {
    this.scenarioIds.add(scenarioIdsItem);
    return this;
  }

  /**
   * Get scenarioIds
   * @return scenarioIds
  */
  @NotNull @Valid 
  @Schema(name = "scenarioIds", required = true)
  public List<UUID> getScenarioIds() {
    return scenarioIds;
  }

  public void setScenarioIds(List<UUID> scenarioIds) {
    this.scenarioIds = scenarioIds;
  }

  public CaseCreationRequestDto testPlanUuid(UUID testPlanUuid) {
    this.testPlanUuid = testPlanUuid;
    return this;
  }

  /**
   * Get testPlanUuid
   * @return testPlanUuid
  */
  @Valid 
  @Schema(name = "testPlanUuid", required = false)
  public UUID getTestPlanUuid() {
    return testPlanUuid;
  }

  public void setTestPlanUuid(UUID testPlanUuid) {
    this.testPlanUuid = testPlanUuid;
  }

  public CaseCreationRequestDto logCollectorTemplateId(UUID logCollectorTemplateId) {
    this.logCollectorTemplateId = logCollectorTemplateId;
    return this;
  }

  /**
   * Get logCollectorTemplateId
   * @return logCollectorTemplateId
  */
  @Valid 
  @Schema(name = "logCollectorTemplateId", required = false)
  public UUID getLogCollectorTemplateId() {
    return logCollectorTemplateId;
  }

  public void setLogCollectorTemplateId(UUID logCollectorTemplateId) {
    this.logCollectorTemplateId = logCollectorTemplateId;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CaseCreationRequestDto caseCreationRequest = (CaseCreationRequestDto) o;
    return Objects.equals(this.components, caseCreationRequest.components) &&
        Objects.equals(this.dataSets, caseCreationRequest.dataSets) &&
        Objects.equals(this.groupId, caseCreationRequest.groupId) &&
        Objects.equals(this.jiraTicket, caseCreationRequest.jiraTicket) &&
        Objects.equals(this.labelIds, caseCreationRequest.labelIds) &&
        Objects.equals(this.name, caseCreationRequest.name) &&
        Objects.equals(this.projectId, caseCreationRequest.projectId) &&
        Objects.equals(this.scenarioIds, caseCreationRequest.scenarioIds) &&
        Objects.equals(this.testPlanUuid, caseCreationRequest.testPlanUuid) &&
        Objects.equals(this.logCollectorTemplateId, caseCreationRequest.logCollectorTemplateId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(components, dataSets, groupId, jiraTicket, labelIds, name, projectId, scenarioIds, testPlanUuid, logCollectorTemplateId);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CaseCreationRequestDto {\n");
    sb.append("    components: ").append(toIndentedString(components)).append("\n");
    sb.append("    dataSets: ").append(toIndentedString(dataSets)).append("\n");
    sb.append("    groupId: ").append(toIndentedString(groupId)).append("\n");
    sb.append("    jiraTicket: ").append(toIndentedString(jiraTicket)).append("\n");
    sb.append("    labelIds: ").append(toIndentedString(labelIds)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    projectId: ").append(toIndentedString(projectId)).append("\n");
    sb.append("    scenarioIds: ").append(toIndentedString(scenarioIds)).append("\n");
    sb.append("    testPlanUuid: ").append(toIndentedString(testPlanUuid)).append("\n");
    sb.append("    logCollectorTemplateId: ").append(toIndentedString(logCollectorTemplateId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

