package org.qubership.atp.ram.clients.api.dto.catalogue;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.qubership.atp.ram.clients.api.dto.catalogue.EnrichedCompoundDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.LogCollectorRequestDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.TestCaseContextDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.TestCaseDependencyDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.TestCaseRepeatCountDto;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * EnrichedCaseDto
 */

@JsonTypeName("EnrichedCase")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2025-07-10T06:10:28.339869979Z[Etc/UTC]")
public class EnrichedCaseDto {

  @JsonProperty("compounds")
  @Valid
  private List<EnrichedCompoundDto> compounds = null;

  @JsonProperty("context")
  private TestCaseContextDto context;

  @JsonProperty("dataSetId")
  private UUID dataSetId;

  @JsonProperty("dataSetStorageId")
  private UUID dataSetStorageId;

  @JsonProperty("dependsOn")
  @Valid
  private List<TestCaseDependencyDto> dependsOn = null;

  /**
   * Gets or Sets flags
   */
  public enum FlagsEnum {
    COLLECT_LOGS("COLLECT_LOGS"),
    
    COLLECT_LOGS_ON_FAIL("COLLECT_LOGS_ON_FAIL"),
    
    COLLECT_LOGS_ON_SKIPPED("COLLECT_LOGS_ON_SKIPPED"),
    
    COLLECT_LOGS_ON_WARNING("COLLECT_LOGS_ON_WARNING"),
    
    DO_NOT_PASS_INITIAL_CONTEXT("DO_NOT_PASS_INITIAL_CONTEXT"),
    
    EXECUTE_ANYWAY("EXECUTE_ANYWAY"),
    
    FAIL_IMMEDIATELY("FAIL_IMMEDIATELY"),
    
    IGNORE_PREREQUISITE_IN_PASS_RATE("IGNORE_PREREQUISITE_IN_PASS_RATE"),
    
    IGNORE_VALIDATION_IN_PASS_RATE("IGNORE_VALIDATION_IN_PASS_RATE"),
    
    INVERT_RESULT("INVERT_RESULT"),
    
    SKIP("SKIP"),
    
    SKIP_IF_DEPENDENCIES_FAIL("SKIP_IF_DEPENDENCIES_FAIL"),
    
    STOP_ON_FAIL("STOP_ON_FAIL"),
    
    SKIP_ON_PASS("SKIP_ON_PASS"),
    
    TERMINATE_IF_FAIL("TERMINATE_IF_FAIL"),
    
    TERMINATE_IF_PREREQUISITE_FAIL("TERMINATE_IF_PREREQUISITE_FAIL"),
    
    COLLECT_SSM_METRICS_ON_FAIL("COLLECT_SSM_METRICS_ON_FAIL");

    private String value;

    FlagsEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static FlagsEnum fromValue(String value) {
      for (FlagsEnum b : FlagsEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  @JsonProperty("flags")
  @Valid
  private List<FlagsEnum> flags = null;

  @JsonProperty("id")
  private UUID id;

  @JsonProperty("initialTestRunId")
  private UUID initialTestRunId;

  @JsonProperty("isIgnored")
  private Boolean isIgnored;

  @JsonProperty("lineNumber")
  private Integer lineNumber;

  @JsonProperty("logCollectorRequest")
  private LogCollectorRequestDto logCollectorRequest;

  @JsonProperty("name")
  private String name;

  @JsonProperty("parentId")
  private UUID parentId;

  @JsonProperty("scenarioHashSum")
  private String scenarioHashSum;

  @JsonProperty("testCaseRepeatCounts")
  @Valid
  private List<TestCaseRepeatCountDto> testCaseRepeatCounts = null;

  @JsonProperty("testScenarioName")
  private String testScenarioName;

  public EnrichedCaseDto compounds(List<EnrichedCompoundDto> compounds) {
    this.compounds = compounds;
    return this;
  }

  public EnrichedCaseDto addCompoundsItem(EnrichedCompoundDto compoundsItem) {
    if (this.compounds == null) {
      this.compounds = new ArrayList<>();
    }
    this.compounds.add(compoundsItem);
    return this;
  }

  /**
   * Get compounds
   * @return compounds
  */
  @Valid 
  @Schema(name = "compounds", required = false)
  public List<EnrichedCompoundDto> getCompounds() {
    return compounds;
  }

  public void setCompounds(List<EnrichedCompoundDto> compounds) {
    this.compounds = compounds;
  }

  public EnrichedCaseDto context(TestCaseContextDto context) {
    this.context = context;
    return this;
  }

  /**
   * Get context
   * @return context
  */
  @Valid 
  @Schema(name = "context", required = false)
  public TestCaseContextDto getContext() {
    return context;
  }

  public void setContext(TestCaseContextDto context) {
    this.context = context;
  }

  public EnrichedCaseDto dataSetId(UUID dataSetId) {
    this.dataSetId = dataSetId;
    return this;
  }

  /**
   * Get dataSetId
   * @return dataSetId
  */
  @Valid 
  @Schema(name = "dataSetId", required = false)
  public UUID getDataSetId() {
    return dataSetId;
  }

  public void setDataSetId(UUID dataSetId) {
    this.dataSetId = dataSetId;
  }

  public EnrichedCaseDto dataSetStorageId(UUID dataSetStorageId) {
    this.dataSetStorageId = dataSetStorageId;
    return this;
  }

  /**
   * Get dataSetStorageId
   * @return dataSetStorageId
  */
  @Valid 
  @Schema(name = "dataSetStorageId", required = false)
  public UUID getDataSetStorageId() {
    return dataSetStorageId;
  }

  public void setDataSetStorageId(UUID dataSetStorageId) {
    this.dataSetStorageId = dataSetStorageId;
  }

  public EnrichedCaseDto dependsOn(List<TestCaseDependencyDto> dependsOn) {
    this.dependsOn = dependsOn;
    return this;
  }

  public EnrichedCaseDto addDependsOnItem(TestCaseDependencyDto dependsOnItem) {
    if (this.dependsOn == null) {
      this.dependsOn = new ArrayList<>();
    }
    this.dependsOn.add(dependsOnItem);
    return this;
  }

  /**
   * Get dependsOn
   * @return dependsOn
  */
  @Valid 
  @Schema(name = "dependsOn", required = false)
  public List<TestCaseDependencyDto> getDependsOn() {
    return dependsOn;
  }

  public void setDependsOn(List<TestCaseDependencyDto> dependsOn) {
    this.dependsOn = dependsOn;
  }

  public EnrichedCaseDto flags(List<FlagsEnum> flags) {
    this.flags = flags;
    return this;
  }

  public EnrichedCaseDto addFlagsItem(FlagsEnum flagsItem) {
    if (this.flags == null) {
      this.flags = new ArrayList<>();
    }
    this.flags.add(flagsItem);
    return this;
  }

  /**
   * Get flags
   * @return flags
  */
  
  @Schema(name = "flags", required = false)
  public List<FlagsEnum> getFlags() {
    return flags;
  }

  public void setFlags(List<FlagsEnum> flags) {
    this.flags = flags;
  }

  public EnrichedCaseDto id(UUID id) {
    this.id = id;
    return this;
  }

  /**
   * Get id
   * @return id
  */
  @Valid 
  @Schema(name = "id", required = false)
  public UUID getId() {
    return id;
  }

  public void setId(UUID id) {
    this.id = id;
  }

  public EnrichedCaseDto initialTestRunId(UUID initialTestRunId) {
    this.initialTestRunId = initialTestRunId;
    return this;
  }

  /**
   * Get initialTestRunId
   * @return initialTestRunId
  */
  @Valid 
  @Schema(name = "initialTestRunId", required = false)
  public UUID getInitialTestRunId() {
    return initialTestRunId;
  }

  public void setInitialTestRunId(UUID initialTestRunId) {
    this.initialTestRunId = initialTestRunId;
  }

  public EnrichedCaseDto isIgnored(Boolean isIgnored) {
    this.isIgnored = isIgnored;
    return this;
  }

  /**
   * Get isIgnored
   * @return isIgnored
  */
  
  @Schema(name = "isIgnored", required = false)
  public Boolean getIsIgnored() {
    return isIgnored;
  }

  public void setIsIgnored(Boolean isIgnored) {
    this.isIgnored = isIgnored;
  }

  public EnrichedCaseDto lineNumber(Integer lineNumber) {
    this.lineNumber = lineNumber;
    return this;
  }

  /**
   * Get lineNumber
   * @return lineNumber
  */
  
  @Schema(name = "lineNumber", required = false)
  public Integer getLineNumber() {
    return lineNumber;
  }

  public void setLineNumber(Integer lineNumber) {
    this.lineNumber = lineNumber;
  }

  public EnrichedCaseDto logCollectorRequest(LogCollectorRequestDto logCollectorRequest) {
    this.logCollectorRequest = logCollectorRequest;
    return this;
  }

  /**
   * Get logCollectorRequest
   * @return logCollectorRequest
  */
  @Valid 
  @Schema(name = "logCollectorRequest", required = false)
  public LogCollectorRequestDto getLogCollectorRequest() {
    return logCollectorRequest;
  }

  public void setLogCollectorRequest(LogCollectorRequestDto logCollectorRequest) {
    this.logCollectorRequest = logCollectorRequest;
  }

  public EnrichedCaseDto name(String name) {
    this.name = name;
    return this;
  }

  /**
   * Get name
   * @return name
  */
  @NotNull 
  @Schema(name = "name", required = true)
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public EnrichedCaseDto parentId(UUID parentId) {
    this.parentId = parentId;
    return this;
  }

  /**
   * Get parentId
   * @return parentId
  */
  @Valid 
  @Schema(name = "parentId", required = false)
  public UUID getParentId() {
    return parentId;
  }

  public void setParentId(UUID parentId) {
    this.parentId = parentId;
  }

  public EnrichedCaseDto scenarioHashSum(String scenarioHashSum) {
    this.scenarioHashSum = scenarioHashSum;
    return this;
  }

  /**
   * Get scenarioHashSum
   * @return scenarioHashSum
  */
  
  @Schema(name = "scenarioHashSum", required = false)
  public String getScenarioHashSum() {
    return scenarioHashSum;
  }

  public void setScenarioHashSum(String scenarioHashSum) {
    this.scenarioHashSum = scenarioHashSum;
  }

  public EnrichedCaseDto testCaseRepeatCounts(List<TestCaseRepeatCountDto> testCaseRepeatCounts) {
    this.testCaseRepeatCounts = testCaseRepeatCounts;
    return this;
  }

  public EnrichedCaseDto addTestCaseRepeatCountsItem(TestCaseRepeatCountDto testCaseRepeatCountsItem) {
    if (this.testCaseRepeatCounts == null) {
      this.testCaseRepeatCounts = new ArrayList<>();
    }
    this.testCaseRepeatCounts.add(testCaseRepeatCountsItem);
    return this;
  }

  /**
   * Get testCaseRepeatCounts
   * @return testCaseRepeatCounts
  */
  @Valid 
  @Schema(name = "testCaseRepeatCounts", required = false)
  public List<TestCaseRepeatCountDto> getTestCaseRepeatCounts() {
    return testCaseRepeatCounts;
  }

  public void setTestCaseRepeatCounts(List<TestCaseRepeatCountDto> testCaseRepeatCounts) {
    this.testCaseRepeatCounts = testCaseRepeatCounts;
  }

  public EnrichedCaseDto testScenarioName(String testScenarioName) {
    this.testScenarioName = testScenarioName;
    return this;
  }

  /**
   * Get testScenarioName
   * @return testScenarioName
  */
  
  @Schema(name = "testScenarioName", required = false)
  public String getTestScenarioName() {
    return testScenarioName;
  }

  public void setTestScenarioName(String testScenarioName) {
    this.testScenarioName = testScenarioName;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    EnrichedCaseDto enrichedCase = (EnrichedCaseDto) o;
    return Objects.equals(this.compounds, enrichedCase.compounds) &&
        Objects.equals(this.context, enrichedCase.context) &&
        Objects.equals(this.dataSetId, enrichedCase.dataSetId) &&
        Objects.equals(this.dataSetStorageId, enrichedCase.dataSetStorageId) &&
        Objects.equals(this.dependsOn, enrichedCase.dependsOn) &&
        Objects.equals(this.flags, enrichedCase.flags) &&
        Objects.equals(this.id, enrichedCase.id) &&
        Objects.equals(this.initialTestRunId, enrichedCase.initialTestRunId) &&
        Objects.equals(this.isIgnored, enrichedCase.isIgnored) &&
        Objects.equals(this.lineNumber, enrichedCase.lineNumber) &&
        Objects.equals(this.logCollectorRequest, enrichedCase.logCollectorRequest) &&
        Objects.equals(this.name, enrichedCase.name) &&
        Objects.equals(this.parentId, enrichedCase.parentId) &&
        Objects.equals(this.scenarioHashSum, enrichedCase.scenarioHashSum) &&
        Objects.equals(this.testCaseRepeatCounts, enrichedCase.testCaseRepeatCounts) &&
        Objects.equals(this.testScenarioName, enrichedCase.testScenarioName);
  }

  @Override
  public int hashCode() {
    return Objects.hash(compounds, context, dataSetId, dataSetStorageId, dependsOn, flags, id, initialTestRunId, isIgnored, lineNumber, logCollectorRequest, name, parentId, scenarioHashSum, testCaseRepeatCounts, testScenarioName);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class EnrichedCaseDto {\n");
    sb.append("    compounds: ").append(toIndentedString(compounds)).append("\n");
    sb.append("    context: ").append(toIndentedString(context)).append("\n");
    sb.append("    dataSetId: ").append(toIndentedString(dataSetId)).append("\n");
    sb.append("    dataSetStorageId: ").append(toIndentedString(dataSetStorageId)).append("\n");
    sb.append("    dependsOn: ").append(toIndentedString(dependsOn)).append("\n");
    sb.append("    flags: ").append(toIndentedString(flags)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    initialTestRunId: ").append(toIndentedString(initialTestRunId)).append("\n");
    sb.append("    isIgnored: ").append(toIndentedString(isIgnored)).append("\n");
    sb.append("    lineNumber: ").append(toIndentedString(lineNumber)).append("\n");
    sb.append("    logCollectorRequest: ").append(toIndentedString(logCollectorRequest)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    parentId: ").append(toIndentedString(parentId)).append("\n");
    sb.append("    scenarioHashSum: ").append(toIndentedString(scenarioHashSum)).append("\n");
    sb.append("    testCaseRepeatCounts: ").append(toIndentedString(testCaseRepeatCounts)).append("\n");
    sb.append("    testScenarioName: ").append(toIndentedString(testScenarioName)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

