package org.qubership.atp.ram.clients.api.dto.catalogue;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.qubership.atp.ram.clients.api.dto.catalogue.ActionEntityDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.ActionParameterDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.DirectiveDto;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * EnrichedCompoundDto
 */

@JsonTypeName("EnrichedCompound")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2025-07-10T06:10:29.480505068Z[Etc/UTC]")
public class EnrichedCompoundDto {

  @JsonProperty("childCompounds")
  @Valid
  private List<EnrichedCompoundDto> childCompounds = null;

  @JsonProperty("comment")
  private String comment;

  @JsonProperty("content")
  private String content;

  @JsonProperty("deprecated")
  private Boolean deprecated;

  @JsonProperty("directives")
  @Valid
  private List<DirectiveDto> directives = null;

  @JsonProperty("entity")
  private ActionEntityDto entity;

  /**
   * Gets or Sets flags
   */
  public enum FlagsEnum {
    COLLECT_LOGS("COLLECT_LOGS"),
    
    COLLECT_LOGS_ON_FAIL("COLLECT_LOGS_ON_FAIL"),
    
    COLLECT_LOGS_ON_SKIPPED("COLLECT_LOGS_ON_SKIPPED"),
    
    COLLECT_LOGS_ON_WARNING("COLLECT_LOGS_ON_WARNING"),
    
    DO_NOT_PASS_INITIAL_CONTEXT("DO_NOT_PASS_INITIAL_CONTEXT"),
    
    EXECUTE_ANYWAY("EXECUTE_ANYWAY"),
    
    FAIL_IMMEDIATELY("FAIL_IMMEDIATELY"),
    
    IGNORE_PREREQUISITE_IN_PASS_RATE("IGNORE_PREREQUISITE_IN_PASS_RATE"),
    
    IGNORE_VALIDATION_IN_PASS_RATE("IGNORE_VALIDATION_IN_PASS_RATE"),
    
    INVERT_RESULT("INVERT_RESULT"),
    
    SKIP("SKIP"),
    
    SKIP_IF_DEPENDENCIES_FAIL("SKIP_IF_DEPENDENCIES_FAIL"),
    
    STOP_ON_FAIL("STOP_ON_FAIL"),
    
    SKIP_ON_PASS("SKIP_ON_PASS"),
    
    TERMINATE_IF_FAIL("TERMINATE_IF_FAIL"),
    
    TERMINATE_IF_PREREQUISITE_FAIL("TERMINATE_IF_PREREQUISITE_FAIL"),
    
    COLLECT_SSM_METRICS_ON_FAIL("COLLECT_SSM_METRICS_ON_FAIL");

    private String value;

    FlagsEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static FlagsEnum fromValue(String value) {
      for (FlagsEnum b : FlagsEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  @JsonProperty("flags")
  @Valid
  private List<FlagsEnum> flags = null;

  @JsonProperty("hidden")
  private Boolean hidden;

  @JsonProperty("id")
  private UUID id;

  @JsonProperty("lineNumber")
  private Integer lineNumber;

  @JsonProperty("parameters")
  @Valid
  private List<ActionParameterDto> parameters = null;

  @JsonProperty("scenarioHashSum")
  private String scenarioHashSum;

  @JsonProperty("systemId")
  private UUID systemId;

  @JsonProperty("timeout")
  private Integer timeout;

  /**
   * Gets or Sets type
   */
  public enum TypeEnum {
    BV("BV"),
    
    COMPOUND("COMPOUND"),
    
    ITF("ITF"),
    
    MIA("MIA"),
    
    NEWMAN("NEWMAN"),
    
    R_B_M("R_B_M"),
    
    REST("REST"),
    
    SQL("SQL"),
    
    SSH("SSH"),
    
    TECHNICAL("TECHNICAL"),
    
    UI("UI");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  @JsonProperty("type")
  private TypeEnum type;

  public EnrichedCompoundDto childCompounds(List<EnrichedCompoundDto> childCompounds) {
    this.childCompounds = childCompounds;
    return this;
  }

  public EnrichedCompoundDto addChildCompoundsItem(EnrichedCompoundDto childCompoundsItem) {
    if (this.childCompounds == null) {
      this.childCompounds = new ArrayList<>();
    }
    this.childCompounds.add(childCompoundsItem);
    return this;
  }

  /**
   * Get childCompounds
   * @return childCompounds
  */
  @Valid 
  @Schema(name = "childCompounds", required = false)
  public List<EnrichedCompoundDto> getChildCompounds() {
    return childCompounds;
  }

  public void setChildCompounds(List<EnrichedCompoundDto> childCompounds) {
    this.childCompounds = childCompounds;
  }

  public EnrichedCompoundDto comment(String comment) {
    this.comment = comment;
    return this;
  }

  /**
   * Get comment
   * @return comment
  */
  
  @Schema(name = "comment", required = false)
  public String getComment() {
    return comment;
  }

  public void setComment(String comment) {
    this.comment = comment;
  }

  public EnrichedCompoundDto content(String content) {
    this.content = content;
    return this;
  }

  /**
   * Get content
   * @return content
  */
  @NotNull 
  @Schema(name = "content", required = true)
  public String getContent() {
    return content;
  }

  public void setContent(String content) {
    this.content = content;
  }

  public EnrichedCompoundDto deprecated(Boolean deprecated) {
    this.deprecated = deprecated;
    return this;
  }

  /**
   * Get deprecated
   * @return deprecated
  */
  
  @Schema(name = "deprecated", required = false)
  public Boolean getDeprecated() {
    return deprecated;
  }

  public void setDeprecated(Boolean deprecated) {
    this.deprecated = deprecated;
  }

  public EnrichedCompoundDto directives(List<DirectiveDto> directives) {
    this.directives = directives;
    return this;
  }

  public EnrichedCompoundDto addDirectivesItem(DirectiveDto directivesItem) {
    if (this.directives == null) {
      this.directives = new ArrayList<>();
    }
    this.directives.add(directivesItem);
    return this;
  }

  /**
   * Get directives
   * @return directives
  */
  @Valid 
  @Schema(name = "directives", required = false)
  public List<DirectiveDto> getDirectives() {
    return directives;
  }

  public void setDirectives(List<DirectiveDto> directives) {
    this.directives = directives;
  }

  public EnrichedCompoundDto entity(ActionEntityDto entity) {
    this.entity = entity;
    return this;
  }

  /**
   * Get entity
   * @return entity
  */
  @Valid 
  @Schema(name = "entity", required = false)
  public ActionEntityDto getEntity() {
    return entity;
  }

  public void setEntity(ActionEntityDto entity) {
    this.entity = entity;
  }

  public EnrichedCompoundDto flags(List<FlagsEnum> flags) {
    this.flags = flags;
    return this;
  }

  public EnrichedCompoundDto addFlagsItem(FlagsEnum flagsItem) {
    if (this.flags == null) {
      this.flags = new ArrayList<>();
    }
    this.flags.add(flagsItem);
    return this;
  }

  /**
   * Get flags
   * @return flags
  */
  
  @Schema(name = "flags", required = false)
  public List<FlagsEnum> getFlags() {
    return flags;
  }

  public void setFlags(List<FlagsEnum> flags) {
    this.flags = flags;
  }

  public EnrichedCompoundDto hidden(Boolean hidden) {
    this.hidden = hidden;
    return this;
  }

  /**
   * Get hidden
   * @return hidden
  */
  
  @Schema(name = "hidden", required = false)
  public Boolean getHidden() {
    return hidden;
  }

  public void setHidden(Boolean hidden) {
    this.hidden = hidden;
  }

  public EnrichedCompoundDto id(UUID id) {
    this.id = id;
    return this;
  }

  /**
   * Get id
   * @return id
  */
  @Valid 
  @Schema(name = "id", required = false)
  public UUID getId() {
    return id;
  }

  public void setId(UUID id) {
    this.id = id;
  }

  public EnrichedCompoundDto lineNumber(Integer lineNumber) {
    this.lineNumber = lineNumber;
    return this;
  }

  /**
   * Get lineNumber
   * @return lineNumber
  */
  
  @Schema(name = "lineNumber", required = false)
  public Integer getLineNumber() {
    return lineNumber;
  }

  public void setLineNumber(Integer lineNumber) {
    this.lineNumber = lineNumber;
  }

  public EnrichedCompoundDto parameters(List<ActionParameterDto> parameters) {
    this.parameters = parameters;
    return this;
  }

  public EnrichedCompoundDto addParametersItem(ActionParameterDto parametersItem) {
    if (this.parameters == null) {
      this.parameters = new ArrayList<>();
    }
    this.parameters.add(parametersItem);
    return this;
  }

  /**
   * Get parameters
   * @return parameters
  */
  @Valid 
  @Schema(name = "parameters", required = false)
  public List<ActionParameterDto> getParameters() {
    return parameters;
  }

  public void setParameters(List<ActionParameterDto> parameters) {
    this.parameters = parameters;
  }

  public EnrichedCompoundDto scenarioHashSum(String scenarioHashSum) {
    this.scenarioHashSum = scenarioHashSum;
    return this;
  }

  /**
   * Get scenarioHashSum
   * @return scenarioHashSum
  */
  
  @Schema(name = "scenarioHashSum", required = false)
  public String getScenarioHashSum() {
    return scenarioHashSum;
  }

  public void setScenarioHashSum(String scenarioHashSum) {
    this.scenarioHashSum = scenarioHashSum;
  }

  public EnrichedCompoundDto systemId(UUID systemId) {
    this.systemId = systemId;
    return this;
  }

  /**
   * Get systemId
   * @return systemId
  */
  @Valid 
  @Schema(name = "systemId", required = false)
  public UUID getSystemId() {
    return systemId;
  }

  public void setSystemId(UUID systemId) {
    this.systemId = systemId;
  }

  public EnrichedCompoundDto timeout(Integer timeout) {
    this.timeout = timeout;
    return this;
  }

  /**
   * Get timeout
   * @return timeout
  */
  
  @Schema(name = "timeout", required = false)
  public Integer getTimeout() {
    return timeout;
  }

  public void setTimeout(Integer timeout) {
    this.timeout = timeout;
  }

  public EnrichedCompoundDto type(TypeEnum type) {
    this.type = type;
    return this;
  }

  /**
   * Get type
   * @return type
  */
  
  @Schema(name = "type", required = false)
  public TypeEnum getType() {
    return type;
  }

  public void setType(TypeEnum type) {
    this.type = type;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    EnrichedCompoundDto enrichedCompound = (EnrichedCompoundDto) o;
    return Objects.equals(this.childCompounds, enrichedCompound.childCompounds) &&
        Objects.equals(this.comment, enrichedCompound.comment) &&
        Objects.equals(this.content, enrichedCompound.content) &&
        Objects.equals(this.deprecated, enrichedCompound.deprecated) &&
        Objects.equals(this.directives, enrichedCompound.directives) &&
        Objects.equals(this.entity, enrichedCompound.entity) &&
        Objects.equals(this.flags, enrichedCompound.flags) &&
        Objects.equals(this.hidden, enrichedCompound.hidden) &&
        Objects.equals(this.id, enrichedCompound.id) &&
        Objects.equals(this.lineNumber, enrichedCompound.lineNumber) &&
        Objects.equals(this.parameters, enrichedCompound.parameters) &&
        Objects.equals(this.scenarioHashSum, enrichedCompound.scenarioHashSum) &&
        Objects.equals(this.systemId, enrichedCompound.systemId) &&
        Objects.equals(this.timeout, enrichedCompound.timeout) &&
        Objects.equals(this.type, enrichedCompound.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(childCompounds, comment, content, deprecated, directives, entity, flags, hidden, id, lineNumber, parameters, scenarioHashSum, systemId, timeout, type);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class EnrichedCompoundDto {\n");
    sb.append("    childCompounds: ").append(toIndentedString(childCompounds)).append("\n");
    sb.append("    comment: ").append(toIndentedString(comment)).append("\n");
    sb.append("    content: ").append(toIndentedString(content)).append("\n");
    sb.append("    deprecated: ").append(toIndentedString(deprecated)).append("\n");
    sb.append("    directives: ").append(toIndentedString(directives)).append("\n");
    sb.append("    entity: ").append(toIndentedString(entity)).append("\n");
    sb.append("    flags: ").append(toIndentedString(flags)).append("\n");
    sb.append("    hidden: ").append(toIndentedString(hidden)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    lineNumber: ").append(toIndentedString(lineNumber)).append("\n");
    sb.append("    parameters: ").append(toIndentedString(parameters)).append("\n");
    sb.append("    scenarioHashSum: ").append(toIndentedString(scenarioHashSum)).append("\n");
    sb.append("    systemId: ").append(toIndentedString(systemId)).append("\n");
    sb.append("    timeout: ").append(toIndentedString(timeout)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

