package org.qubership.atp.ram.clients.api.dto.catalogue;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.ArrayList;
import java.util.List;
import org.qubership.atp.ram.clients.api.dto.catalogue.JiraIssueDto;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * JiraIssueSearchResponseDto
 */

@JsonTypeName("JiraIssueSearchResponse")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2025-07-10T06:10:26.223992724Z[Etc/UTC]")
public class JiraIssueSearchResponseDto {

  @JsonProperty("issues")
  @Valid
  private List<JiraIssueDto> issues = null;

  public JiraIssueSearchResponseDto issues(List<JiraIssueDto> issues) {
    this.issues = issues;
    return this;
  }

  public JiraIssueSearchResponseDto addIssuesItem(JiraIssueDto issuesItem) {
    if (this.issues == null) {
      this.issues = new ArrayList<>();
    }
    this.issues.add(issuesItem);
    return this;
  }

  /**
   * Get issues
   * @return issues
  */
  @Valid 
  @Schema(name = "issues", required = false)
  public List<JiraIssueDto> getIssues() {
    return issues;
  }

  public void setIssues(List<JiraIssueDto> issues) {
    this.issues = issues;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    JiraIssueSearchResponseDto jiraIssueSearchResponse = (JiraIssueSearchResponseDto) o;
    return Objects.equals(this.issues, jiraIssueSearchResponse.issues);
  }

  @Override
  public int hashCode() {
    return Objects.hash(issues);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class JiraIssueSearchResponseDto {\n");
    sb.append("    issues: ").append(toIndentedString(issues)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

