package org.qubership.atp.ram.clients.api.dto.catalogue;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.qubership.atp.ram.clients.api.dto.catalogue.CompoundDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.TestPlanResponseDto;
import org.springframework.format.annotation.DateTimeFormat;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * QaDslLibraryResponseDto
 */

@JsonTypeName("QaDslLibraryResponse")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2025-07-10T06:10:26.804531712Z[Etc/UTC]")
public class QaDslLibraryResponseDto {

  @JsonProperty("compounds")
  @Valid
  private List<CompoundDto> compounds = null;

  @JsonProperty("modifiedWhen")
  @DateTimeFormat(iso = DateTimeFormat.ISO.DATE_TIME)
  private OffsetDateTime modifiedWhen;

  @JsonProperty("name")
  private String name;

  @JsonProperty("qaDslLibraryId")
  private UUID qaDslLibraryId;

  @JsonProperty("testPlan")
  @Valid
  private List<TestPlanResponseDto> testPlan = null;

  public QaDslLibraryResponseDto compounds(List<CompoundDto> compounds) {
    this.compounds = compounds;
    return this;
  }

  public QaDslLibraryResponseDto addCompoundsItem(CompoundDto compoundsItem) {
    if (this.compounds == null) {
      this.compounds = new ArrayList<>();
    }
    this.compounds.add(compoundsItem);
    return this;
  }

  /**
   * Get compounds
   * @return compounds
  */
  @Valid 
  @Schema(name = "compounds", required = false)
  public List<CompoundDto> getCompounds() {
    return compounds;
  }

  public void setCompounds(List<CompoundDto> compounds) {
    this.compounds = compounds;
  }

  public QaDslLibraryResponseDto modifiedWhen(OffsetDateTime modifiedWhen) {
    this.modifiedWhen = modifiedWhen;
    return this;
  }

  /**
   * Get modifiedWhen
   * @return modifiedWhen
  */
  @Valid 
  @Schema(name = "modifiedWhen", required = false)
  public OffsetDateTime getModifiedWhen() {
    return modifiedWhen;
  }

  public void setModifiedWhen(OffsetDateTime modifiedWhen) {
    this.modifiedWhen = modifiedWhen;
  }

  public QaDslLibraryResponseDto name(String name) {
    this.name = name;
    return this;
  }

  /**
   * Get name
   * @return name
  */
  
  @Schema(name = "name", required = false)
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public QaDslLibraryResponseDto qaDslLibraryId(UUID qaDslLibraryId) {
    this.qaDslLibraryId = qaDslLibraryId;
    return this;
  }

  /**
   * Get qaDslLibraryId
   * @return qaDslLibraryId
  */
  @Valid 
  @Schema(name = "qaDslLibraryId", required = false)
  public UUID getQaDslLibraryId() {
    return qaDslLibraryId;
  }

  public void setQaDslLibraryId(UUID qaDslLibraryId) {
    this.qaDslLibraryId = qaDslLibraryId;
  }

  public QaDslLibraryResponseDto testPlan(List<TestPlanResponseDto> testPlan) {
    this.testPlan = testPlan;
    return this;
  }

  public QaDslLibraryResponseDto addTestPlanItem(TestPlanResponseDto testPlanItem) {
    if (this.testPlan == null) {
      this.testPlan = new ArrayList<>();
    }
    this.testPlan.add(testPlanItem);
    return this;
  }

  /**
   * Get testPlan
   * @return testPlan
  */
  @Valid 
  @Schema(name = "testPlan", required = false)
  public List<TestPlanResponseDto> getTestPlan() {
    return testPlan;
  }

  public void setTestPlan(List<TestPlanResponseDto> testPlan) {
    this.testPlan = testPlan;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    QaDslLibraryResponseDto qaDslLibraryResponse = (QaDslLibraryResponseDto) o;
    return Objects.equals(this.compounds, qaDslLibraryResponse.compounds) &&
        Objects.equals(this.modifiedWhen, qaDslLibraryResponse.modifiedWhen) &&
        Objects.equals(this.name, qaDslLibraryResponse.name) &&
        Objects.equals(this.qaDslLibraryId, qaDslLibraryResponse.qaDslLibraryId) &&
        Objects.equals(this.testPlan, qaDslLibraryResponse.testPlan);
  }

  @Override
  public int hashCode() {
    return Objects.hash(compounds, modifiedWhen, name, qaDslLibraryId, testPlan);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class QaDslLibraryResponseDto {\n");
    sb.append("    compounds: ").append(toIndentedString(compounds)).append("\n");
    sb.append("    modifiedWhen: ").append(toIndentedString(modifiedWhen)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    qaDslLibraryId: ").append(toIndentedString(qaDslLibraryId)).append("\n");
    sb.append("    testPlan: ").append(toIndentedString(testPlan)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

