package org.qubership.atp.ram.clients.api.dto.catalogue;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * RerunRequestDto
 */

@JsonTypeName("RerunRequest")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2025-07-10T06:10:29.480505068Z[Etc/UTC]")
public class RerunRequestDto {

  @JsonProperty("emailRecipients")
  @Valid
  private List<String> emailRecipients = null;

  @JsonProperty("environmentId")
  private UUID environmentId;

  @JsonProperty("executionRequestId")
  private UUID executionRequestId;

  @JsonProperty("projectId")
  private UUID projectId;

  @JsonProperty("recompilation")
  private Boolean recompilation;

  @JsonProperty("scopeId")
  private UUID scopeId;

  @JsonProperty("taToolsGroupId")
  private UUID taToolsGroupId;

  @JsonProperty("testRunIds")
  @Valid
  private List<UUID> testRunIds = null;

  @JsonProperty("threads")
  private Integer threads;

  public RerunRequestDto emailRecipients(List<String> emailRecipients) {
    this.emailRecipients = emailRecipients;
    return this;
  }

  public RerunRequestDto addEmailRecipientsItem(String emailRecipientsItem) {
    if (this.emailRecipients == null) {
      this.emailRecipients = new ArrayList<>();
    }
    this.emailRecipients.add(emailRecipientsItem);
    return this;
  }

  /**
   * Get emailRecipients
   * @return emailRecipients
  */
  
  @Schema(name = "emailRecipients", required = false)
  public List<String> getEmailRecipients() {
    return emailRecipients;
  }

  public void setEmailRecipients(List<String> emailRecipients) {
    this.emailRecipients = emailRecipients;
  }

  public RerunRequestDto environmentId(UUID environmentId) {
    this.environmentId = environmentId;
    return this;
  }

  /**
   * Get environmentId
   * @return environmentId
  */
  @Valid 
  @Schema(name = "environmentId", required = false)
  public UUID getEnvironmentId() {
    return environmentId;
  }

  public void setEnvironmentId(UUID environmentId) {
    this.environmentId = environmentId;
  }

  public RerunRequestDto executionRequestId(UUID executionRequestId) {
    this.executionRequestId = executionRequestId;
    return this;
  }

  /**
   * Get executionRequestId
   * @return executionRequestId
  */
  @Valid 
  @Schema(name = "executionRequestId", required = false)
  public UUID getExecutionRequestId() {
    return executionRequestId;
  }

  public void setExecutionRequestId(UUID executionRequestId) {
    this.executionRequestId = executionRequestId;
  }

  public RerunRequestDto projectId(UUID projectId) {
    this.projectId = projectId;
    return this;
  }

  /**
   * Get projectId
   * @return projectId
  */
  @Valid 
  @Schema(name = "projectId", required = false)
  public UUID getProjectId() {
    return projectId;
  }

  public void setProjectId(UUID projectId) {
    this.projectId = projectId;
  }

  public RerunRequestDto recompilation(Boolean recompilation) {
    this.recompilation = recompilation;
    return this;
  }

  /**
   * Get recompilation
   * @return recompilation
  */
  
  @Schema(name = "recompilation", required = false)
  public Boolean getRecompilation() {
    return recompilation;
  }

  public void setRecompilation(Boolean recompilation) {
    this.recompilation = recompilation;
  }

  public RerunRequestDto scopeId(UUID scopeId) {
    this.scopeId = scopeId;
    return this;
  }

  /**
   * Get scopeId
   * @return scopeId
  */
  @Valid 
  @Schema(name = "scopeId", required = false)
  public UUID getScopeId() {
    return scopeId;
  }

  public void setScopeId(UUID scopeId) {
    this.scopeId = scopeId;
  }

  public RerunRequestDto taToolsGroupId(UUID taToolsGroupId) {
    this.taToolsGroupId = taToolsGroupId;
    return this;
  }

  /**
   * Get taToolsGroupId
   * @return taToolsGroupId
  */
  @Valid 
  @Schema(name = "taToolsGroupId", required = false)
  public UUID getTaToolsGroupId() {
    return taToolsGroupId;
  }

  public void setTaToolsGroupId(UUID taToolsGroupId) {
    this.taToolsGroupId = taToolsGroupId;
  }

  public RerunRequestDto testRunIds(List<UUID> testRunIds) {
    this.testRunIds = testRunIds;
    return this;
  }

  public RerunRequestDto addTestRunIdsItem(UUID testRunIdsItem) {
    if (this.testRunIds == null) {
      this.testRunIds = new ArrayList<>();
    }
    this.testRunIds.add(testRunIdsItem);
    return this;
  }

  /**
   * Get testRunIds
   * @return testRunIds
  */
  @Valid 
  @Schema(name = "testRunIds", required = false)
  public List<UUID> getTestRunIds() {
    return testRunIds;
  }

  public void setTestRunIds(List<UUID> testRunIds) {
    this.testRunIds = testRunIds;
  }

  public RerunRequestDto threads(Integer threads) {
    this.threads = threads;
    return this;
  }

  /**
   * Get threads
   * @return threads
  */
  
  @Schema(name = "threads", required = false)
  public Integer getThreads() {
    return threads;
  }

  public void setThreads(Integer threads) {
    this.threads = threads;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    RerunRequestDto rerunRequest = (RerunRequestDto) o;
    return Objects.equals(this.emailRecipients, rerunRequest.emailRecipients) &&
        Objects.equals(this.environmentId, rerunRequest.environmentId) &&
        Objects.equals(this.executionRequestId, rerunRequest.executionRequestId) &&
        Objects.equals(this.projectId, rerunRequest.projectId) &&
        Objects.equals(this.recompilation, rerunRequest.recompilation) &&
        Objects.equals(this.scopeId, rerunRequest.scopeId) &&
        Objects.equals(this.taToolsGroupId, rerunRequest.taToolsGroupId) &&
        Objects.equals(this.testRunIds, rerunRequest.testRunIds) &&
        Objects.equals(this.threads, rerunRequest.threads);
  }

  @Override
  public int hashCode() {
    return Objects.hash(emailRecipients, environmentId, executionRequestId, projectId, recompilation, scopeId, taToolsGroupId, testRunIds, threads);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class RerunRequestDto {\n");
    sb.append("    emailRecipients: ").append(toIndentedString(emailRecipients)).append("\n");
    sb.append("    environmentId: ").append(toIndentedString(environmentId)).append("\n");
    sb.append("    executionRequestId: ").append(toIndentedString(executionRequestId)).append("\n");
    sb.append("    projectId: ").append(toIndentedString(projectId)).append("\n");
    sb.append("    recompilation: ").append(toIndentedString(recompilation)).append("\n");
    sb.append("    scopeId: ").append(toIndentedString(scopeId)).append("\n");
    sb.append("    taToolsGroupId: ").append(toIndentedString(taToolsGroupId)).append("\n");
    sb.append("    testRunIds: ").append(toIndentedString(testRunIds)).append("\n");
    sb.append("    threads: ").append(toIndentedString(threads)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

