package org.qubership.atp.ram.clients.api.dto.catalogue;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * TestCaseFlagsDto
 */

@JsonTypeName("TestCaseFlags")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2025-07-10T06:10:27.942622368Z[Etc/UTC]")
public class TestCaseFlagsDto {

  /**
   * Gets or Sets flags
   */
  public enum FlagsEnum {
    COLLECT_LOGS("COLLECT_LOGS"),
    
    COLLECT_LOGS_ON_FAIL("COLLECT_LOGS_ON_FAIL"),
    
    COLLECT_LOGS_ON_SKIPPED("COLLECT_LOGS_ON_SKIPPED"),
    
    COLLECT_LOGS_ON_WARNING("COLLECT_LOGS_ON_WARNING"),
    
    DO_NOT_PASS_INITIAL_CONTEXT("DO_NOT_PASS_INITIAL_CONTEXT"),
    
    EXECUTE_ANYWAY("EXECUTE_ANYWAY"),
    
    FAIL_IMMEDIATELY("FAIL_IMMEDIATELY"),
    
    IGNORE_PREREQUISITE_IN_PASS_RATE("IGNORE_PREREQUISITE_IN_PASS_RATE"),
    
    IGNORE_VALIDATION_IN_PASS_RATE("IGNORE_VALIDATION_IN_PASS_RATE"),
    
    INVERT_RESULT("INVERT_RESULT"),
    
    SKIP("SKIP"),
    
    SKIP_IF_DEPENDENCIES_FAIL("SKIP_IF_DEPENDENCIES_FAIL"),
    
    STOP_ON_FAIL("STOP_ON_FAIL"),
    
    SKIP_ON_PASS("SKIP_ON_PASS"),
    
    TERMINATE_IF_FAIL("TERMINATE_IF_FAIL"),
    
    TERMINATE_IF_PREREQUISITE_FAIL("TERMINATE_IF_PREREQUISITE_FAIL"),
    
    COLLECT_SSM_METRICS_ON_FAIL("COLLECT_SSM_METRICS_ON_FAIL");

    private String value;

    FlagsEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static FlagsEnum fromValue(String value) {
      for (FlagsEnum b : FlagsEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  @JsonProperty("flags")
  @Valid
  private List<FlagsEnum> flags = null;

  @JsonProperty("testScopeId")
  private UUID testScopeId;

  public TestCaseFlagsDto flags(List<FlagsEnum> flags) {
    this.flags = flags;
    return this;
  }

  public TestCaseFlagsDto addFlagsItem(FlagsEnum flagsItem) {
    if (this.flags == null) {
      this.flags = new ArrayList<>();
    }
    this.flags.add(flagsItem);
    return this;
  }

  /**
   * Get flags
   * @return flags
  */
  
  @Schema(name = "flags", required = false)
  public List<FlagsEnum> getFlags() {
    return flags;
  }

  public void setFlags(List<FlagsEnum> flags) {
    this.flags = flags;
  }

  public TestCaseFlagsDto testScopeId(UUID testScopeId) {
    this.testScopeId = testScopeId;
    return this;
  }

  /**
   * Get testScopeId
   * @return testScopeId
  */
  @Valid 
  @Schema(name = "testScopeId", required = false)
  public UUID getTestScopeId() {
    return testScopeId;
  }

  public void setTestScopeId(UUID testScopeId) {
    this.testScopeId = testScopeId;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TestCaseFlagsDto testCaseFlags = (TestCaseFlagsDto) o;
    return Objects.equals(this.flags, testCaseFlags.flags) &&
        Objects.equals(this.testScopeId, testCaseFlags.testScopeId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(flags, testScopeId);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TestCaseFlagsDto {\n");
    sb.append("    flags: ").append(toIndentedString(flags)).append("\n");
    sb.append("    testScopeId: ").append(toIndentedString(testScopeId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

