package org.qubership.atp.ram.clients.api.dto.catalogue;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.ArrayList;
import java.util.List;
import org.qubership.atp.ram.clients.api.dto.catalogue.TestCaseGroupResponseDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.TestScenarioGroupResponseDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.TestScopeDto;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * TestPlanEntitiesResponseDto
 */

@JsonTypeName("TestPlanEntitiesResponse")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2025-07-10T06:10:27.942622368Z[Etc/UTC]")
public class TestPlanEntitiesResponseDto {

  @JsonProperty("casesOutOfScope")
  private TestCaseGroupResponseDto casesOutOfScope;

  @JsonProperty("scenariosOutOfCase")
  private TestScenarioGroupResponseDto scenariosOutOfCase;

  @JsonProperty("testScopes")
  @Valid
  private List<TestScopeDto> testScopes = null;

  public TestPlanEntitiesResponseDto casesOutOfScope(TestCaseGroupResponseDto casesOutOfScope) {
    this.casesOutOfScope = casesOutOfScope;
    return this;
  }

  /**
   * Get casesOutOfScope
   * @return casesOutOfScope
  */
  @Valid 
  @Schema(name = "casesOutOfScope", required = false)
  public TestCaseGroupResponseDto getCasesOutOfScope() {
    return casesOutOfScope;
  }

  public void setCasesOutOfScope(TestCaseGroupResponseDto casesOutOfScope) {
    this.casesOutOfScope = casesOutOfScope;
  }

  public TestPlanEntitiesResponseDto scenariosOutOfCase(TestScenarioGroupResponseDto scenariosOutOfCase) {
    this.scenariosOutOfCase = scenariosOutOfCase;
    return this;
  }

  /**
   * Get scenariosOutOfCase
   * @return scenariosOutOfCase
  */
  @Valid 
  @Schema(name = "scenariosOutOfCase", required = false)
  public TestScenarioGroupResponseDto getScenariosOutOfCase() {
    return scenariosOutOfCase;
  }

  public void setScenariosOutOfCase(TestScenarioGroupResponseDto scenariosOutOfCase) {
    this.scenariosOutOfCase = scenariosOutOfCase;
  }

  public TestPlanEntitiesResponseDto testScopes(List<TestScopeDto> testScopes) {
    this.testScopes = testScopes;
    return this;
  }

  public TestPlanEntitiesResponseDto addTestScopesItem(TestScopeDto testScopesItem) {
    if (this.testScopes == null) {
      this.testScopes = new ArrayList<>();
    }
    this.testScopes.add(testScopesItem);
    return this;
  }

  /**
   * Get testScopes
   * @return testScopes
  */
  @Valid 
  @Schema(name = "testScopes", required = false)
  public List<TestScopeDto> getTestScopes() {
    return testScopes;
  }

  public void setTestScopes(List<TestScopeDto> testScopes) {
    this.testScopes = testScopes;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TestPlanEntitiesResponseDto testPlanEntitiesResponse = (TestPlanEntitiesResponseDto) o;
    return Objects.equals(this.casesOutOfScope, testPlanEntitiesResponse.casesOutOfScope) &&
        Objects.equals(this.scenariosOutOfCase, testPlanEntitiesResponse.scenariosOutOfCase) &&
        Objects.equals(this.testScopes, testPlanEntitiesResponse.testScopes);
  }

  @Override
  public int hashCode() {
    return Objects.hash(casesOutOfScope, scenariosOutOfCase, testScopes);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TestPlanEntitiesResponseDto {\n");
    sb.append("    casesOutOfScope: ").append(toIndentedString(casesOutOfScope)).append("\n");
    sb.append("    scenariosOutOfCase: ").append(toIndentedString(scenariosOutOfCase)).append("\n");
    sb.append("    testScopes: ").append(toIndentedString(testScopes)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

