package org.qubership.atp.ram.clients.api.dto.catalogue;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.qubership.atp.ram.clients.api.dto.catalogue.MetaInfoDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.UserInfoDto;
import org.springframework.format.annotation.DateTimeFormat;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * TestScenarioEditorResponseDto
 */

@JsonTypeName("TestScenarioEditorResponse")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2025-07-10T06:10:28.754468223Z[Etc/UTC]")
public class TestScenarioEditorResponseDto {

  @JsonProperty("id")
  private UUID id;

  @JsonProperty("metainfo")
  @Valid
  private List<MetaInfoDto> metainfo = null;

  @JsonProperty("modifiedBy")
  private UserInfoDto modifiedBy;

  @JsonProperty("modifiedWhen")
  @DateTimeFormat(iso = DateTimeFormat.ISO.DATE_TIME)
  private OffsetDateTime modifiedWhen;

  @JsonProperty("name")
  private String name;

  @JsonProperty("projectUuid")
  private UUID projectUuid;

  @JsonProperty("testPlanUuid")
  private UUID testPlanUuid;

  /**
   * Gets or Sets type
   */
  public enum TypeEnum {
    COMPOUND("COMPOUND"),
    
    TESTSCENARIO("TESTSCENARIO");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  @JsonProperty("type")
  private TypeEnum type;

  public TestScenarioEditorResponseDto id(UUID id) {
    this.id = id;
    return this;
  }

  /**
   * Get id
   * @return id
  */
  @Valid 
  @Schema(name = "id", required = false)
  public UUID getId() {
    return id;
  }

  public void setId(UUID id) {
    this.id = id;
  }

  public TestScenarioEditorResponseDto metainfo(List<MetaInfoDto> metainfo) {
    this.metainfo = metainfo;
    return this;
  }

  public TestScenarioEditorResponseDto addMetainfoItem(MetaInfoDto metainfoItem) {
    if (this.metainfo == null) {
      this.metainfo = new ArrayList<>();
    }
    this.metainfo.add(metainfoItem);
    return this;
  }

  /**
   * Get metainfo
   * @return metainfo
  */
  @Valid 
  @Schema(name = "metainfo", required = false)
  public List<MetaInfoDto> getMetainfo() {
    return metainfo;
  }

  public void setMetainfo(List<MetaInfoDto> metainfo) {
    this.metainfo = metainfo;
  }

  public TestScenarioEditorResponseDto modifiedBy(UserInfoDto modifiedBy) {
    this.modifiedBy = modifiedBy;
    return this;
  }

  /**
   * Get modifiedBy
   * @return modifiedBy
  */
  @Valid 
  @Schema(name = "modifiedBy", required = false)
  public UserInfoDto getModifiedBy() {
    return modifiedBy;
  }

  public void setModifiedBy(UserInfoDto modifiedBy) {
    this.modifiedBy = modifiedBy;
  }

  public TestScenarioEditorResponseDto modifiedWhen(OffsetDateTime modifiedWhen) {
    this.modifiedWhen = modifiedWhen;
    return this;
  }

  /**
   * Get modifiedWhen
   * @return modifiedWhen
  */
  @Valid 
  @Schema(name = "modifiedWhen", required = false)
  public OffsetDateTime getModifiedWhen() {
    return modifiedWhen;
  }

  public void setModifiedWhen(OffsetDateTime modifiedWhen) {
    this.modifiedWhen = modifiedWhen;
  }

  public TestScenarioEditorResponseDto name(String name) {
    this.name = name;
    return this;
  }

  /**
   * Get name
   * @return name
  */
  
  @Schema(name = "name", required = false)
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public TestScenarioEditorResponseDto projectUuid(UUID projectUuid) {
    this.projectUuid = projectUuid;
    return this;
  }

  /**
   * Get projectUuid
   * @return projectUuid
  */
  @Valid 
  @Schema(name = "projectUuid", required = false)
  public UUID getProjectUuid() {
    return projectUuid;
  }

  public void setProjectUuid(UUID projectUuid) {
    this.projectUuid = projectUuid;
  }

  public TestScenarioEditorResponseDto testPlanUuid(UUID testPlanUuid) {
    this.testPlanUuid = testPlanUuid;
    return this;
  }

  /**
   * Get testPlanUuid
   * @return testPlanUuid
  */
  @Valid 
  @Schema(name = "testPlanUuid", required = false)
  public UUID getTestPlanUuid() {
    return testPlanUuid;
  }

  public void setTestPlanUuid(UUID testPlanUuid) {
    this.testPlanUuid = testPlanUuid;
  }

  public TestScenarioEditorResponseDto type(TypeEnum type) {
    this.type = type;
    return this;
  }

  /**
   * Get type
   * @return type
  */
  
  @Schema(name = "type", required = false)
  public TypeEnum getType() {
    return type;
  }

  public void setType(TypeEnum type) {
    this.type = type;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TestScenarioEditorResponseDto testScenarioEditorResponse = (TestScenarioEditorResponseDto) o;
    return Objects.equals(this.id, testScenarioEditorResponse.id) &&
        Objects.equals(this.metainfo, testScenarioEditorResponse.metainfo) &&
        Objects.equals(this.modifiedBy, testScenarioEditorResponse.modifiedBy) &&
        Objects.equals(this.modifiedWhen, testScenarioEditorResponse.modifiedWhen) &&
        Objects.equals(this.name, testScenarioEditorResponse.name) &&
        Objects.equals(this.projectUuid, testScenarioEditorResponse.projectUuid) &&
        Objects.equals(this.testPlanUuid, testScenarioEditorResponse.testPlanUuid) &&
        Objects.equals(this.type, testScenarioEditorResponse.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, metainfo, modifiedBy, modifiedWhen, name, projectUuid, testPlanUuid, type);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TestScenarioEditorResponseDto {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    metainfo: ").append(toIndentedString(metainfo)).append("\n");
    sb.append("    modifiedBy: ").append(toIndentedString(modifiedBy)).append("\n");
    sb.append("    modifiedWhen: ").append(toIndentedString(modifiedWhen)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    projectUuid: ").append(toIndentedString(projectUuid)).append("\n");
    sb.append("    testPlanUuid: ").append(toIndentedString(testPlanUuid)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

