/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.clients.dto;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import javax.validation.Valid;
import org.qubership.atp.dataset.clients.dto.AbstractParameterDto;
import org.qubership.atp.dataset.clients.dto.AttributeTypeDto;

@JsonTypeName(value="DataSetGroup")
public class DataSetGroupDto {
    @JsonProperty(value="dataSetId")
    private UUID dataSetId;
    @JsonProperty(value="dsl")
    private String dsl;
    @JsonProperty(value="groups")
    @Valid
    private Map<String, DataSetGroupDto> groups = null;
    @JsonProperty(value="parameters")
    @Valid
    private Map<String, AbstractParameterDto> parameters = null;
    @JsonProperty(value="type")
    private AttributeTypeDto type;
    @JsonProperty(value="value")
    private String value;

    public DataSetGroupDto dataSetId(UUID dataSetId) {
        this.dataSetId = dataSetId;
        return this;
    }

    @Valid
    @Schema(name="dataSetId", required=false)
    public UUID getDataSetId() {
        return this.dataSetId;
    }

    public void setDataSetId(UUID dataSetId) {
        this.dataSetId = dataSetId;
    }

    public DataSetGroupDto dsl(String dsl) {
        this.dsl = dsl;
        return this;
    }

    @Schema(name="dsl", required=false)
    public String getDsl() {
        return this.dsl;
    }

    public void setDsl(String dsl) {
        this.dsl = dsl;
    }

    public DataSetGroupDto groups(Map<String, DataSetGroupDto> groups) {
        this.groups = groups;
        return this;
    }

    public DataSetGroupDto putGroupsItem(String key, DataSetGroupDto groupsItem) {
        if (this.groups == null) {
            this.groups = new HashMap<String, DataSetGroupDto>();
        }
        this.groups.put(key, groupsItem);
        return this;
    }

    @Valid
    @Schema(name="groups", required=false)
    public Map<String, DataSetGroupDto> getGroups() {
        return this.groups;
    }

    public void setGroups(Map<String, DataSetGroupDto> groups) {
        this.groups = groups;
    }

    public DataSetGroupDto parameters(Map<String, AbstractParameterDto> parameters) {
        this.parameters = parameters;
        return this;
    }

    public DataSetGroupDto putParametersItem(String key, AbstractParameterDto parametersItem) {
        if (this.parameters == null) {
            this.parameters = new HashMap<String, AbstractParameterDto>();
        }
        this.parameters.put(key, parametersItem);
        return this;
    }

    @Valid
    @Schema(name="parameters", required=false)
    public Map<String, AbstractParameterDto> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, AbstractParameterDto> parameters) {
        this.parameters = parameters;
    }

    public DataSetGroupDto type(AttributeTypeDto type) {
        this.type = type;
        return this;
    }

    @Valid
    @Schema(name="type", required=false)
    public AttributeTypeDto getType() {
        return this.type;
    }

    public void setType(AttributeTypeDto type) {
        this.type = type;
    }

    public DataSetGroupDto value(String value) {
        this.value = value;
        return this;
    }

    @Schema(name="value", required=false)
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataSetGroupDto dataSetGroup = (DataSetGroupDto)o;
        return Objects.equals(this.dataSetId, dataSetGroup.dataSetId) && Objects.equals(this.dsl, dataSetGroup.dsl) && Objects.equals(this.groups, dataSetGroup.groups) && Objects.equals(this.parameters, dataSetGroup.parameters) && Objects.equals((Object)this.type, (Object)dataSetGroup.type) && Objects.equals(this.value, dataSetGroup.value);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.dataSetId, this.dsl, this.groups, this.parameters, this.type, this.value});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DataSetGroupDto {\n");
        sb.append("    dataSetId: ").append(this.toIndentedString(this.dataSetId)).append("\n");
        sb.append("    dsl: ").append(this.toIndentedString(this.dsl)).append("\n");
        sb.append("    groups: ").append(this.toIndentedString(this.groups)).append("\n");
        sb.append("    parameters: ").append(this.toIndentedString(this.parameters)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

