/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.clients.dto;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.qubership.atp.dataset.clients.dto.AttributeDto;
import org.qubership.atp.dataset.clients.dto.DataSetDto;
import org.qubership.atp.dataset.clients.dto.LabelDto;
import org.qubership.atp.dataset.clients.dto.TestPlanDto;
import org.qubership.atp.dataset.clients.dto.VisibilityAreaDto;
import org.springframework.format.annotation.DateTimeFormat;

@JsonTypeName(value="DataSetList")
public class DataSetListDto {
    @JsonProperty(value="attributes")
    @Valid
    private List<AttributeDto> attributes = null;
    @JsonProperty(value="createdBy")
    private UUID createdBy;
    @JsonProperty(value="createdWhen")
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME)
    private OffsetDateTime createdWhen;
    @JsonProperty(value="dataSets")
    @Valid
    private List<DataSetDto> dataSets = null;
    @JsonProperty(value="id")
    private UUID id;
    @JsonProperty(value="labels")
    @Valid
    private List<LabelDto> labels = null;
    @JsonProperty(value="modifiedBy")
    private UUID modifiedBy;
    @JsonProperty(value="modifiedWhen")
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME)
    private OffsetDateTime modifiedWhen;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="testPlan")
    private TestPlanDto testPlan;
    @JsonProperty(value="visibilityArea")
    private VisibilityAreaDto visibilityArea;

    public DataSetListDto attributes(List<AttributeDto> attributes) {
        this.attributes = attributes;
        return this;
    }

    public DataSetListDto addAttributesItem(AttributeDto attributesItem) {
        if (this.attributes == null) {
            this.attributes = new ArrayList<AttributeDto>();
        }
        this.attributes.add(attributesItem);
        return this;
    }

    @Valid
    @Schema(name="attributes", required=false)
    public List<AttributeDto> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(List<AttributeDto> attributes) {
        this.attributes = attributes;
    }

    public DataSetListDto createdBy(UUID createdBy) {
        this.createdBy = createdBy;
        return this;
    }

    @Valid
    @Schema(name="createdBy", required=false)
    public UUID getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(UUID createdBy) {
        this.createdBy = createdBy;
    }

    public DataSetListDto createdWhen(OffsetDateTime createdWhen) {
        this.createdWhen = createdWhen;
        return this;
    }

    @Valid
    @Schema(name="createdWhen", required=false)
    public OffsetDateTime getCreatedWhen() {
        return this.createdWhen;
    }

    public void setCreatedWhen(OffsetDateTime createdWhen) {
        this.createdWhen = createdWhen;
    }

    public DataSetListDto dataSets(List<DataSetDto> dataSets) {
        this.dataSets = dataSets;
        return this;
    }

    public DataSetListDto addDataSetsItem(DataSetDto dataSetsItem) {
        if (this.dataSets == null) {
            this.dataSets = new ArrayList<DataSetDto>();
        }
        this.dataSets.add(dataSetsItem);
        return this;
    }

    @Valid
    @Schema(name="dataSets", required=false)
    public List<DataSetDto> getDataSets() {
        return this.dataSets;
    }

    public void setDataSets(List<DataSetDto> dataSets) {
        this.dataSets = dataSets;
    }

    public DataSetListDto id(UUID id) {
        this.id = id;
        return this;
    }

    @NotNull
    @Valid
    @Schema(name="id", required=true)
    public UUID getId() {
        return this.id;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public DataSetListDto labels(List<LabelDto> labels) {
        this.labels = labels;
        return this;
    }

    public DataSetListDto addLabelsItem(LabelDto labelsItem) {
        if (this.labels == null) {
            this.labels = new ArrayList<LabelDto>();
        }
        this.labels.add(labelsItem);
        return this;
    }

    @Valid
    @Schema(name="labels", required=false)
    public List<LabelDto> getLabels() {
        return this.labels;
    }

    public void setLabels(List<LabelDto> labels) {
        this.labels = labels;
    }

    public DataSetListDto modifiedBy(UUID modifiedBy) {
        this.modifiedBy = modifiedBy;
        return this;
    }

    @Valid
    @Schema(name="modifiedBy", required=false)
    public UUID getModifiedBy() {
        return this.modifiedBy;
    }

    public void setModifiedBy(UUID modifiedBy) {
        this.modifiedBy = modifiedBy;
    }

    public DataSetListDto modifiedWhen(OffsetDateTime modifiedWhen) {
        this.modifiedWhen = modifiedWhen;
        return this;
    }

    @Valid
    @Schema(name="modifiedWhen", required=false)
    public OffsetDateTime getModifiedWhen() {
        return this.modifiedWhen;
    }

    public void setModifiedWhen(OffsetDateTime modifiedWhen) {
        this.modifiedWhen = modifiedWhen;
    }

    public DataSetListDto name(String name) {
        this.name = name;
        return this;
    }

    @NotNull
    @Schema(name="name", required=true)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public DataSetListDto testPlan(TestPlanDto testPlan) {
        this.testPlan = testPlan;
        return this;
    }

    @Valid
    @Schema(name="testPlan", required=false)
    public TestPlanDto getTestPlan() {
        return this.testPlan;
    }

    public void setTestPlan(TestPlanDto testPlan) {
        this.testPlan = testPlan;
    }

    public DataSetListDto visibilityArea(VisibilityAreaDto visibilityArea) {
        this.visibilityArea = visibilityArea;
        return this;
    }

    @NotNull
    @Valid
    @Schema(name="visibilityArea", required=true)
    public VisibilityAreaDto getVisibilityArea() {
        return this.visibilityArea;
    }

    public void setVisibilityArea(VisibilityAreaDto visibilityArea) {
        this.visibilityArea = visibilityArea;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataSetListDto dataSetList = (DataSetListDto)o;
        return Objects.equals(this.attributes, dataSetList.attributes) && Objects.equals(this.createdBy, dataSetList.createdBy) && Objects.equals(this.createdWhen, dataSetList.createdWhen) && Objects.equals(this.dataSets, dataSetList.dataSets) && Objects.equals(this.id, dataSetList.id) && Objects.equals(this.labels, dataSetList.labels) && Objects.equals(this.modifiedBy, dataSetList.modifiedBy) && Objects.equals(this.modifiedWhen, dataSetList.modifiedWhen) && Objects.equals(this.name, dataSetList.name) && Objects.equals(this.testPlan, dataSetList.testPlan) && Objects.equals(this.visibilityArea, dataSetList.visibilityArea);
    }

    public int hashCode() {
        return Objects.hash(this.attributes, this.createdBy, this.createdWhen, this.dataSets, this.id, this.labels, this.modifiedBy, this.modifiedWhen, this.name, this.testPlan, this.visibilityArea);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DataSetListDto {\n");
        sb.append("    attributes: ").append(this.toIndentedString(this.attributes)).append("\n");
        sb.append("    createdBy: ").append(this.toIndentedString(this.createdBy)).append("\n");
        sb.append("    createdWhen: ").append(this.toIndentedString(this.createdWhen)).append("\n");
        sb.append("    dataSets: ").append(this.toIndentedString(this.dataSets)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    labels: ").append(this.toIndentedString(this.labels)).append("\n");
        sb.append("    modifiedBy: ").append(this.toIndentedString(this.modifiedBy)).append("\n");
        sb.append("    modifiedWhen: ").append(this.toIndentedString(this.modifiedWhen)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    testPlan: ").append(this.toIndentedString(this.testPlan)).append("\n");
        sb.append("    visibilityArea: ").append(this.toIndentedString(this.visibilityArea)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

