/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ram.clients.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import java.util.UUID;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.qubership.atp.ram.clients.api.dto.catalogue.LabelTemplateDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.LabelTemplateFilteringRequestBodyDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.PaginationResponseDto;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Validated
@Tag(name="LabelTemplateController", description="Label Template Controller")
public interface LabelTemplateControllerApi {
    @Operation(operationId="create", summary="create", tags={"label-template-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=UUID.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/catalog/api/v1/label-templates"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<UUID> create(@Parameter(name="LabelTemplateDto", description="") @Valid @RequestBody(required=false) LabelTemplateDto var1);

    @Operation(operationId="delete", summary="delete", tags={"label-template-controller"}, responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="204", description="No Content"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden")})
    @RequestMapping(method={RequestMethod.DELETE}, value={"/catalog/api/v1/label-templates/{id}"})
    public ResponseEntity<Void> delete(@Parameter(name="id", description="id", required=true) @PathVariable(value="id") UUID var1);

    @Operation(operationId="get", summary="get", tags={"label-template-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=LabelTemplateDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/catalog/api/v1/label-templates/{id}"}, produces={"application/json"})
    public ResponseEntity<LabelTemplateDto> get(@Parameter(name="id", description="id", required=true) @PathVariable(value="id") UUID var1);

    @Operation(operationId="getAll", summary="getAll", tags={"label-template-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=LabelTemplateDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/catalog/api/v1/label-templates"}, produces={"application/json"})
    public ResponseEntity<List<LabelTemplateDto>> getAll(@NotNull @Parameter(name="projectId", description="projectId", required=true) @Valid @RequestParam(value="projectId", required=true) UUID var1);

    @Operation(operationId="search", summary="search", tags={"label-template-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=PaginationResponseDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/catalog/api/v1/label-templates/search"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<List<PaginationResponseDto>> search(@NotNull @Parameter(name="projectId", description="projectId", required=true) @Valid @RequestParam(value="projectId", required=true) UUID var1, @NotNull @Parameter(name="page", description="page number", required=true) @Valid @RequestParam(value="page", required=true) Integer var2, @NotNull @Parameter(name="size", description="size number", required=true) @Valid @RequestParam(value="size", required=true) Integer var3, @Parameter(name="LabelTemplateFilteringRequestBodyDto", description="") @Valid @RequestBody(required=false) LabelTemplateFilteringRequestBodyDto var4);

    @Operation(operationId="update", summary="update", tags={"label-template-controller"}, responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.PUT}, value={"/catalog/api/v1/label-templates/{id}"}, consumes={"application/json"})
    public ResponseEntity<Void> update(@Parameter(name="id", description="id", required=true) @PathVariable(value="id") UUID var1, @Parameter(name="LabelTemplateDto", description="") @Valid @RequestBody(required=false) LabelTemplateDto var2);
}

