/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ram.clients.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.qubership.atp.ram.clients.api.dto.catalogue.AbstractTestScenarioDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.ActionDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.ActionGroupByTypeCompoundEntryDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.CertificateDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.CompoundDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.LabelDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.ProjectDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.ProjectFlagsResponseDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.QaDslLibraryResponseDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.TestCaseDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.TestCaseGroupDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.TestPlanDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.TestScenarioDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.TestScopeDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.UserGroupDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.UserInfoDto;
import org.springframework.core.io.Resource;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Validated
@Tag(name="ProjectController", description="Project Controller")
public interface ProjectControllerApi {
    @Operation(operationId="checkFlags", summary="checkFlags", tags={"project-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=ProjectFlagsResponseDto.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/catalog/api/v1/projects/{uuid}/checkFlags"}, produces={"application/json"})
    public ResponseEntity<ProjectFlagsResponseDto> checkFlags(@Parameter(name="uuid", description="uuid", required=true) @PathVariable(value="uuid") UUID var1);

    @Operation(operationId="create", summary="create", tags={"project-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=UUID.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/catalog/api/v1/projects/create"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<UUID> create(@Parameter(name="ProjectDto", description="") @Valid @RequestBody(required=false) ProjectDto var1);

    @Operation(operationId="deleteUserFromProject", summary="deleteUserFromProject", tags={"project-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=ProjectDto.class))}), @ApiResponse(responseCode="204", description="No Content"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden")})
    @RequestMapping(method={RequestMethod.DELETE}, value={"/catalog/api/v1/projects/{uuid}/users/{usersuuid}"}, produces={"application/json"})
    public ResponseEntity<ProjectDto> deleteUserFromProject(@Parameter(name="uuid", description="uuid", required=true) @PathVariable(value="uuid") UUID var1, @Parameter(name="usersuuid", description="usersuuid", required=true) @PathVariable(value="usersuuid") UUID var2);

    @Operation(operationId="downloadFile", summary="downloadFile", tags={"project-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/octet-stream", schema=@Schema(implementation=Resource.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/catalog/api/v1/projects/downloadFile/{fileId}"}, produces={"application/octet-stream"})
    public ResponseEntity<Resource> downloadFile(@Parameter(name="fileId", description="fileId", required=true) @PathVariable(value="fileId") String var1);

    @Operation(operationId="getActionsByProjectId", summary="getActionsByProjectId", tags={"project-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=ActionDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/catalog/api/v1/projects/{uuid}/compound"}, produces={"application/json"})
    public ResponseEntity<List<ActionDto>> getActionsByProjectId(@Parameter(name="uuid", description="uuid", required=true) @PathVariable(value="uuid") UUID var1);

    @Operation(operationId="getActionsByProjectUuidGroupedByActionType", summary="getActionsByProjectUuidGroupedByActionType", tags={"project-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=ActionGroupByTypeCompoundEntryDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/catalog/api/v1/projects/{uuid}/actions/group-by-type-action"}, produces={"application/json"})
    public ResponseEntity<List<ActionGroupByTypeCompoundEntryDto>> getActionsByProjectUuidGroupedByActionType(@Parameter(name="uuid", description="uuid", required=true) @PathVariable(value="uuid") UUID var1);

    @Operation(operationId="getAll", summary="getAll", tags={"project-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=ProjectDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/catalog/api/v1/projects"}, produces={"application/json"})
    public ResponseEntity<Set<ProjectDto>> getAll();

    @Operation(operationId="getAllCompoundsAndScenarioCompounds", summary="getAllCompoundsAndScenarioCompounds", tags={"project-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=AbstractTestScenarioDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/catalog/api/v1/projects/{uuid}/compounds/compound_from_ts"}, produces={"application/json"})
    public ResponseEntity<List<AbstractTestScenarioDto>> getAllCompoundsAndScenarioCompounds(@Parameter(name="uuid", description="uuid", required=true) @PathVariable(value="uuid") UUID var1);

    @Operation(operationId="getAllCompoundsByProject", summary="getAllCompoundsByProject", tags={"project-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=CompoundDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/catalog/api/v1/projects/{uuid}/compounds"}, produces={"application/json"})
    public ResponseEntity<List<CompoundDto>> getAllCompoundsByProject(@Parameter(name="uuid", description="uuid", required=true) @PathVariable(value="uuid") UUID var1);

    @Operation(operationId="getAllCompoundsMadeFromTestScenario", summary="getAllCompoundsMadeFromTestScenario", tags={"project-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=TestScenarioDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/catalog/api/v1/projects/{uuid}/compound_from_ts"}, produces={"application/json"})
    public ResponseEntity<List<TestScenarioDto>> getAllCompoundsMadeFromTestScenario(@Parameter(name="uuid", description="uuid", required=true) @PathVariable(value="uuid") UUID var1);

    @Operation(operationId="getAllGroups", summary="getAllGroups", tags={"project-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=UserGroupDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/catalog/api/v1/projects/{uuid}/users/groups"}, produces={"application/json"})
    public ResponseEntity<List<UserGroupDto>> getAllGroups(@Parameter(name="uuid", description="uuid", required=true) @PathVariable(value="uuid") String var1);

    @Operation(operationId="getAllQaDslLibrariesInProject", summary="getAllQaDslLibrariesInProject", tags={"project-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=QaDslLibraryResponseDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/catalog/api/v1/projects/{uuid}/qadsllibraries"}, produces={"application/json"})
    public ResponseEntity<List<QaDslLibraryResponseDto>> getAllQaDslLibrariesInProject(@Parameter(name="uuid", description="uuid", required=true) @PathVariable(value="uuid") UUID var1);

    @Operation(operationId="getAllShortProjects", summary="getAllShortProjects", tags={"project-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=ProjectDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/catalog/api/v1/projects/short"}, produces={"application/json"})
    public ResponseEntity<List<ProjectDto>> getAllShortProjects();

    @Operation(operationId="getAllUsersByProject", summary="getAllUsersByProject", tags={"project-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=UserInfoDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/catalog/api/v1/projects/{uuid}/users/enriched"}, produces={"application/json"})
    public ResponseEntity<List<UserInfoDto>> getAllUsersByProject(@Parameter(name="uuid", description="uuid", required=true) @PathVariable(value="uuid") UUID var1);

    @Operation(operationId="getCertificate", summary="getCertificate", tags={"project-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=CertificateDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/catalog/api/v1/projects/certificate/{uuid}"}, produces={"application/json"})
    public ResponseEntity<CertificateDto> getCertificate(@Parameter(name="uuid", description="uuid", required=true) @PathVariable(value="uuid") UUID var1);

    @Operation(operationId="getItfUrl", summary="getItfUrl", tags={"project-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/catalog/api/v1/projects/{uuid}/itf/url"}, produces={"application/json"})
    public ResponseEntity<Set<String>> getItfUrl(@Parameter(name="uuid", description="uuid", required=true) @PathVariable(value="uuid") UUID var1);

    @Operation(operationId="getNotMappedTestPlansByProjectId", summary="getNotMappedTestPlansByProjectId", tags={"project-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=TestPlanDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/catalog/api/v1/projects/{uuid}/testplans/qa-dsl-not-mapped"}, produces={"application/json"})
    public ResponseEntity<List<TestPlanDto>> getNotMappedTestPlansByProjectId(@Parameter(name="uuid", description="uuid", required=true) @PathVariable(value="uuid") UUID var1);

    @Operation(operationId="getProjectById", summary="getProjectById", tags={"project-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=ProjectDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/catalog/api/v1/projects/{uuid}"}, produces={"application/json"})
    public ResponseEntity<ProjectDto> getProjectById(@Parameter(name="uuid", description="uuid", required=true) @PathVariable(value="uuid") UUID var1);

    @Operation(operationId="getProjectNumberOfThresholdByProjectId", summary="getProjectNumberOfThresholdByProjectId", tags={"project-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=Integer.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/catalog/api/v1/projects/{uuid}/number-of-threshold"}, produces={"application/json"})
    public ResponseEntity<Integer> getProjectNumberOfThresholdByProjectId(@Parameter(name="uuid", description="uuid", required=true) @PathVariable(value="uuid") UUID var1);

    @Operation(operationId="getProjectTestCaseLabels", summary="getProjectTestCaseLabels", tags={"project-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=LabelDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/catalog/api/v1/projects/{uuid}/testcases/labels"}, produces={"application/json"})
    public ResponseEntity<List<LabelDto>> getProjectTestCaseLabels(@Parameter(name="uuid", description="uuid", required=true) @PathVariable(value="uuid") UUID var1);

    @Operation(operationId="getProjectsUsersById", summary="getProjectsUsersById", tags={"project-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=ProjectDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/catalog/api/v1/projects/{uuid}/users"}, produces={"application/json"})
    public ResponseEntity<ProjectDto> getProjectsUsersById(@Parameter(name="uuid", description="uuid", required=true) @PathVariable(value="uuid") UUID var1);

    @Operation(operationId="getShortCasesByProjectId", summary="getShortCasesByProjectId", tags={"project-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=TestCaseDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/catalog/api/v1/projects/{uuid}/testcases/short"}, produces={"application/json"})
    public ResponseEntity<List<TestCaseDto>> getShortCasesByProjectId(@Parameter(name="uuid", description="uuid", required=true) @PathVariable(value="uuid") UUID var1);

    @Operation(operationId="getShortScopesByProjectId", summary="getShortScopesByProjectId", tags={"project-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=TestScopeDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/catalog/api/v1/projects/{uuid}/testscopes/short"}, produces={"application/json"})
    public ResponseEntity<List<TestScopeDto>> getShortScopesByProjectId(@Parameter(name="uuid", description="uuid", required=true) @PathVariable(value="uuid") UUID var1);

    @Operation(operationId="getTestCaseGroupNamesByProjectId", summary="getTestCaseGroupNamesByProjectId", tags={"project-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=TestCaseGroupDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/catalog/api/v1/projects/{uuid}/testcasegroups/short"}, produces={"application/json"})
    public ResponseEntity<List<TestCaseGroupDto>> getTestCaseGroupNamesByProjectId(@Parameter(name="uuid", description="uuid", required=true) @PathVariable(value="uuid") UUID var1, @NotNull @Parameter(name="testPlanId", description="testPlanId", required=true) @Valid @RequestParam(value="testPlanId", required=true) UUID var2);

    @Operation(operationId="getTestCaseGroupsByProjectId", summary="getTestCaseGroupsByProjectId", tags={"project-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=TestCaseGroupDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/catalog/api/v1/projects/testcasegroups"}, produces={"application/json"})
    public ResponseEntity<List<TestCaseGroupDto>> getTestCaseGroupsByProjectId(@Parameter(name="projectId", description="projectId") @Valid @RequestParam(value="projectId", required=false) UUID var1);

    @Operation(operationId="getTestPlansByProjectId", summary="getTestPlansByProjectId", tags={"project-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=TestPlanDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/catalog/api/v1/projects/{uuid}/testplans"}, produces={"application/json"})
    public ResponseEntity<List<TestPlanDto>> getTestPlansByProjectId(@Parameter(name="uuid", description="uuid", required=true) @PathVariable(value="uuid") UUID var1, @Parameter(name="without-qa-dsl", description="without-qa-dsl") @Valid @RequestParam(value="without-qa-dsl", required=false) String var2);

    @Operation(operationId="getTestScenariosByProjectId", summary="getTestScenariosByProjectId", tags={"project-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=TestScenarioDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/catalog/api/v1/projects/{uuid}/testscenarios"}, produces={"application/json"})
    public ResponseEntity<List<TestScenarioDto>> getTestScenariosByProjectId(@Parameter(name="uuid", description="uuid", required=true) @PathVariable(value="uuid") UUID var1);

    @Operation(operationId="getTestScopeByProjectId", summary="getTestScopeByProjectId", tags={"project-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=TestScopeDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/catalog/api/v1/projects/{uuid}/testscopes"}, produces={"application/json"})
    public ResponseEntity<List<TestScopeDto>> getTestScopeByProjectId(@Parameter(name="uuid", description="uuid", required=true) @PathVariable(value="uuid") UUID var1);

    @Operation(operationId="update", summary="update", tags={"project-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=UUID.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.PUT}, value={"/catalog/api/v1/projects/save"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<UUID> update(@Parameter(name="ProjectDto", description="") @Valid @RequestBody(required=false) ProjectDto var1);

    @Operation(operationId="updateActions", summary="updateActions", tags={"project-controller"}, responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/catalog/api/v1/projects/{uuid}/updateActions"})
    public ResponseEntity<Void> updateActions(@Parameter(name="uuid", description="uuid", required=true) @PathVariable(value="uuid") UUID var1);

    @Operation(operationId="updateProjectUsers", summary="updateProjectUsers", tags={"project-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=ProjectDto.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.PUT}, value={"/catalog/api/v1/projects/update/users"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<ProjectDto> updateProjectUsers(@NotNull @Parameter(name="type", description="type", required=true) @Valid @RequestParam(value="type", required=true) String var1, @Parameter(name="ProjectDto", description="") @Valid @RequestBody(required=false) ProjectDto var2);
}

