/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ram.clients.api.dto.catalogue;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.validation.Valid;
import org.qubership.atp.ram.clients.api.dto.catalogue.ActionParameterDto;

@JsonTypeName(value="Action")
public class ActionDto {
    @JsonProperty(value="annotations")
    @Valid
    private List<String> annotations = null;
    @JsonProperty(value="comment")
    private String comment;
    @JsonProperty(value="commentedOut")
    private Boolean commentedOut;
    @JsonProperty(value="deprecated")
    private Boolean deprecated;
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="engineType")
    private EngineTypeEnum engineType;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="parameters")
    @Valid
    private List<ActionParameterDto> parameters = null;
    @JsonProperty(value="projectUuid")
    private UUID projectUuid;
    @JsonProperty(value="type")
    private TypeEnum type;
    @JsonProperty(value="typeAction")
    private String typeAction;
    @JsonProperty(value="uuid")
    private UUID uuid;

    public ActionDto annotations(List<String> annotations) {
        this.annotations = annotations;
        return this;
    }

    public ActionDto addAnnotationsItem(String annotationsItem) {
        if (this.annotations == null) {
            this.annotations = new ArrayList<String>();
        }
        this.annotations.add(annotationsItem);
        return this;
    }

    @Schema(name="annotations", required=false)
    public List<String> getAnnotations() {
        return this.annotations;
    }

    public void setAnnotations(List<String> annotations) {
        this.annotations = annotations;
    }

    public ActionDto comment(String comment) {
        this.comment = comment;
        return this;
    }

    @Schema(name="comment", required=false)
    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public ActionDto commentedOut(Boolean commentedOut) {
        this.commentedOut = commentedOut;
        return this;
    }

    @Schema(name="commentedOut", required=false)
    public Boolean getCommentedOut() {
        return this.commentedOut;
    }

    public void setCommentedOut(Boolean commentedOut) {
        this.commentedOut = commentedOut;
    }

    public ActionDto deprecated(Boolean deprecated) {
        this.deprecated = deprecated;
        return this;
    }

    @Schema(name="deprecated", required=false)
    public Boolean getDeprecated() {
        return this.deprecated;
    }

    public void setDeprecated(Boolean deprecated) {
        this.deprecated = deprecated;
    }

    public ActionDto description(String description) {
        this.description = description;
        return this;
    }

    @Schema(name="description", required=false)
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ActionDto engineType(EngineTypeEnum engineType) {
        this.engineType = engineType;
        return this;
    }

    @Schema(name="engineType", required=false)
    public EngineTypeEnum getEngineType() {
        return this.engineType;
    }

    public void setEngineType(EngineTypeEnum engineType) {
        this.engineType = engineType;
    }

    public ActionDto name(String name) {
        this.name = name;
        return this;
    }

    @Schema(name="name", required=false)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ActionDto parameters(List<ActionParameterDto> parameters) {
        this.parameters = parameters;
        return this;
    }

    public ActionDto addParametersItem(ActionParameterDto parametersItem) {
        if (this.parameters == null) {
            this.parameters = new ArrayList<ActionParameterDto>();
        }
        this.parameters.add(parametersItem);
        return this;
    }

    @Valid
    @Schema(name="parameters", required=false)
    public List<ActionParameterDto> getParameters() {
        return this.parameters;
    }

    public void setParameters(List<ActionParameterDto> parameters) {
        this.parameters = parameters;
    }

    public ActionDto projectUuid(UUID projectUuid) {
        this.projectUuid = projectUuid;
        return this;
    }

    @Valid
    @Schema(name="projectUuid", required=false)
    public UUID getProjectUuid() {
        return this.projectUuid;
    }

    public void setProjectUuid(UUID projectUuid) {
        this.projectUuid = projectUuid;
    }

    public ActionDto type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Schema(name="type", required=false)
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public ActionDto typeAction(String typeAction) {
        this.typeAction = typeAction;
        return this;
    }

    @Schema(name="typeAction", required=false)
    public String getTypeAction() {
        return this.typeAction;
    }

    public void setTypeAction(String typeAction) {
        this.typeAction = typeAction;
    }

    public ActionDto uuid(UUID uuid) {
        this.uuid = uuid;
        return this;
    }

    @Valid
    @Schema(name="uuid", required=false)
    public UUID getUuid() {
        return this.uuid;
    }

    public void setUuid(UUID uuid) {
        this.uuid = uuid;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ActionDto action = (ActionDto)o;
        return Objects.equals(this.annotations, action.annotations) && Objects.equals(this.comment, action.comment) && Objects.equals(this.commentedOut, action.commentedOut) && Objects.equals(this.deprecated, action.deprecated) && Objects.equals(this.description, action.description) && Objects.equals((Object)this.engineType, (Object)action.engineType) && Objects.equals(this.name, action.name) && Objects.equals(this.parameters, action.parameters) && Objects.equals(this.projectUuid, action.projectUuid) && Objects.equals((Object)this.type, (Object)action.type) && Objects.equals(this.typeAction, action.typeAction) && Objects.equals(this.uuid, action.uuid);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.annotations, this.comment, this.commentedOut, this.deprecated, this.description, this.engineType, this.name, this.parameters, this.projectUuid, this.type, this.typeAction, this.uuid});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ActionDto {\n");
        sb.append("    annotations: ").append(this.toIndentedString(this.annotations)).append("\n");
        sb.append("    comment: ").append(this.toIndentedString(this.comment)).append("\n");
        sb.append("    commentedOut: ").append(this.toIndentedString(this.commentedOut)).append("\n");
        sb.append("    deprecated: ").append(this.toIndentedString(this.deprecated)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    engineType: ").append(this.toIndentedString((Object)this.engineType)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    parameters: ").append(this.toIndentedString(this.parameters)).append("\n");
        sb.append("    projectUuid: ").append(this.toIndentedString(this.projectUuid)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    typeAction: ").append(this.toIndentedString(this.typeAction)).append("\n");
        sb.append("    uuid: ").append(this.toIndentedString(this.uuid)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum EngineTypeEnum {
        BV("BV"),
        EXECUTOR("EXECUTOR"),
        ITFACTION("ITFACTION"),
        ITFCALLCHAIN("ITFCALLCHAIN"),
        ITFWARMUP("ITFWARMUP"),
        NEWMAN_RUNNER("NEWMAN_RUNNER");

        private String value;

        private EngineTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static EngineTypeEnum fromValue(String value) {
            for (EngineTypeEnum b : EngineTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum TypeEnum {
        BV("BV"),
        COMPOUND("COMPOUND"),
        ITF("ITF"),
        MIA("MIA"),
        NEWMAN("NEWMAN"),
        R_B_M("R_B_M"),
        REST("REST"),
        SQL("SQL"),
        SSH("SSH"),
        TECHNICAL("TECHNICAL"),
        UI("UI");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

