/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ram.repositories.impl;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.UUID;
import org.qubership.atp.ram.dto.request.TestCaseExecutionHistorySearchRequest;
import org.qubership.atp.ram.dto.response.PaginationResponse;
import org.qubership.atp.ram.models.TestCaseExecutionHistory;
import org.qubership.atp.ram.repositories.impl.FieldConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationExpression;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.aggregation.ArrayOperators;
import org.springframework.data.mongodb.core.aggregation.GroupOperation;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Repository
public class CustomExecutionHistoryRepository
implements FieldConstants {
    private static final Logger log = LoggerFactory.getLogger(CustomExecutionHistoryRepository.class);
    private final MongoTemplate mongoTemplate;

    public PaginationResponse<TestCaseExecutionHistory.TestCaseExecution> getTestCaseExecutions(TestCaseExecutionHistorySearchRequest request, UUID testCaseId) {
        Boolean analyzedByQa;
        Set executors;
        Set failureReasons;
        Criteria preCriteria = new Criteria();
        preCriteria.and("testCaseId").is((Object)testCaseId);
        Set testingStatuses = request.getTestingStatuses();
        if (!CollectionUtils.isEmpty((Collection)testingStatuses)) {
            preCriteria.and("testingStatus").in((Collection)testingStatuses);
        }
        if (!CollectionUtils.isEmpty((Collection)(failureReasons = request.getFailureReasons()))) {
            preCriteria.and("rootCauseId").in((Collection)failureReasons);
        }
        Timestamp startDate = request.getStartDate();
        Timestamp finishDate = request.getFinishDate();
        if (startDate != null && finishDate != null) {
            preCriteria.and("startDate").gte((Object)startDate).lte((Object)finishDate);
        } else if (startDate != null) {
            preCriteria.and("startDate").gte((Object)startDate);
        } else if (finishDate != null) {
            preCriteria.and("startDate").lte((Object)finishDate);
        }
        ArrayList<Object> aggregationOperations = new ArrayList<Object>();
        aggregationOperations.add(Aggregation.match((Criteria)preCriteria));
        aggregationOperations.add(Aggregation.lookup((String)"executionRequests", (String)"executionRequestId", (String)"_id", (String)"executionRequest"));
        aggregationOperations.add(Aggregation.lookup((String)"rootCause", (String)"rootCauseId", (String)"_id", (String)"rootCause"));
        aggregationOperations.add(Aggregation.unwind((String)"$executionRequest"));
        aggregationOperations.add(Aggregation.unwind((String)"$rootCause"));
        Criteria postCriteria = new Criteria();
        Set environments = request.getEnvironments();
        if (!CollectionUtils.isEmpty((Collection)environments)) {
            postCriteria.and("executionRequest.environmentId").in((Collection)environments);
        }
        if (!CollectionUtils.isEmpty((Collection)(executors = request.getExecutors()))) {
            postCriteria.and("executionRequest.executorId").in((Collection)executors);
        }
        if ((analyzedByQa = request.getAnalyzedByQa()) != null) {
            postCriteria.and("executionRequest.analyzedByQa").is((Object)analyzedByQa);
        }
        aggregationOperations.add(Aggregation.match((Criteria)postCriteria));
        aggregationOperations.add(Aggregation.project((String[])new String[0]).and("$executionRequest.projectId").as("projectId").and("$executionRequest._id").as("executionRequestId").and("$executionRequest.name").as("executionRequestName").and("$testingStatus").as("testingStatus").and("$executionRequest.analyzedByQa").as("analyzedByQa").and("$startDate").as("startDate").and("$finishDate").as("finishDate").and("$duration").as("duration").and("$executionRequest.passedRate").as("passedRate").and("$executionRequest.warningRate").as("warningRate").and("$executionRequest.failedRate").as("failedRate").and("$executionRequest.environmentId").as("environmentId").and("$executionRequest.executorId").as("executorId").and("$executionRequest.executorName").as("executorName").and("$executionRequest.filteredByLabels").as("filteredByLabelsIds").and("$rootCause.name").as("failReason").and("$_id").as("testRunId"));
        String sort = request.getSort();
        String direction = request.getDirection();
        if (!StringUtils.isEmpty((Object)sort) && !StringUtils.isEmpty((Object)direction)) {
            aggregationOperations.add(Aggregation.sort((Sort.Direction)Sort.Direction.fromString((String)direction), (String[])new String[]{sort}));
        }
        GroupOperation groupOperation = Aggregation.group((String[])new String[0]).count().as("totalCount");
        Integer page = request.getPage();
        Integer size = request.getSize();
        aggregationOperations.add(Aggregation.facet((AggregationOperation[])new AggregationOperation[]{Aggregation.skip((int)(page * size)), Aggregation.limit((long)size.intValue())}).as("entities").and(new AggregationOperation[]{groupOperation}).as("metadata"));
        aggregationOperations.add(Aggregation.project((String[])new String[]{"entities"}).and((AggregationExpression)ArrayOperators.ArrayElemAt.arrayOf((String)"$metadata.totalCount").elementAt(0)).as("totalCount"));
        Aggregation aggregation = Aggregation.newAggregation(aggregationOperations);
        log.debug("Aggregation query '{}'", (Object)aggregation.toString());
        return (PaginationResponse)this.mongoTemplate.aggregate(aggregation, "testrun", TestCaseExecutionPaginationResponse.class).getUniqueMappedResult();
    }

    public CustomExecutionHistoryRepository(MongoTemplate mongoTemplate) {
        this.mongoTemplate = mongoTemplate;
    }

    private static class TestCaseExecutionPaginationResponse
    extends PaginationResponse<TestCaseExecutionHistory.TestCaseExecution> {
        private TestCaseExecutionPaginationResponse() {
        }
    }
}

