/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ram.repositories.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.bson.Document;
import org.qubership.atp.ram.model.IssueDto;
import org.qubership.atp.ram.models.ExecutionRequest;
import org.qubership.atp.ram.models.FailPattern;
import org.qubership.atp.ram.models.Issue;
import org.qubership.atp.ram.models.LogRecord;
import org.qubership.atp.ram.models.RamObject;
import org.qubership.atp.ram.models.RootCause;
import org.qubership.atp.ram.pojo.IssueFilteringParams;
import org.qubership.atp.ram.repositories.CustomIssueRepository;
import org.qubership.atp.ram.repositories.operations.CustomLookupOperation;
import org.qubership.atp.ram.utils.SortUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.MongoExpression;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationExpression;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.aggregation.AggregationPipeline;
import org.springframework.data.mongodb.core.aggregation.ArrayOperators;
import org.springframework.data.mongodb.core.aggregation.CountOperation;
import org.springframework.data.mongodb.core.aggregation.LookupOperation;
import org.springframework.data.mongodb.core.aggregation.MatchOperation;
import org.springframework.data.mongodb.core.aggregation.ProjectionOperation;
import org.springframework.data.mongodb.core.aggregation.SetOperators;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.stereotype.Repository;

@Repository
public class CustomIssueRepositoryImpl
implements CustomIssueRepository {
    private static final Logger log = LoggerFactory.getLogger(CustomIssueRepositoryImpl.class);
    private final MongoTemplate mongoTemplate;
    private static final String ISSUE_COLLECTION_NAME = Issue.class.getAnnotation(org.springframework.data.mongodb.core.mapping.Document.class).collection();
    private static final String FAIL_REASON_COLLECTION_NAME = RootCause.class.getAnnotation(org.springframework.data.mongodb.core.mapping.Document.class).collection();
    private static final String FAIL_PATTERN_COLLECTION_NAME = FailPattern.class.getAnnotation(org.springframework.data.mongodb.core.mapping.Document.class).collection();
    private static final String LOG_RECORD_COLLECTION_NAME = LogRecord.class.getAnnotation(org.springframework.data.mongodb.core.mapping.Document.class).collection();
    private static final String REGEX = ".*?";
    private static final String EMPTY_ARRAY = "emptyArray";
    private static final String ISSUE_MESSAGE = "issue_message";
    private static final String ISSUE_LRS = "issue_lrs";
    private static final String LOGRECORDS = "logrecords";

    @Override
    public IssueDto getSortedAndPaginatedIssuesByFilters(IssueFilteringParams issueFilteringParams, String columnType, String sortType, int startIndex, int endIndex) {
        ArrayList<Object> aggregationOperations = new ArrayList<Object>();
        if (issueFilteringParams.getExecutionRequestId() != null) {
            aggregationOperations.add(Aggregation.match((Criteria)Criteria.where((String)"executionRequestId").is((Object)issueFilteringParams.getExecutionRequestId())));
        }
        if (issueFilteringParams.getLogRecordIds() != null) {
            aggregationOperations.add(Aggregation.match((Criteria)Criteria.where((String)"logRecordIds").in((Collection)issueFilteringParams.getLogRecordIds())));
        }
        if (issueFilteringParams.getPriority() != null) {
            aggregationOperations.add(Aggregation.match((Criteria)Criteria.where((String)"priority").is((Object)issueFilteringParams.getPriority())));
        }
        if (issueFilteringParams.getMessage() != null) {
            aggregationOperations.add(Aggregation.match((Criteria)Criteria.where((String)"message").regex(REGEX + issueFilteringParams.getMessage() + REGEX)));
        }
        if (issueFilteringParams.getJiraTicket() != null) {
            aggregationOperations.add(Aggregation.match((Criteria)Criteria.where((String)"jiraTickets").regex(REGEX + issueFilteringParams.getJiraTicket() + REGEX)));
        }
        if (issueFilteringParams.getFailPattern() != null || "failPattern".equals(columnType)) {
            aggregationOperations.add(Aggregation.lookup((String)FAIL_PATTERN_COLLECTION_NAME, (String)"failPatternId", (String)"_id", (String)"failPattern"));
            aggregationOperations.add(Aggregation.unwind((String)"failPattern", (boolean)true));
        }
        if (issueFilteringParams.getFailReason() != null || "failReason".equals(columnType)) {
            aggregationOperations.add(Aggregation.lookup((String)FAIL_REASON_COLLECTION_NAME, (String)"failReasonId", (String)"_id", (String)"failReason"));
            aggregationOperations.add(Aggregation.unwind((String)"failReason", (boolean)true));
        }
        if (issueFilteringParams.getFailPattern() != null) {
            aggregationOperations.add(Aggregation.match((Criteria)Criteria.where((String)"failPattern.name").regex(REGEX + issueFilteringParams.getFailPattern() + REGEX)));
        }
        if (issueFilteringParams.getFailReason() != null) {
            aggregationOperations.add(Aggregation.match((Criteria)Criteria.where((String)"failReason.name").regex(REGEX + issueFilteringParams.getFailReason() + REGEX)));
        }
        if (columnType != null && sortType != null) {
            if (columnType.equals("failedCasesCount") || columnType.equals("failedTestRuns")) {
                aggregationOperations.add(Aggregation.sort((Sort)this.getFieldSort("failedTestRunsCount", sortType)));
            } else {
                aggregationOperations.add(Aggregation.sort((Sort)this.getFieldSort(columnType, sortType)));
            }
        }
        CountOperation countAggregation = Aggregation.count().as("totalCount");
        AggregationOperation[] paginationAggregation = new AggregationOperation[]{Aggregation.skip((long)startIndex), Aggregation.limit((long)((long)endIndex - (long)startIndex))};
        aggregationOperations.add(Aggregation.facet((AggregationOperation[])new AggregationOperation[]{countAggregation}).as("metadata").and(paginationAggregation).as("data"));
        List issues = this.mongoTemplate.aggregate(Aggregation.newAggregation(aggregationOperations), ISSUE_COLLECTION_NAME, IssueDto.class).getMappedResults();
        return (IssueDto)issues.get(0);
    }

    private Sort getFieldSort(String columnType, String sortType) {
        if (columnType.equals("message")) {
            return Sort.by((Sort.Direction)SortUtils.parseSortDirection(sortType), (String[])new String[]{"message"});
        }
        if (columnType.equals("priority")) {
            return Sort.by((Sort.Direction)SortUtils.parseSortDirection(sortType), (String[])new String[]{"priority"});
        }
        if (columnType.equals("jiraTickets")) {
            return Sort.by((Sort.Direction)SortUtils.parseSortDirection(sortType), (String[])new String[]{"jiraTickets"});
        }
        if (columnType.equals("failPattern")) {
            return Sort.by((Sort.Direction)SortUtils.parseSortDirection(sortType), (String[])new String[]{"failPattern.name"});
        }
        if (columnType.equals("failReason")) {
            return Sort.by((Sort.Direction)SortUtils.parseSortDirection(sortType), (String[])new String[]{"failReason.name"});
        }
        if (columnType.equals("failedTestRunsCount")) {
            return Sort.by((Sort.Direction)SortUtils.parseSortDirection(sortType), (String[])new String[]{"failedTestRunsCount"});
        }
        return Sort.unsorted();
    }

    @Override
    public UUID getProjectIdByIssueId(UUID issueId) {
        ArrayList<Object> aggregationOperations = new ArrayList<Object>();
        aggregationOperations.add(Aggregation.match((Criteria)Criteria.where((String)"_id").is((Object)issueId)));
        aggregationOperations.add(LookupOperation.newLookup().from("executionRequests").localField("executionRequestId").foreignField("_id").as("executionRequest"));
        aggregationOperations.add(Aggregation.unwind((String)"executionRequest"));
        aggregationOperations.add(Aggregation.project((String[])new String[0]).and("executionRequest.projectId").as("_id"));
        Aggregation aggregation = Aggregation.newAggregation(aggregationOperations);
        Optional<ExecutionRequest> result = Optional.ofNullable((ExecutionRequest)this.mongoTemplate.aggregate(aggregation, ISSUE_COLLECTION_NAME, ExecutionRequest.class).getUniqueMappedResult());
        return result.map(RamObject::getUuid).orElse(null);
    }

    @Override
    public List<Issue> getCreatedIssuesByLogRecordsMessage(List<UUID> logRecords, UUID executionRequestId) {
        ArrayList<Object> aggregationOperations = new ArrayList<Object>();
        aggregationOperations.add(Aggregation.match((Criteria)Criteria.where((String)"executionRequestId").is((Object)executionRequestId)));
        MatchOperation matchOperation = Aggregation.match((Criteria)Criteria.where((String)"_id").in(logRecords));
        MatchOperation pipelineMatch = Aggregation.match((AggregationExpression)AggregationExpression.from((MongoExpression)MongoExpression.create((String)"$expr: {$and: [{$eq: ['$message', '$$issue_message']},{$not: { $in: ['$_id', '$$issue_lrs']}}]}")));
        ProjectionOperation projectionOperation = Aggregation.project((String[])new String[]{"_id"}).andInclude(new String[]{"testRunId"}).andArrayOf(new Object[]{Collections.emptyList()}).as(EMPTY_ARRAY);
        aggregationOperations.add(new CustomLookupOperation(LOG_RECORD_COLLECTION_NAME, new Document(ISSUE_MESSAGE, (Object)"$message").append(ISSUE_LRS, (Object)"$logRecordIds"), new AggregationPipeline(Arrays.asList(matchOperation, pipelineMatch, projectionOperation)), LOGRECORDS));
        SetOperators.SetDifference setDifference = SetOperators.SetDifference.arrayAsSet((AggregationExpression)ArrayOperators.ConcatArrays.arrayOf((String)"$failedTestRunIds").concat("$logrecords.testRunId")).differenceTo("$logrecords.emptyArray");
        aggregationOperations.add(Aggregation.match((Criteria)Criteria.where((String)LOGRECORDS).ne(Collections.emptyList())));
        aggregationOperations.add(Aggregation.project((String[])new String[0]).and((AggregationExpression)SetOperators.SetDifference.arrayAsSet((AggregationExpression)ArrayOperators.ConcatArrays.arrayOf((String)"$logRecordIds").concat("$logrecords._id")).differenceTo("$logrecords.emptyArray")).as("logRecordIds").and((AggregationExpression)setDifference).as("failedTestRunIds").and((AggregationExpression)ArrayOperators.Size.lengthOfArray((AggregationExpression)setDifference)).as("failedTestRunsCount").andInclude(new String[]{"executionRequestId", "message"}));
        return this.mongoTemplate.aggregate(Aggregation.newAggregation(aggregationOperations), ISSUE_COLLECTION_NAME, Issue.class).getMappedResults();
    }

    public CustomIssueRepositoryImpl(MongoTemplate mongoTemplate) {
        this.mongoTemplate = mongoTemplate;
    }
}

