/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ram.services;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import java.util.UUID;
import org.qubership.atp.ram.client.EnvironmentFeignClient;
import org.qubership.atp.ram.clients.api.dto.environments.environment.BaseSearchRequestDto;
import org.qubership.atp.ram.clients.api.dto.environments.environment.SystemFullVer1ViewDto;
import org.qubership.atp.ram.converter.DtoConvertService;
import org.qubership.atp.ram.dto.response.Environment;
import org.qubership.atp.ram.model.BaseSearchRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EnvironmentsService {
    private static final Logger log = LoggerFactory.getLogger(EnvironmentsService.class);
    private final EnvironmentFeignClient environmentsFeignClient;
    private final DtoConvertService dtoConvertService;
    @Autowired
    private ObjectMapper objectMapper;

    public List<Environment> searchEnvironments(BaseSearchRequest searchRequest) {
        List<Environment> environments = this.dtoConvertService.convertList((List)this.environmentsFeignClient.findBySearchRequest((BaseSearchRequestDto)this.objectMapper.convertValue((Object)searchRequest, BaseSearchRequestDto.class), false).getBody(), Environment.class);
        return environments;
    }

    public Environment getEnvironmentById(UUID environmentId) {
        Environment environment = this.dtoConvertService.convert(this.environmentsFeignClient.getEnvironment(environmentId, true).getBody(), Environment.class);
        return environment;
    }

    public String getEnvironmentNameById(UUID environmentId) {
        if (environmentId != null) {
            return (String)this.environmentsFeignClient.getEnvironmentNameById(environmentId).getBody();
        }
        return null;
    }

    public List<SystemFullVer1ViewDto> getEnvironmentSystems(UUID environmentId) {
        return (List)this.environmentsFeignClient.getEnvironmentSystems(environmentId, null, false).getBody();
    }

    public EnvironmentsService(EnvironmentFeignClient environmentsFeignClient, DtoConvertService dtoConvertService) {
        this.environmentsFeignClient = environmentsFeignClient;
        this.dtoConvertService = dtoConvertService;
    }
}

