/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ram.services;

import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import org.modelmapper.ModelMapper;
import org.qubership.atp.ram.dto.response.FailPatternPageResponse;
import org.qubership.atp.ram.dto.response.FailPatternResponse;
import org.qubership.atp.ram.dto.response.PaginationResponse;
import org.qubership.atp.ram.model.FailPatternCheckRequest;
import org.qubership.atp.ram.models.FailPattern;
import org.qubership.atp.ram.models.FailPatternSearchRequest;
import org.qubership.atp.ram.models.PaginationSearchRequest;
import org.qubership.atp.ram.models.Project;
import org.qubership.atp.ram.models.RootCause;
import org.qubership.atp.ram.repositories.CustomFailPatternRepository;
import org.qubership.atp.ram.repositories.FailPatternRepository;
import org.qubership.atp.ram.services.CrudService;
import org.qubership.atp.ram.services.ProjectsService;
import org.qubership.atp.ram.services.RootCauseService;
import org.qubership.atp.ram.utils.StreamUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.repository.MongoRepository;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FailPatternService
extends CrudService<FailPattern> {
    private static final Logger log = LoggerFactory.getLogger(FailPatternService.class);
    private final ProjectsService projectsService;
    private final RootCauseService rootCauseService;
    private final FailPatternRepository repository;
    private final CustomFailPatternRepository customRepository;
    private final ModelMapper modelMapper;

    @Override
    protected MongoRepository<FailPattern, UUID> repository() {
        return this.repository;
    }

    public FailPattern upsertFailPattern(FailPattern failPattern) {
        this.setJiraDefectCreationDates(failPattern);
        return this.save(failPattern);
    }

    private void setJiraDefectCreationDates(FailPattern failPattern) {
        List jiraDefects = failPattern.getJiraDefects();
        if (!CollectionUtils.isEmpty((Collection)jiraDefects)) {
            Timestamp currentDate = Timestamp.valueOf(LocalDateTime.now());
            jiraDefects.stream().filter(jiraTicket -> Objects.isNull(jiraTicket.getCreatedDate())).forEach(jiraTicket -> jiraTicket.setCreatedDate(currentDate));
        }
    }

    public List<FailPattern> getFailPatternsByIds(Collection<UUID> ids) {
        return this.repository.findByUuidIn(ids);
    }

    public FailPatternPageResponse search(FailPatternSearchRequest request, Pageable pageable) {
        log.info("Searching Fail Patterns with request '{}'", (Object)request);
        PaginationResponse<FailPattern> response = this.customRepository.findAllFailPatterns(request, pageable);
        List<FailPatternResponse> failPatternResponses = this.getResponses(response.getEntities());
        log.debug("Found Fail Patterns: {}", StreamUtils.extractIds(failPatternResponses));
        return new FailPatternPageResponse(response.getTotalCount(), failPatternResponses);
    }

    public FailPatternResponse getById(UUID id) {
        return this.getResponse(this.repository.findByUuid(id));
    }

    public void deleteByUuid(UUID failPatternId) {
        log.info("deleting Fail Pattern {}", (Object)failPatternId);
        this.repository.deleteByUuid(failPatternId);
    }

    public FailPatternPageResponse findPageByProjectIdAndSort(UUID projectId, int startIndex, int endIndex) {
        log.info("Finding Fail Patterns in project {} from {} to {}", new Object[]{projectId, startIndex, endIndex});
        int countOnPage = endIndex - startIndex;
        int numOfPage = startIndex / countOnPage;
        PageRequest request = PageRequest.of((int)numOfPage, (int)countOnPage);
        List<FailPattern> failPatterns = this.repository.findAllByProjectId(projectId, (Pageable)request);
        List<FailPatternResponse> failPatternResponses = this.getResponses(failPatterns);
        return new FailPatternPageResponse((long)((int)this.repository.countByProjectId(projectId)), failPatternResponses);
    }

    public List<FailPatternResponse> getResponses(List<FailPattern> failPatterns) {
        Set<UUID> failPatternProjectIds = StreamUtils.extractIds(failPatterns, FailPattern::getProjectId);
        Set<UUID> failPatternFailReasonIds = StreamUtils.extractIds(failPatterns, FailPattern::getFailReasonId);
        long durationOfExecute = System.currentTimeMillis();
        List<Project> projects = this.projectsService.getProjectsByIds(failPatternProjectIds);
        Map<UUID, String> projectMap = StreamUtils.toIdNameEntityMap(projects);
        List<RootCause> rootCauses = this.rootCauseService.getByIds(failPatternFailReasonIds);
        Map<UUID, String> rootCauseMap = StreamUtils.toIdNameEntityMap(rootCauses);
        List<FailPatternResponse> failPatternResponses = failPatterns.stream().map(failPattern -> {
            String projectName = (String)projectMap.get(failPattern.getProjectId());
            String rootCauseName = (String)rootCauseMap.get(failPattern.getFailReasonId());
            return this.getResponse((FailPattern)failPattern, projectName, rootCauseName);
        }).collect(Collectors.toList());
        long maxDurationOfExecute = 1000L;
        if (System.currentTimeMillis() - durationOfExecute > maxDurationOfExecute) {
            log.warn("getResponses: long execute collect of fail patterns. Map of project: {}", projectMap.keySet());
        }
        return failPatternResponses;
    }

    public FailPatternResponse getResponse(FailPattern failPattern) {
        Project project = this.projectsService.getProjectById(failPattern.getProjectId());
        String rootCauseName = failPattern.getFailReasonId() != null ? ((RootCause)this.rootCauseService.get(failPattern.getFailReasonId())).getName() : null;
        return this.getResponse(failPattern, project.getName(), rootCauseName);
    }

    private FailPatternResponse getResponse(FailPattern failPattern, String projectName, String rootCauseName) {
        FailPatternResponse failPatternResponse = (FailPatternResponse)this.modelMapper.map((Object)failPattern, FailPatternResponse.class);
        if (failPattern.getProjectId() != null) {
            failPatternResponse.getProject().setName(projectName);
        }
        if (failPattern.getFailReasonId() != null) {
            failPatternResponse.getFailReason().setName(rootCauseName);
        }
        return failPatternResponse;
    }

    public List<FailPattern> findPatternByProjectId(UUID projectId) {
        log.info("Finding Fail Patterns in project {}", (Object)projectId);
        return this.repository.findAllByProjectId(projectId);
    }

    public HttpStatus check(FailPatternCheckRequest failPatternCheckRequest) {
        HttpStatus httpStatus;
        Pattern compiledFailedPattern;
        try {
            compiledFailedPattern = Pattern.compile(failPatternCheckRequest.getRule());
        }
        catch (PatternSyntaxException e) {
            log.error("Could not parse pattern with rule {}, exception {}", (Object)failPatternCheckRequest.getRule(), (Object)e.getMessage());
            HttpStatus httpStatus2 = HttpStatus.INTERNAL_SERVER_ERROR;
            return httpStatus2;
        }
        try {
            httpStatus = compiledFailedPattern != null && compiledFailedPattern.matcher(failPatternCheckRequest.getMessage()).find() ? HttpStatus.OK : HttpStatus.NOT_FOUND;
        }
        catch (StackOverflowError e) {
            log.error("StackOverflowError for rule {}, exception {}", (Object)failPatternCheckRequest.getRule(), (Object)e.getMessage());
            httpStatus = HttpStatus.INTERNAL_SERVER_ERROR;
        }
        return httpStatus;
    }

    public UUID getProjectIdByFailPatternId(UUID failPatternId) {
        FailPattern failPattern = this.repository.findProjectByUuid(failPatternId);
        return failPattern.getProjectId();
    }

    public Page<FailPattern> getAllNamesByNameWithPagination(PaginationSearchRequest request) {
        log.info("Finding Fail Patterns by request '{}'", (Object)request);
        Set projectIds = request.getProjects();
        String name = request.getName();
        String sort = Objects.nonNull(request.getSort()) ? request.getSort() : "name";
        Sort.Direction direction = Objects.nonNull(request.getDirection()) ? request.getDirection() : Sort.Direction.ASC;
        PageRequest pageable = PageRequest.of((int)request.getPage(), (int)request.getSize(), (Sort.Direction)direction, (String[])new String[]{sort});
        log.debug("Pageable: {}", (Object)pageable);
        if (CollectionUtils.isEmpty((Collection)projectIds)) {
            log.debug("Finding Fail Patterns by name '{}'", (Object)name);
            return this.repository.findAllNamesByNameContainsIgnoreCase(name, (Pageable)pageable);
        }
        log.debug("Finding Fail Patterns by name '{}' in projects '{}'", (Object)name, (Object)projectIds);
        return this.repository.findAllNamesByProjectIdInAndNameContainsIgnoreCase(projectIds, name, (Pageable)pageable);
    }

    public PaginationResponse getAllIssuesWithPagination(PaginationSearchRequest request) {
        log.info("Finding issues by request '{}'", (Object)request);
        return this.customRepository.getAllIssuesWithPagination(request);
    }

    public PaginationResponse getAllFailReasonsWithPagination(PaginationSearchRequest request) {
        log.info("Finding fail reasons by request '{}'", (Object)request);
        return this.customRepository.getAllFailReasonsWithPagination(request);
    }

    public FailPatternService(ProjectsService projectsService, RootCauseService rootCauseService, FailPatternRepository repository, CustomFailPatternRepository customRepository, ModelMapper modelMapper) {
        this.projectsService = projectsService;
        this.rootCauseService = rootCauseService;
        this.repository = repository;
        this.customRepository = customRepository;
        this.modelMapper = modelMapper;
    }
}

