/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ram.services;

import com.google.common.base.Strings;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import org.qubership.atp.ram.enums.FileContentType;
import org.qubership.atp.ram.exceptions.internal.RamGridFsFileNotFoundException;
import org.qubership.atp.ram.exceptions.logrecords.RamLogRecordFileAsStringException;
import org.qubership.atp.ram.model.ExtendedFileData;
import org.qubership.atp.ram.model.FileData;
import org.qubership.atp.ram.model.GridFsFileData;
import org.qubership.atp.ram.models.LogRecord;
import org.qubership.atp.ram.repositories.GridFsRepository;
import org.qubership.atp.ram.repositories.LogRecordRepository;
import org.qubership.atp.ram.utils.FileContentTypeDetector;
import org.qubership.atp.ram.utils.SourceShot;
import org.qubership.atp.ram.utils.StreamUtils;
import org.qubership.atp.ram.utils.UrlParamsUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class GridFsService {
    private static final Logger log = LoggerFactory.getLogger(GridFsService.class);
    private final GridFsRepository repository;
    private final LogRecordRepository lrRepository;
    @Value(value="${files.expiration.days.interval}")
    private Integer filesExpirationDaysInterval;

    @Autowired
    public GridFsService(GridFsRepository repository, LogRecordRepository lrRepository) {
        this.repository = repository;
        this.lrRepository = lrRepository;
    }

    public SourceShot getScreenShot(UUID logRecordId) {
        Optional<FileData> screenShot = this.repository.getFileData(logRecordId);
        LogRecord logRecord = this.lrRepository.findByUuid(logRecordId);
        if (logRecord == null) {
            log.debug("LogRecord wasn't found by id {}.", (Object)logRecordId);
            return new SourceShot();
        }
        if (!screenShot.isPresent() && !Strings.isNullOrEmpty((String)logRecord.getSnapshotId())) {
            FileData newScreen = new FileData();
            newScreen.setContentType("message");
            newScreen.setContent("Screenshot was deleted because the storage time is over.".getBytes());
            log.debug("Screenshot with id {} was deleted because the storage time is over, Log Record id {}.", (Object)logRecord.getSnapshotId(), (Object)logRecord.getUuid());
            screenShot = Optional.of(newScreen);
        }
        StringBuilder result = new StringBuilder();
        SourceShot sourceShot = new SourceShot();
        screenShot.ifPresent(image -> {
            sourceShot.setStepName(logRecord.getName());
            sourceShot.setMessage(logRecord.getMessage());
            sourceShot.setStatus(logRecord.getTestingStatus().getName());
            sourceShot.setType(image.getContentType());
            sourceShot.setSnapshotSource(image.getSource());
            if (image.getContentType().equalsIgnoreCase("image/png")) {
                result.append("data:").append(image.getContentType()).append(";base64,");
                result.append(Base64.getEncoder().encodeToString(image.getContent()));
            } else {
                result.append(new String(image.getContent()));
            }
        });
        log.trace("Get SourceShot for Log Record: {}:\n{}", (Object)logRecordId, (Object)result);
        sourceShot.setContent(result.toString());
        return sourceShot;
    }

    public FileData downloadFile(UUID logRecordId) {
        return this.composeFileDataWithLogRecord(this.lrRepository.findByUuid(logRecordId));
    }

    public String downloadFileIntoString(UUID logRecordId) {
        FileData fileData = this.downloadFile(logRecordId);
        if (FileContentType.BIN.equals((Object)FileContentTypeDetector.detect(fileData.getContent()))) {
            log.error("Can't represent file as string: logRecordId={}", (Object)logRecordId);
            throw new RamLogRecordFileAsStringException("", logRecordId);
        }
        return new String(fileData.getContent(), StandardCharsets.UTF_8);
    }

    public FileData downloadFileByName(UUID logRecordId, String filename) {
        String encodeFilename = UrlParamsUtils.decodeUrlPath(filename);
        return this.composeFileDataWithLogRecordByFileName(this.lrRepository.findByUuid(logRecordId), encodeFilename);
    }

    public String downloadFileIntoStringByName(UUID logRecordId, String filename) {
        FileData fileData = this.downloadFileByName(logRecordId, filename);
        if (FileContentType.BIN.equals((Object)FileContentTypeDetector.detect(fileData.getContent()))) {
            log.error("Can't represent file as string: logRecordId={}, filename={}", (Object)logRecordId, (Object)filename);
            throw new RamLogRecordFileAsStringException(filename, logRecordId);
        }
        return new String(fileData.getContent(), StandardCharsets.UTF_8);
    }

    private FileData composeFileDataWithLogRecordByFileName(LogRecord logRecord, String filename) {
        Optional<FileData> file = this.repository.getFileDataByFileName(logRecord.getUuid(), filename);
        return file.orElseThrow(() -> {
            log.error("File with id {} was deleted because the storage time is over, LogRecord id {}.", (Object)logRecord.getSnapshotId(), (Object)logRecord.getUuid());
            return new RamGridFsFileNotFoundException();
        });
    }

    private FileData composeFileDataWithLogRecord(LogRecord logRecord) {
        Optional<FileData> file = this.repository.getFileData(logRecord.getUuid());
        return file.orElseThrow(() -> {
            log.error("File with id {} was deleted because the storage time is over, LogRecord id {}.", (Object)logRecord.getSnapshotId(), (Object)logRecord.getUuid());
            return new RamGridFsFileNotFoundException();
        });
    }

    public List<ExtendedFileData> downloadFilesByLogRecords(List<LogRecord> logRecords) {
        List<UUID> logRecordsIds = StreamUtils.extractIdsToList(logRecords);
        return this.repository.getAllFilesWhereMetadataLogRecordIdInList(logRecordsIds);
    }

    public void removeFilesByRecordUuidList(List<UUID> logRecordUuidList) {
        this.repository.removeAttachment(logRecordUuidList);
    }

    public String save(String image, String creationTime, String contentType, UUID logRecordId, InputStream inputStream, String fileName, String snapshotSource) {
        return this.repository.save(image, creationTime, contentType, logRecordId, inputStream, fileName, snapshotSource);
    }

    public String save(String type, String creationTime, String contentType, UUID logRecordId, String content, String fileName) {
        ByteArrayInputStream bis = new ByteArrayInputStream(content.getBytes());
        log.debug("Store file {} for Log Record {}.", (Object)fileName, (Object)logRecordId);
        return this.repository.save(type, creationTime, contentType, logRecordId, bis, fileName, null);
    }

    public String save(String type, String creationTime, String contentType, UUID logRecordId, UUID testRunId, String content, String fileName) {
        ByteArrayInputStream bis = new ByteArrayInputStream(content.getBytes());
        log.info("Save request/response for LR {}", (Object)logRecordId);
        return this.repository.save(type, creationTime, contentType, logRecordId, testRunId, bis, fileName, null);
    }

    public GridFsFileData getReportById(UUID reportId) throws FileNotFoundException {
        log.info("Get report by id '{}'", (Object)reportId);
        return this.repository.getReportById(reportId);
    }

    public void saveMandatoryChecksReport(UUID reportId, UUID executionRequestId, InputStream fileInputStream, String fileName) {
        log.info("Save mandatory checks report for execution request with id '{}' with id '{}'", (Object)executionRequestId, (Object)reportId);
        this.repository.saveMandatoryChecksReport(reportId, executionRequestId, fileInputStream, fileName);
    }

    public int getCountScreen(List<LogRecord> logRecords) {
        return this.repository.getCountScreen(logRecords);
    }

    public void deleteExpiredFiles() {
        LocalDate checkedDate = LocalDate.now().minusDays(this.filesExpirationDaysInterval.intValue());
        log.debug("deleteExpiredFiles older then {}", (Object)checkedDate);
        this.repository.deleteByUploadDate(checkedDate);
    }

    public UUID saveSsmMetricReport(String fileName, String type, String contentType, InputStream inputStream, UUID executionRequestId, UUID logRecordId) {
        UUID reportId = UUID.randomUUID();
        log.debug("Generated report id: {}", (Object)reportId);
        HashMap<String, Object> metadata = new HashMap<String, Object>();
        metadata.put("reportId", reportId);
        if (Objects.nonNull(executionRequestId)) {
            metadata.put("executionRequestId", executionRequestId);
        }
        if (Objects.nonNull(logRecordId)) {
            metadata.put("logRecordUuid", logRecordId);
        }
        if (Objects.isNull(type)) {
            log.debug("Set default 'json' type");
            type = "json";
        }
        if (Objects.isNull(contentType)) {
            log.debug("Set default 'application/json' content type");
            contentType = "application/json";
        }
        log.debug("Metadata: {}", metadata);
        this.repository.save(fileName, type, contentType, inputStream, metadata);
        log.debug("Report file has been successfully uploaded");
        return reportId;
    }
}

