/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ram.services;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.qubership.atp.ram.dto.request.TestPlansSearchRequest;
import org.qubership.atp.ram.entities.MailRecipients;
import org.qubership.atp.ram.models.Project;
import org.qubership.atp.ram.models.TestPlan;
import org.qubership.atp.ram.repositories.TestPlansRepository;
import org.qubership.atp.ram.repositories.impl.CustomTestPlanRepository;
import org.qubership.atp.ram.services.CrudService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.mongodb.repository.MongoRepository;
import org.springframework.stereotype.Service;

@Service
public class TestPlansService
extends CrudService<TestPlan> {
    private static final Logger log = LoggerFactory.getLogger(TestPlansService.class);
    private final TestPlansRepository repository;
    private final CustomTestPlanRepository customRepository;

    @Override
    protected MongoRepository<TestPlan, UUID> repository() {
        return this.repository;
    }

    public List<TestPlan> getTestPlansByProjectUuid(UUID projectUuid) {
        return this.repository.findAllByProjectId(projectUuid);
    }

    @Override
    public TestPlan save(TestPlan testPlan) {
        Preconditions.checkArgument((boolean)Objects.nonNull(testPlan.getProjectId()), (Object)"ProjectUuid is required");
        Preconditions.checkArgument((boolean)Objects.nonNull(testPlan.getUuid()), (Object)"TestPlanUuid is required");
        return (TestPlan)this.repository.save(testPlan);
    }

    @Deprecated
    public TestPlan create(TestPlan testPlan) {
        Preconditions.checkNotNull((Object)testPlan.getProjectId(), (Object)"Project ID is required");
        TestPlan existTestPlan = this.findTestPlanByProjectUuidAndTestPlanName(testPlan.getProjectId(), testPlan.getName());
        if (Objects.nonNull(existTestPlan)) {
            log.warn("Test plan with name {} already exist for project {}", (Object)testPlan.getName(), (Object)testPlan.getProjectId());
            return (TestPlan)this.repository.save(existTestPlan);
        }
        return (TestPlan)this.repository.save(testPlan);
    }

    @Deprecated
    public TestPlan findTestPlanByProjectUuidAndTestPlanName(UUID projectUuid, String testPlanName) {
        Preconditions.checkArgument((boolean)Objects.nonNull(projectUuid), (Object)"ProjectUuid is required!");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)testPlanName) ? 1 : 0) != 0, (Object)"TestPlanName is required!");
        return this.repository.findByProjectIdAndName(projectUuid, testPlanName);
    }

    @Deprecated
    public synchronized TestPlan findOrCreateTestPlanByProjectUuidAndTestPlanName(UUID projectUuid, String testPlanName) {
        TestPlan result = this.findTestPlanByProjectUuidAndTestPlanName(projectUuid, testPlanName);
        if (Objects.nonNull(result)) {
            log.debug("TP exists {} by name + project ID", (Object)result.getUuid());
            return result;
        }
        result = new TestPlan();
        result.setProjectId(projectUuid);
        result.setName(testPlanName);
        this.repository.save(result);
        log.debug("TP create {} by name + project ID", (Object)result.getUuid());
        return result;
    }

    @Deprecated
    public synchronized TestPlan findOrCreateTestPlanByUuid(UUID projectId, UUID testPlanId, String testPlanName) {
        TestPlan result = this.repository.findByUuid(testPlanId);
        if (Objects.nonNull(result)) {
            log.debug("TP exists {} by ID", (Object)result.getUuid());
            return result;
        }
        result = new TestPlan();
        result.setProjectId(projectId);
        result.setName(testPlanName);
        result.setUuid(testPlanId);
        this.repository.save(result);
        log.debug("TP created {} by ID", (Object)result.getUuid());
        return result;
    }

    public TestPlan findByTestPlanUuid(UUID testPlanUuid) {
        Preconditions.checkArgument((boolean)Objects.nonNull(testPlanUuid), (Object)"TestPlanUuid is required!");
        return this.repository.findByUuid(testPlanUuid);
    }

    public MailRecipients getRecipients(UUID testPlanUuid) {
        return this.repository.findByUuid(testPlanUuid).getRecipients();
    }

    public void saveRecipients(UUID testPlanUuid, MailRecipients recipients) {
        TestPlan testPlan = this.findByTestPlanUuid(testPlanUuid);
        testPlan.setRecipients(recipients);
        this.save(testPlan);
    }

    public String getTestPlanName(UUID testPlanUuid) {
        return this.repository.findNameAndUuidAndProjectUuidByUuid(testPlanUuid).getName();
    }

    public TestPlan getTestPlanForNavigationPath(UUID testPlanUuid) {
        return this.repository.findNameAndUuidAndProjectUuidByUuid(testPlanUuid);
    }

    public UUID getProjectIdByTestPlanId(UUID id) {
        return this.repository.findNameAndUuidAndProjectUuidByUuid(id).getProjectId();
    }

    @Deprecated
    public TestPlan findByUuidNameOrCreateNew(TestPlan testPlan, Project project) {
        if (testPlan.getUuid() != null) {
            return this.findOrCreateTestPlanByUuid(project.getUuid(), testPlan.getUuid(), testPlan.getName());
        }
        return this.findOrCreateTestPlanByProjectUuidAndTestPlanName(project.getUuid(), testPlan.getName());
    }

    public List<TestPlan> search(TestPlansSearchRequest request) {
        return this.customRepository.search(request);
    }

    public TestPlansService(TestPlansRepository repository, CustomTestPlanRepository customRepository) {
        this.repository = repository;
        this.customRepository = customRepository;
    }
}

