/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ram.services;

import java.util.UUID;
import org.modelmapper.ModelMapper;
import org.qubership.atp.ram.models.usersettings.AbstractUserSetting;
import org.qubership.atp.ram.models.usersettings.UserSettingType;
import org.qubership.atp.ram.repositories.UserSettingRepository;
import org.qubership.atp.ram.services.CrudService;
import org.qubership.atp.ram.services.UserService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.mongodb.repository.MongoRepository;
import org.springframework.stereotype.Service;

@Service
public class UserSettingService
extends CrudService<AbstractUserSetting> {
    private static final Logger log = LoggerFactory.getLogger(UserSettingService.class);
    private final UserSettingRepository userSettingRepository;
    private final ModelMapper modelMapper;
    private final UserService userService;

    public AbstractUserSetting getByUserAndType(String userToken, UserSettingType type) {
        UUID userId = this.userService.getUserIdFromToken(userToken);
        return this.userSettingRepository.findByUserIdAndType(userId, type);
    }

    public AbstractUserSetting create(AbstractUserSetting setting, String userToken) {
        UUID userId = this.userService.getUserIdFromToken(userToken);
        setting.setUserId(userId);
        return this.save(setting);
    }

    public AbstractUserSetting update(UUID id, AbstractUserSetting setting, String userToken) {
        AbstractUserSetting existedSetting = (AbstractUserSetting)this.get(id);
        this.modelMapper.map((Object)setting, (Object)existedSetting);
        UUID userId = this.userService.getUserIdFromToken(userToken);
        existedSetting.setUserId(userId);
        return this.save(existedSetting);
    }

    @Override
    protected MongoRepository<AbstractUserSetting, UUID> repository() {
        return this.userSettingRepository;
    }

    public UserSettingService(UserSettingRepository userSettingRepository, ModelMapper modelMapper, UserService userService) {
        this.userSettingRepository = userSettingRepository;
        this.modelMapper = modelMapper;
        this.userService = userService;
    }
}

