package org.qubership.atp.dataset.clients.dto;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.ArrayList;
import java.util.List;
import org.qubership.atp.dataset.clients.dto.AttributeImportResponseDto;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * DatasetListImportResponseDto
 */

@JsonTypeName("DatasetListImportResponse")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2025-07-10T07:28:19.481614936Z[Etc/UTC]")
public class DatasetListImportResponseDto {

  @JsonProperty("attributes")
  @Valid
  private List<AttributeImportResponseDto> attributes = null;

  public DatasetListImportResponseDto attributes(List<AttributeImportResponseDto> attributes) {
    this.attributes = attributes;
    return this;
  }

  public DatasetListImportResponseDto addAttributesItem(AttributeImportResponseDto attributesItem) {
    if (this.attributes == null) {
      this.attributes = new ArrayList<>();
    }
    this.attributes.add(attributesItem);
    return this;
  }

  /**
   * Get attributes
   * @return attributes
  */
  @Valid 
  @Schema(name = "attributes", required = false)
  public List<AttributeImportResponseDto> getAttributes() {
    return attributes;
  }

  public void setAttributes(List<AttributeImportResponseDto> attributes) {
    this.attributes = attributes;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DatasetListImportResponseDto datasetListImportResponse = (DatasetListImportResponseDto) o;
    return Objects.equals(this.attributes, datasetListImportResponse.attributes);
  }

  @Override
  public int hashCode() {
    return Objects.hash(attributes);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DatasetListImportResponseDto {\n");
    sb.append("    attributes: ").append(toIndentedString(attributes)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

