/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech) (6.2.1).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
package org.qubership.atp.orchestrator.clients.api;

import org.qubership.atp.orchestrator.clients.dto.ExecutionOrderDto;
import org.qubership.atp.orchestrator.clients.dto.FlowExecutionRequestDto;
import java.util.List;
import org.qubership.atp.orchestrator.clients.dto.RerunExecutionRequestDto;
import org.qubership.atp.orchestrator.clients.dto.TerminateRequestDto;
import java.util.UUID;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.multipart.MultipartFile;

import javax.validation.Valid;
import javax.validation.constraints.*;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;

@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2025-07-10T07:28:19.016501341Z[Etc/UTC]")
@Validated
@Tag(name = "ProcessController", description = "Process Controller")
public interface ProcessControllerApi {

    /**
     * POST /api/v1/processorchestrator/flow/order : Create new process via Dealer or Exists Engine
     *
     * @param authorization authorization (optional)
     * @param executionOrderDto  (optional)
     * @return OK (status code 200)
     *         or Created (status code 201)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "executeOrder",
        summary = "Create new process via Dealer or Exists Engine",
        tags = { "process-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = UUID.class))
            }),
            @ApiResponse(responseCode = "201", description = "Created"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/api/v1/processorchestrator/flow/order",
        produces = { "application/json" },
        consumes = { "application/json" }
    )
    ResponseEntity<List<UUID>> executeOrder(
        @Parameter(name = "authorization", description = "authorization") @RequestHeader(value = "authorization", required = false) String authorization,
        @Parameter(name = "ExecutionOrderDto", description = "") @Valid @RequestBody(required = false) ExecutionOrderDto executionOrderDto
    );


    /**
     * POST /api/v1/processorchestrator/flow : Create new process via Dealer or Exists Engine
     *
     * @param flowExecutionRequestDto  (optional)
     * @return OK (status code 200)
     *         or Created (status code 201)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "executeProcessViaDealer",
        summary = "Create new process via Dealer or Exists Engine",
        tags = { "process-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = UUID.class))
            }),
            @ApiResponse(responseCode = "201", description = "Created"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/api/v1/processorchestrator/flow",
        produces = { "application/json" },
        consumes = { "application/json" }
    )
    ResponseEntity<UUID> executeProcessViaDealer(
        @Parameter(name = "FlowExecutionRequestDto", description = "") @Valid @RequestBody(required = false) FlowExecutionRequestDto flowExecutionRequestDto
    );


    /**
     * POST /api/v1/processorchestrator/flow/bpmn : Create new process via Dealer or Exists Engine
     *
     * @param flowExecutionRequestDto  (optional)
     * @return OK (status code 200)
     *         or Created (status code 201)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "executeProcessViaDynamicBpmnGeneration",
        summary = "Create new process via Dealer or Exists Engine",
        tags = { "process-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = UUID.class))
            }),
            @ApiResponse(responseCode = "201", description = "Created"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/api/v1/processorchestrator/flow/bpmn",
        produces = { "application/json" },
        consumes = { "application/json" }
    )
    ResponseEntity<UUID> executeProcessViaDynamicBpmnGeneration(
        @Parameter(name = "FlowExecutionRequestDto", description = "") @Valid @RequestBody(required = false) FlowExecutionRequestDto flowExecutionRequestDto
    );


    /**
     * GET /api/v1/processorchestrator/flow/er/{executionRequestId}/process/id : Get runner process id by execution request
     *
     * @param executionRequestId executionRequestId (required)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getRunnerProcessIdByExecutionRequestId",
        summary = "Get runner process id by execution request",
        tags = { "process-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = UUID.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/api/v1/processorchestrator/flow/er/{executionRequestId}/process/id",
        produces = { "application/json" }
    )
    ResponseEntity<UUID> getRunnerProcessIdByExecutionRequestId(
        @Parameter(name = "executionRequestId", description = "executionRequestId", required = true) @PathVariable("executionRequestId") UUID executionRequestId
    );


    /**
     * POST /api/v1/processorchestrator/flow/er/process/rerun : Restart ER with selected TR ids activity
     *
     * @param newExecuteRequestId newExecuteRequestId (optional)
     * @param authorization authorization (optional)
     * @param rerunExecutionRequestDto  (optional)
     * @return OK (status code 200)
     *         or Created (status code 201)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "rerunExecutionRequestProcess",
        summary = "Restart ER with selected TR ids activity",
        tags = { "process-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = UUID.class))
            }),
            @ApiResponse(responseCode = "201", description = "Created"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/api/v1/processorchestrator/flow/er/process/rerun",
        produces = { "application/json" },
        consumes = { "application/json" }
    )
    ResponseEntity<UUID> rerunExecutionRequestProcess(
        @Parameter(name = "newExecuteRequestId", description = "newExecuteRequestId") @Valid @RequestParam(value = "newExecuteRequestId", required = false) UUID newExecuteRequestId,
        @Parameter(name = "authorization", description = "authorization") @RequestHeader(value = "authorization", required = false) String authorization,
        @Parameter(name = "RerunExecutionRequestDto", description = "") @Valid @RequestBody(required = false) RerunExecutionRequestDto rerunExecutionRequestDto
    );


    /**
     * POST /api/v1/processorchestrator/flow/er/process/restart/{uuid} : Restart ER with selected TR ids activity
     *
     * @param uuid uuid (required)
     * @param authorization Authorization (optional)
     * @param UUID  (optional)
     * @return OK (status code 200)
     *         or Created (status code 201)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "rerunTestRunsProcess",
        summary = "Restart ER with selected TR ids activity",
        tags = { "process-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = UUID.class))
            }),
            @ApiResponse(responseCode = "201", description = "Created"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/api/v1/processorchestrator/flow/er/process/restart/{uuid}",
        produces = { "application/json" },
        consumes = { "application/json" }
    )
    ResponseEntity<UUID> rerunTestRunsProcess(
        @Parameter(name = "uuid", description = "uuid", required = true) @PathVariable("uuid") UUID uuid,
        @Parameter(name = "Authorization", description = "Authorization") @RequestHeader(value = "Authorization", required = false) String authorization,
        @Parameter(name = "UUID", description = "") @Valid @RequestBody(required = false) List<UUID> UUID
    );


    /**
     * POST /api/v1/processorchestrator/flow/er/process/restart : Restart ER process
     *
     * @param UUID  (optional)
     * @return OK (status code 200)
     *         or Created (status code 201)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "restartProcess",
        summary = "Restart ER process",
        tags = { "process-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "text/plain", schema = @Schema(implementation = String.class))
            }),
            @ApiResponse(responseCode = "201", description = "Created"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/api/v1/processorchestrator/flow/er/process/restart",
        produces = { "text/plain" },
        consumes = { "application/json" }
    )
    ResponseEntity<String> restartProcess(
        @Parameter(name = "UUID", description = "") @Valid @RequestBody(required = false) List<UUID> UUID
    );


    /**
     * POST /api/v1/processorchestrator/flow/tr/process/restart : Restart TR activity
     *
     * @param executionRequestId executionRequestId (required)
     * @param UUID  (optional)
     * @return OK (status code 200)
     *         or Created (status code 201)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "restartTestRunProcess",
        summary = "Restart TR activity",
        tags = { "process-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "text/plain", schema = @Schema(implementation = String.class))
            }),
            @ApiResponse(responseCode = "201", description = "Created"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/api/v1/processorchestrator/flow/tr/process/restart",
        produces = { "text/plain" },
        consumes = { "application/json" }
    )
    ResponseEntity<String> restartTestRunProcess(
        @NotNull @Parameter(name = "executionRequestId", description = "executionRequestId", required = true) @Valid @RequestParam(value = "executionRequestId", required = true) UUID executionRequestId,
        @Parameter(name = "UUID", description = "") @Valid @RequestBody(required = false) List<UUID> UUID
    );


    /**
     * POST /api/v1/processorchestrator/flow/er/process/resume : Resume ER process
     *
     * @param UUID  (optional)
     * @return OK (status code 200)
     *         or Created (status code 201)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "resumeProcess",
        summary = "Resume ER process",
        tags = { "process-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "text/plain", schema = @Schema(implementation = String.class))
            }),
            @ApiResponse(responseCode = "201", description = "Created"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/api/v1/processorchestrator/flow/er/process/resume",
        produces = { "text/plain" },
        consumes = { "application/json" }
    )
    ResponseEntity<String> resumeProcess(
        @Parameter(name = "UUID", description = "") @Valid @RequestBody(required = false) List<UUID> UUID
    );


    /**
     * POST /api/v1/processorchestrator/flow/tr/process/resume : Resume TR activity
     *
     * @param executionRequestId executionRequestId (required)
     * @param UUID  (optional)
     * @return OK (status code 200)
     *         or Created (status code 201)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "resumeTestRunProcess",
        summary = "Resume TR activity",
        tags = { "process-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "text/plain", schema = @Schema(implementation = String.class))
            }),
            @ApiResponse(responseCode = "201", description = "Created"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/api/v1/processorchestrator/flow/tr/process/resume",
        produces = { "text/plain" },
        consumes = { "application/json" }
    )
    ResponseEntity<String> resumeTestRunProcess(
        @NotNull @Parameter(name = "executionRequestId", description = "executionRequestId", required = true) @Valid @RequestParam(value = "executionRequestId", required = true) UUID executionRequestId,
        @Parameter(name = "UUID", description = "") @Valid @RequestBody(required = false) List<UUID> UUID
    );


    /**
     * POST /api/v1/processorchestrator/flow/er/process/stop : Stop ER process
     *
     * @param UUID  (optional)
     * @return OK (status code 200)
     *         or Created (status code 201)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "stopProcess",
        summary = "Stop ER process",
        tags = { "process-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "text/plain", schema = @Schema(implementation = String.class))
            }),
            @ApiResponse(responseCode = "201", description = "Created"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/api/v1/processorchestrator/flow/er/process/stop",
        produces = { "text/plain" },
        consumes = { "application/json" }
    )
    ResponseEntity<String> stopProcess(
        @Parameter(name = "UUID", description = "") @Valid @RequestBody(required = false) List<UUID> UUID
    );


    /**
     * POST /api/v1/processorchestrator/flow/tr/process/stop : Stop TR activity
     *
     * @param executionRequestId executionRequestId (required)
     * @param UUID  (optional)
     * @return OK (status code 200)
     *         or Created (status code 201)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "stopTestRunProcess",
        summary = "Stop TR activity",
        tags = { "process-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "text/plain", schema = @Schema(implementation = String.class))
            }),
            @ApiResponse(responseCode = "201", description = "Created"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/api/v1/processorchestrator/flow/tr/process/stop",
        produces = { "text/plain" },
        consumes = { "application/json" }
    )
    ResponseEntity<String> stopTestRunProcess(
        @NotNull @Parameter(name = "executionRequestId", description = "executionRequestId", required = true) @Valid @RequestParam(value = "executionRequestId", required = true) UUID executionRequestId,
        @Parameter(name = "UUID", description = "") @Valid @RequestBody(required = false) List<UUID> UUID
    );


    /**
     * POST /api/v1/processorchestrator/flow/store : Store Execution Order to Orchestrator Database
     *
     * @param authorization authorization (optional)
     * @param executionOrderDto  (optional)
     * @return OK (status code 200)
     *         or Created (status code 201)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "storeExecutionOrder",
        summary = "Store Execution Order to Orchestrator Database",
        tags = { "process-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = UUID.class))
            }),
            @ApiResponse(responseCode = "201", description = "Created"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/api/v1/processorchestrator/flow/store",
        produces = { "application/json" },
        consumes = { "application/json" }
    )
    ResponseEntity<List<UUID>> storeExecutionOrder(
        @Parameter(name = "authorization", description = "authorization") @RequestHeader(value = "authorization", required = false) String authorization,
        @Parameter(name = "ExecutionOrderDto", description = "") @Valid @RequestBody(required = false) ExecutionOrderDto executionOrderDto
    );


    /**
     * POST /api/v1/processorchestrator/flow/er/process/terminate : Terminate ER process
     *
     * @param terminateRequestDto  (optional)
     * @return OK (status code 200)
     *         or Created (status code 201)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "terminateProcess",
        summary = "Terminate ER process",
        tags = { "process-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "text/plain", schema = @Schema(implementation = String.class))
            }),
            @ApiResponse(responseCode = "201", description = "Created"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/api/v1/processorchestrator/flow/er/process/terminate",
        produces = { "text/plain" },
        consumes = { "application/json" }
    )
    ResponseEntity<String> terminateProcess(
        @Parameter(name = "TerminateRequestDto", description = "") @Valid @RequestBody(required = false) TerminateRequestDto terminateRequestDto
    );


    /**
     * POST /api/v1/processorchestrator/flow/tr/process/terminate : Terminate TR activity
     *
     * @param UUID  (optional)
     * @return OK (status code 200)
     *         or Created (status code 201)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "terminateTestRunProcess",
        summary = "Terminate TR activity",
        tags = { "process-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "text/plain", schema = @Schema(implementation = String.class))
            }),
            @ApiResponse(responseCode = "201", description = "Created"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/api/v1/processorchestrator/flow/tr/process/terminate",
        produces = { "text/plain" },
        consumes = { "application/json" }
    )
    ResponseEntity<String> terminateTestRunProcess(
        @Parameter(name = "UUID", description = "") @Valid @RequestBody(required = false) List<UUID> UUID
    );

}
