package org.qubership.atp.orchestrator.clients.dto;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.qubership.atp.orchestrator.clients.dto.EnrichedCaseDto;
import org.qubership.atp.orchestrator.clients.dto.EnrichedScenarioDto;
import org.qubership.atp.orchestrator.clients.dto.FlagDto;
import org.qubership.atp.orchestrator.clients.dto.LogCollectorRequestDto;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * EnrichedScopeDto
 */

@JsonTypeName("EnrichedScope")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2025-07-10T07:28:19.016501341Z[Etc/UTC]")
public class EnrichedScopeDto {

  @JsonProperty("context")
  @Valid
  private Map<String, Map<String, Object>> context = null;

  @JsonProperty("scenarios")
  @Valid
  private Map<String, EnrichedScenarioDto> scenarios = null;

  @JsonProperty("execution")
  @Valid
  private List<EnrichedCaseDto> execution = null;

  @JsonProperty("flags")
  @Valid
  private List<FlagDto> flags = null;

  @JsonProperty("id")
  private UUID id;

  @JsonProperty("logCollectorRequest")
  private LogCollectorRequestDto logCollectorRequest;

  @JsonProperty("name")
  private String name;

  @JsonProperty("prerequisites")
  @Valid
  private List<EnrichedCaseDto> prerequisites = null;

  @JsonProperty("validation")
  @Valid
  private List<EnrichedCaseDto> validation = null;

  public EnrichedScopeDto context(Map<String, Map<String, Object>> context) {
    this.context = context;
    return this;
  }

  public EnrichedScopeDto putContextItem(String key, Map<String, Object> contextItem) {
    if (this.context == null) {
      this.context = new HashMap<>();
    }
    this.context.put(key, contextItem);
    return this;
  }

  /**
   * Get context
   * @return context
  */
  @Valid 
  @Schema(name = "context", required = false)
  public Map<String, Map<String, Object>> getContext() {
    return context;
  }

  public void setContext(Map<String, Map<String, Object>> context) {
    this.context = context;
  }

  public EnrichedScopeDto scenarios(Map<String, EnrichedScenarioDto> scenarios) {
    this.scenarios = scenarios;
    return this;
  }

  public EnrichedScopeDto putScenariosItem(String key, EnrichedScenarioDto scenariosItem) {
    if (this.scenarios == null) {
      this.scenarios = new HashMap<>();
    }
    this.scenarios.put(key, scenariosItem);
    return this;
  }

  /**
   * Get scenarios
   * @return scenarios
  */
  @Valid 
  @Schema(name = "scenarios", required = false)
  public Map<String, EnrichedScenarioDto> getScenarios() {
    return scenarios;
  }

  public void setScenarios(Map<String, EnrichedScenarioDto> scenarios) {
    this.scenarios = scenarios;
  }

  public EnrichedScopeDto execution(List<EnrichedCaseDto> execution) {
    this.execution = execution;
    return this;
  }

  public EnrichedScopeDto addExecutionItem(EnrichedCaseDto executionItem) {
    if (this.execution == null) {
      this.execution = new ArrayList<>();
    }
    this.execution.add(executionItem);
    return this;
  }

  /**
   * Get execution
   * @return execution
  */
  @Valid 
  @Schema(name = "execution", required = false)
  public List<EnrichedCaseDto> getExecution() {
    return execution;
  }

  public void setExecution(List<EnrichedCaseDto> execution) {
    this.execution = execution;
  }

  public EnrichedScopeDto flags(List<FlagDto> flags) {
    this.flags = flags;
    return this;
  }

  public EnrichedScopeDto addFlagsItem(FlagDto flagsItem) {
    if (this.flags == null) {
      this.flags = new ArrayList<>();
    }
    this.flags.add(flagsItem);
    return this;
  }

  /**
   * Get flags
   * @return flags
  */
  @Valid 
  @Schema(name = "flags", required = false)
  public List<FlagDto> getFlags() {
    return flags;
  }

  public void setFlags(List<FlagDto> flags) {
    this.flags = flags;
  }

  public EnrichedScopeDto id(UUID id) {
    this.id = id;
    return this;
  }

  /**
   * Get id
   * @return id
  */
  @Valid 
  @Schema(name = "id", required = false)
  public UUID getId() {
    return id;
  }

  public void setId(UUID id) {
    this.id = id;
  }

  public EnrichedScopeDto logCollectorRequest(LogCollectorRequestDto logCollectorRequest) {
    this.logCollectorRequest = logCollectorRequest;
    return this;
  }

  /**
   * Get logCollectorRequest
   * @return logCollectorRequest
  */
  @Valid 
  @Schema(name = "logCollectorRequest", required = false)
  public LogCollectorRequestDto getLogCollectorRequest() {
    return logCollectorRequest;
  }

  public void setLogCollectorRequest(LogCollectorRequestDto logCollectorRequest) {
    this.logCollectorRequest = logCollectorRequest;
  }

  public EnrichedScopeDto name(String name) {
    this.name = name;
    return this;
  }

  /**
   * Get name
   * @return name
  */
  
  @Schema(name = "name", required = false)
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public EnrichedScopeDto prerequisites(List<EnrichedCaseDto> prerequisites) {
    this.prerequisites = prerequisites;
    return this;
  }

  public EnrichedScopeDto addPrerequisitesItem(EnrichedCaseDto prerequisitesItem) {
    if (this.prerequisites == null) {
      this.prerequisites = new ArrayList<>();
    }
    this.prerequisites.add(prerequisitesItem);
    return this;
  }

  /**
   * Get prerequisites
   * @return prerequisites
  */
  @Valid 
  @Schema(name = "prerequisites", required = false)
  public List<EnrichedCaseDto> getPrerequisites() {
    return prerequisites;
  }

  public void setPrerequisites(List<EnrichedCaseDto> prerequisites) {
    this.prerequisites = prerequisites;
  }

  public EnrichedScopeDto validation(List<EnrichedCaseDto> validation) {
    this.validation = validation;
    return this;
  }

  public EnrichedScopeDto addValidationItem(EnrichedCaseDto validationItem) {
    if (this.validation == null) {
      this.validation = new ArrayList<>();
    }
    this.validation.add(validationItem);
    return this;
  }

  /**
   * Get validation
   * @return validation
  */
  @Valid 
  @Schema(name = "validation", required = false)
  public List<EnrichedCaseDto> getValidation() {
    return validation;
  }

  public void setValidation(List<EnrichedCaseDto> validation) {
    this.validation = validation;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    EnrichedScopeDto enrichedScope = (EnrichedScopeDto) o;
    return Objects.equals(this.context, enrichedScope.context) &&
        Objects.equals(this.scenarios, enrichedScope.scenarios) &&
        Objects.equals(this.execution, enrichedScope.execution) &&
        Objects.equals(this.flags, enrichedScope.flags) &&
        Objects.equals(this.id, enrichedScope.id) &&
        Objects.equals(this.logCollectorRequest, enrichedScope.logCollectorRequest) &&
        Objects.equals(this.name, enrichedScope.name) &&
        Objects.equals(this.prerequisites, enrichedScope.prerequisites) &&
        Objects.equals(this.validation, enrichedScope.validation);
  }

  @Override
  public int hashCode() {
    return Objects.hash(context, scenarios, execution, flags, id, logCollectorRequest, name, prerequisites, validation);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class EnrichedScopeDto {\n");
    sb.append("    context: ").append(toIndentedString(context)).append("\n");
    sb.append("    scenarios: ").append(toIndentedString(scenarios)).append("\n");
    sb.append("    execution: ").append(toIndentedString(execution)).append("\n");
    sb.append("    flags: ").append(toIndentedString(flags)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    logCollectorRequest: ").append(toIndentedString(logCollectorRequest)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    prerequisites: ").append(toIndentedString(prerequisites)).append("\n");
    sb.append("    validation: ").append(toIndentedString(validation)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

