package org.qubership.atp.orchestrator.clients.dto;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.qubership.atp.orchestrator.clients.dto.EngineDto;
import org.qubership.atp.orchestrator.clients.dto.EnrichedScopeDto;
import org.qubership.atp.orchestrator.clients.dto.SystemDto;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * FlowExecutionRequestDto
 */

@JsonTypeName("FlowExecutionRequest")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2025-07-10T07:28:19.016501341Z[Etc/UTC]")
public class FlowExecutionRequestDto {

  @JsonProperty("autoSyncCasesWithJira")
  private Boolean autoSyncCasesWithJira;

  @JsonProperty("autoSyncRunsWithJira")
  private Boolean autoSyncRunsWithJira;

  @JsonProperty("contextVariables")
  private Object contextVariables;

  @JsonProperty("dataSetId")
  private UUID dataSetId;

  @JsonProperty("dataSetStorageId")
  private UUID dataSetStorageId;

  @JsonProperty("emailSubject")
  private String emailSubject;

  @JsonProperty("emailTemplateId")
  private UUID emailTemplateId;

  @JsonProperty("emails")
  @Valid
  private List<String> emails = null;

  @JsonProperty("engine")
  private EngineDto engine;

  @JsonProperty("environmentId")
  private UUID environmentId;

  @JsonProperty("executionRequestId")
  private UUID executionRequestId;

  @JsonProperty("executionRequestName")
  private String executionRequestName;

  @JsonProperty("executor")
  private String executor;

  @JsonProperty("executorId")
  private UUID executorId;

  @JsonProperty("itfTestRunId")
  private BigDecimal itfTestRunId;

  @JsonProperty("labelTemplateId")
  private UUID labelTemplateId;

  @JsonProperty("projectId")
  private UUID projectId;

  @JsonProperty("projectName")
  private String projectName;

  @JsonProperty("scope")
  private EnrichedScopeDto scope;

  @JsonProperty("systems")
  @Valid
  private List<SystemDto> systems = null;

  @JsonProperty("taSystems")
  @Valid
  private List<SystemDto> taSystems = null;

  @JsonProperty("taToolsGroupId")
  private UUID taToolsGroupId;

  @JsonProperty("testPlanId")
  private UUID testPlanId;

  @JsonProperty("testPlanName")
  private String testPlanName;

  @JsonProperty("testRunId")
  private UUID testRunId;

  @JsonProperty("testRunName")
  private String testRunName;

  @JsonProperty("testSuiteName")
  private String testSuiteName;

  @JsonProperty("threadCount")
  private Integer threadCount;

  @JsonProperty("toolsInfo")
  @Valid
  private Map<String, String> toolsInfo = null;

  @JsonProperty("widgetConfigTemplateId")
  private UUID widgetConfigTemplateId;

  public FlowExecutionRequestDto autoSyncCasesWithJira(Boolean autoSyncCasesWithJira) {
    this.autoSyncCasesWithJira = autoSyncCasesWithJira;
    return this;
  }

  /**
   * Get autoSyncCasesWithJira
   * @return autoSyncCasesWithJira
  */
  
  @Schema(name = "autoSyncCasesWithJira", required = false)
  public Boolean getAutoSyncCasesWithJira() {
    return autoSyncCasesWithJira;
  }

  public void setAutoSyncCasesWithJira(Boolean autoSyncCasesWithJira) {
    this.autoSyncCasesWithJira = autoSyncCasesWithJira;
  }

  public FlowExecutionRequestDto autoSyncRunsWithJira(Boolean autoSyncRunsWithJira) {
    this.autoSyncRunsWithJira = autoSyncRunsWithJira;
    return this;
  }

  /**
   * Get autoSyncRunsWithJira
   * @return autoSyncRunsWithJira
  */
  
  @Schema(name = "autoSyncRunsWithJira", required = false)
  public Boolean getAutoSyncRunsWithJira() {
    return autoSyncRunsWithJira;
  }

  public void setAutoSyncRunsWithJira(Boolean autoSyncRunsWithJira) {
    this.autoSyncRunsWithJira = autoSyncRunsWithJira;
  }

  public FlowExecutionRequestDto contextVariables(Object contextVariables) {
    this.contextVariables = contextVariables;
    return this;
  }

  /**
   * Get contextVariables
   * @return contextVariables
  */
  
  @Schema(name = "contextVariables", required = false)
  public Object getContextVariables() {
    return contextVariables;
  }

  public void setContextVariables(Object contextVariables) {
    this.contextVariables = contextVariables;
  }

  public FlowExecutionRequestDto dataSetId(UUID dataSetId) {
    this.dataSetId = dataSetId;
    return this;
  }

  /**
   * Get dataSetId
   * @return dataSetId
  */
  @Valid 
  @Schema(name = "dataSetId", required = false)
  public UUID getDataSetId() {
    return dataSetId;
  }

  public void setDataSetId(UUID dataSetId) {
    this.dataSetId = dataSetId;
  }

  public FlowExecutionRequestDto dataSetStorageId(UUID dataSetStorageId) {
    this.dataSetStorageId = dataSetStorageId;
    return this;
  }

  /**
   * Get dataSetStorageId
   * @return dataSetStorageId
  */
  @Valid 
  @Schema(name = "dataSetStorageId", required = false)
  public UUID getDataSetStorageId() {
    return dataSetStorageId;
  }

  public void setDataSetStorageId(UUID dataSetStorageId) {
    this.dataSetStorageId = dataSetStorageId;
  }

  public FlowExecutionRequestDto emailSubject(String emailSubject) {
    this.emailSubject = emailSubject;
    return this;
  }

  /**
   * Get emailSubject
   * @return emailSubject
  */
  
  @Schema(name = "emailSubject", required = false)
  public String getEmailSubject() {
    return emailSubject;
  }

  public void setEmailSubject(String emailSubject) {
    this.emailSubject = emailSubject;
  }

  public FlowExecutionRequestDto emailTemplateId(UUID emailTemplateId) {
    this.emailTemplateId = emailTemplateId;
    return this;
  }

  /**
   * Get emailTemplateId
   * @return emailTemplateId
  */
  @Valid 
  @Schema(name = "emailTemplateId", required = false)
  public UUID getEmailTemplateId() {
    return emailTemplateId;
  }

  public void setEmailTemplateId(UUID emailTemplateId) {
    this.emailTemplateId = emailTemplateId;
  }

  public FlowExecutionRequestDto emails(List<String> emails) {
    this.emails = emails;
    return this;
  }

  public FlowExecutionRequestDto addEmailsItem(String emailsItem) {
    if (this.emails == null) {
      this.emails = new ArrayList<>();
    }
    this.emails.add(emailsItem);
    return this;
  }

  /**
   * Get emails
   * @return emails
  */
  
  @Schema(name = "emails", required = false)
  public List<String> getEmails() {
    return emails;
  }

  public void setEmails(List<String> emails) {
    this.emails = emails;
  }

  public FlowExecutionRequestDto engine(EngineDto engine) {
    this.engine = engine;
    return this;
  }

  /**
   * Get engine
   * @return engine
  */
  @NotNull @Valid 
  @Schema(name = "engine", required = true)
  public EngineDto getEngine() {
    return engine;
  }

  public void setEngine(EngineDto engine) {
    this.engine = engine;
  }

  public FlowExecutionRequestDto environmentId(UUID environmentId) {
    this.environmentId = environmentId;
    return this;
  }

  /**
   * Get environmentId
   * @return environmentId
  */
  @NotNull @Valid 
  @Schema(name = "environmentId", required = true)
  public UUID getEnvironmentId() {
    return environmentId;
  }

  public void setEnvironmentId(UUID environmentId) {
    this.environmentId = environmentId;
  }

  public FlowExecutionRequestDto executionRequestId(UUID executionRequestId) {
    this.executionRequestId = executionRequestId;
    return this;
  }

  /**
   * Get executionRequestId
   * @return executionRequestId
  */
  @Valid 
  @Schema(name = "executionRequestId", required = false)
  public UUID getExecutionRequestId() {
    return executionRequestId;
  }

  public void setExecutionRequestId(UUID executionRequestId) {
    this.executionRequestId = executionRequestId;
  }

  public FlowExecutionRequestDto executionRequestName(String executionRequestName) {
    this.executionRequestName = executionRequestName;
    return this;
  }

  /**
   * Get executionRequestName
   * @return executionRequestName
  */
  @NotNull 
  @Schema(name = "executionRequestName", required = true)
  public String getExecutionRequestName() {
    return executionRequestName;
  }

  public void setExecutionRequestName(String executionRequestName) {
    this.executionRequestName = executionRequestName;
  }

  public FlowExecutionRequestDto executor(String executor) {
    this.executor = executor;
    return this;
  }

  /**
   * Get executor
   * @return executor
  */
  
  @Schema(name = "executor", required = false)
  public String getExecutor() {
    return executor;
  }

  public void setExecutor(String executor) {
    this.executor = executor;
  }

  public FlowExecutionRequestDto executorId(UUID executorId) {
    this.executorId = executorId;
    return this;
  }

  /**
   * Get executorId
   * @return executorId
  */
  @Valid 
  @Schema(name = "executorId", required = false)
  public UUID getExecutorId() {
    return executorId;
  }

  public void setExecutorId(UUID executorId) {
    this.executorId = executorId;
  }

  public FlowExecutionRequestDto itfTestRunId(BigDecimal itfTestRunId) {
    this.itfTestRunId = itfTestRunId;
    return this;
  }

  /**
   * Get itfTestRunId
   * @return itfTestRunId
  */
  @Valid 
  @Schema(name = "itfTestRunId", required = false)
  public BigDecimal getItfTestRunId() {
    return itfTestRunId;
  }

  public void setItfTestRunId(BigDecimal itfTestRunId) {
    this.itfTestRunId = itfTestRunId;
  }

  public FlowExecutionRequestDto labelTemplateId(UUID labelTemplateId) {
    this.labelTemplateId = labelTemplateId;
    return this;
  }

  /**
   * Get labelTemplateId
   * @return labelTemplateId
  */
  @Valid 
  @Schema(name = "labelTemplateId", required = false)
  public UUID getLabelTemplateId() {
    return labelTemplateId;
  }

  public void setLabelTemplateId(UUID labelTemplateId) {
    this.labelTemplateId = labelTemplateId;
  }

  public FlowExecutionRequestDto projectId(UUID projectId) {
    this.projectId = projectId;
    return this;
  }

  /**
   * Get projectId
   * @return projectId
  */
  @NotNull @Valid 
  @Schema(name = "projectId", required = true)
  public UUID getProjectId() {
    return projectId;
  }

  public void setProjectId(UUID projectId) {
    this.projectId = projectId;
  }

  public FlowExecutionRequestDto projectName(String projectName) {
    this.projectName = projectName;
    return this;
  }

  /**
   * Get projectName
   * @return projectName
  */
  @NotNull 
  @Schema(name = "projectName", required = true)
  public String getProjectName() {
    return projectName;
  }

  public void setProjectName(String projectName) {
    this.projectName = projectName;
  }

  public FlowExecutionRequestDto scope(EnrichedScopeDto scope) {
    this.scope = scope;
    return this;
  }

  /**
   * Get scope
   * @return scope
  */
  @NotNull @Valid 
  @Schema(name = "scope", required = true)
  public EnrichedScopeDto getScope() {
    return scope;
  }

  public void setScope(EnrichedScopeDto scope) {
    this.scope = scope;
  }

  public FlowExecutionRequestDto systems(List<SystemDto> systems) {
    this.systems = systems;
    return this;
  }

  public FlowExecutionRequestDto addSystemsItem(SystemDto systemsItem) {
    if (this.systems == null) {
      this.systems = new ArrayList<>();
    }
    this.systems.add(systemsItem);
    return this;
  }

  /**
   * Get systems
   * @return systems
  */
  @Valid 
  @Schema(name = "systems", required = false)
  public List<SystemDto> getSystems() {
    return systems;
  }

  public void setSystems(List<SystemDto> systems) {
    this.systems = systems;
  }

  public FlowExecutionRequestDto taSystems(List<SystemDto> taSystems) {
    this.taSystems = taSystems;
    return this;
  }

  public FlowExecutionRequestDto addTaSystemsItem(SystemDto taSystemsItem) {
    if (this.taSystems == null) {
      this.taSystems = new ArrayList<>();
    }
    this.taSystems.add(taSystemsItem);
    return this;
  }

  /**
   * Get taSystems
   * @return taSystems
  */
  @Valid 
  @Schema(name = "taSystems", required = false)
  public List<SystemDto> getTaSystems() {
    return taSystems;
  }

  public void setTaSystems(List<SystemDto> taSystems) {
    this.taSystems = taSystems;
  }

  public FlowExecutionRequestDto taToolsGroupId(UUID taToolsGroupId) {
    this.taToolsGroupId = taToolsGroupId;
    return this;
  }

  /**
   * Get taToolsGroupId
   * @return taToolsGroupId
  */
  @Valid 
  @Schema(name = "taToolsGroupId", required = false)
  public UUID getTaToolsGroupId() {
    return taToolsGroupId;
  }

  public void setTaToolsGroupId(UUID taToolsGroupId) {
    this.taToolsGroupId = taToolsGroupId;
  }

  public FlowExecutionRequestDto testPlanId(UUID testPlanId) {
    this.testPlanId = testPlanId;
    return this;
  }

  /**
   * Get testPlanId
   * @return testPlanId
  */
  @NotNull @Valid 
  @Schema(name = "testPlanId", required = true)
  public UUID getTestPlanId() {
    return testPlanId;
  }

  public void setTestPlanId(UUID testPlanId) {
    this.testPlanId = testPlanId;
  }

  public FlowExecutionRequestDto testPlanName(String testPlanName) {
    this.testPlanName = testPlanName;
    return this;
  }

  /**
   * Get testPlanName
   * @return testPlanName
  */
  @NotNull 
  @Schema(name = "testPlanName", required = true)
  public String getTestPlanName() {
    return testPlanName;
  }

  public void setTestPlanName(String testPlanName) {
    this.testPlanName = testPlanName;
  }

  public FlowExecutionRequestDto testRunId(UUID testRunId) {
    this.testRunId = testRunId;
    return this;
  }

  /**
   * Get testRunId
   * @return testRunId
  */
  @Valid 
  @Schema(name = "testRunId", required = false)
  public UUID getTestRunId() {
    return testRunId;
  }

  public void setTestRunId(UUID testRunId) {
    this.testRunId = testRunId;
  }

  public FlowExecutionRequestDto testRunName(String testRunName) {
    this.testRunName = testRunName;
    return this;
  }

  /**
   * Get testRunName
   * @return testRunName
  */
  @NotNull 
  @Schema(name = "testRunName", required = true)
  public String getTestRunName() {
    return testRunName;
  }

  public void setTestRunName(String testRunName) {
    this.testRunName = testRunName;
  }

  public FlowExecutionRequestDto testSuiteName(String testSuiteName) {
    this.testSuiteName = testSuiteName;
    return this;
  }

  /**
   * Get testSuiteName
   * @return testSuiteName
  */
  @NotNull 
  @Schema(name = "testSuiteName", required = true)
  public String getTestSuiteName() {
    return testSuiteName;
  }

  public void setTestSuiteName(String testSuiteName) {
    this.testSuiteName = testSuiteName;
  }

  public FlowExecutionRequestDto threadCount(Integer threadCount) {
    this.threadCount = threadCount;
    return this;
  }

  /**
   * Get threadCount
   * @return threadCount
  */
  
  @Schema(name = "threadCount", required = false)
  public Integer getThreadCount() {
    return threadCount;
  }

  public void setThreadCount(Integer threadCount) {
    this.threadCount = threadCount;
  }

  public FlowExecutionRequestDto toolsInfo(Map<String, String> toolsInfo) {
    this.toolsInfo = toolsInfo;
    return this;
  }

  public FlowExecutionRequestDto putToolsInfoItem(String key, String toolsInfoItem) {
    if (this.toolsInfo == null) {
      this.toolsInfo = new HashMap<>();
    }
    this.toolsInfo.put(key, toolsInfoItem);
    return this;
  }

  /**
   * Get toolsInfo
   * @return toolsInfo
  */
  
  @Schema(name = "toolsInfo", required = false)
  public Map<String, String> getToolsInfo() {
    return toolsInfo;
  }

  public void setToolsInfo(Map<String, String> toolsInfo) {
    this.toolsInfo = toolsInfo;
  }

  public FlowExecutionRequestDto widgetConfigTemplateId(UUID widgetConfigTemplateId) {
    this.widgetConfigTemplateId = widgetConfigTemplateId;
    return this;
  }

  /**
   * Get widgetConfigTemplateId
   * @return widgetConfigTemplateId
  */
  @Valid 
  @Schema(name = "widgetConfigTemplateId", required = false)
  public UUID getWidgetConfigTemplateId() {
    return widgetConfigTemplateId;
  }

  public void setWidgetConfigTemplateId(UUID widgetConfigTemplateId) {
    this.widgetConfigTemplateId = widgetConfigTemplateId;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    FlowExecutionRequestDto flowExecutionRequest = (FlowExecutionRequestDto) o;
    return Objects.equals(this.autoSyncCasesWithJira, flowExecutionRequest.autoSyncCasesWithJira) &&
        Objects.equals(this.autoSyncRunsWithJira, flowExecutionRequest.autoSyncRunsWithJira) &&
        Objects.equals(this.contextVariables, flowExecutionRequest.contextVariables) &&
        Objects.equals(this.dataSetId, flowExecutionRequest.dataSetId) &&
        Objects.equals(this.dataSetStorageId, flowExecutionRequest.dataSetStorageId) &&
        Objects.equals(this.emailSubject, flowExecutionRequest.emailSubject) &&
        Objects.equals(this.emailTemplateId, flowExecutionRequest.emailTemplateId) &&
        Objects.equals(this.emails, flowExecutionRequest.emails) &&
        Objects.equals(this.engine, flowExecutionRequest.engine) &&
        Objects.equals(this.environmentId, flowExecutionRequest.environmentId) &&
        Objects.equals(this.executionRequestId, flowExecutionRequest.executionRequestId) &&
        Objects.equals(this.executionRequestName, flowExecutionRequest.executionRequestName) &&
        Objects.equals(this.executor, flowExecutionRequest.executor) &&
        Objects.equals(this.executorId, flowExecutionRequest.executorId) &&
        Objects.equals(this.itfTestRunId, flowExecutionRequest.itfTestRunId) &&
        Objects.equals(this.labelTemplateId, flowExecutionRequest.labelTemplateId) &&
        Objects.equals(this.projectId, flowExecutionRequest.projectId) &&
        Objects.equals(this.projectName, flowExecutionRequest.projectName) &&
        Objects.equals(this.scope, flowExecutionRequest.scope) &&
        Objects.equals(this.systems, flowExecutionRequest.systems) &&
        Objects.equals(this.taSystems, flowExecutionRequest.taSystems) &&
        Objects.equals(this.taToolsGroupId, flowExecutionRequest.taToolsGroupId) &&
        Objects.equals(this.testPlanId, flowExecutionRequest.testPlanId) &&
        Objects.equals(this.testPlanName, flowExecutionRequest.testPlanName) &&
        Objects.equals(this.testRunId, flowExecutionRequest.testRunId) &&
        Objects.equals(this.testRunName, flowExecutionRequest.testRunName) &&
        Objects.equals(this.testSuiteName, flowExecutionRequest.testSuiteName) &&
        Objects.equals(this.threadCount, flowExecutionRequest.threadCount) &&
        Objects.equals(this.toolsInfo, flowExecutionRequest.toolsInfo) &&
        Objects.equals(this.widgetConfigTemplateId, flowExecutionRequest.widgetConfigTemplateId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(autoSyncCasesWithJira, autoSyncRunsWithJira, contextVariables, dataSetId, dataSetStorageId, emailSubject, emailTemplateId, emails, engine, environmentId, executionRequestId, executionRequestName, executor, executorId, itfTestRunId, labelTemplateId, projectId, projectName, scope, systems, taSystems, taToolsGroupId, testPlanId, testPlanName, testRunId, testRunName, testSuiteName, threadCount, toolsInfo, widgetConfigTemplateId);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class FlowExecutionRequestDto {\n");
    sb.append("    autoSyncCasesWithJira: ").append(toIndentedString(autoSyncCasesWithJira)).append("\n");
    sb.append("    autoSyncRunsWithJira: ").append(toIndentedString(autoSyncRunsWithJira)).append("\n");
    sb.append("    contextVariables: ").append(toIndentedString(contextVariables)).append("\n");
    sb.append("    dataSetId: ").append(toIndentedString(dataSetId)).append("\n");
    sb.append("    dataSetStorageId: ").append(toIndentedString(dataSetStorageId)).append("\n");
    sb.append("    emailSubject: ").append(toIndentedString(emailSubject)).append("\n");
    sb.append("    emailTemplateId: ").append(toIndentedString(emailTemplateId)).append("\n");
    sb.append("    emails: ").append(toIndentedString(emails)).append("\n");
    sb.append("    engine: ").append(toIndentedString(engine)).append("\n");
    sb.append("    environmentId: ").append(toIndentedString(environmentId)).append("\n");
    sb.append("    executionRequestId: ").append(toIndentedString(executionRequestId)).append("\n");
    sb.append("    executionRequestName: ").append(toIndentedString(executionRequestName)).append("\n");
    sb.append("    executor: ").append(toIndentedString(executor)).append("\n");
    sb.append("    executorId: ").append(toIndentedString(executorId)).append("\n");
    sb.append("    itfTestRunId: ").append(toIndentedString(itfTestRunId)).append("\n");
    sb.append("    labelTemplateId: ").append(toIndentedString(labelTemplateId)).append("\n");
    sb.append("    projectId: ").append(toIndentedString(projectId)).append("\n");
    sb.append("    projectName: ").append(toIndentedString(projectName)).append("\n");
    sb.append("    scope: ").append(toIndentedString(scope)).append("\n");
    sb.append("    systems: ").append(toIndentedString(systems)).append("\n");
    sb.append("    taSystems: ").append(toIndentedString(taSystems)).append("\n");
    sb.append("    taToolsGroupId: ").append(toIndentedString(taToolsGroupId)).append("\n");
    sb.append("    testPlanId: ").append(toIndentedString(testPlanId)).append("\n");
    sb.append("    testPlanName: ").append(toIndentedString(testPlanName)).append("\n");
    sb.append("    testRunId: ").append(toIndentedString(testRunId)).append("\n");
    sb.append("    testRunName: ").append(toIndentedString(testRunName)).append("\n");
    sb.append("    testSuiteName: ").append(toIndentedString(testSuiteName)).append("\n");
    sb.append("    threadCount: ").append(toIndentedString(threadCount)).append("\n");
    sb.append("    toolsInfo: ").append(toIndentedString(toolsInfo)).append("\n");
    sb.append("    widgetConfigTemplateId: ").append(toIndentedString(widgetConfigTemplateId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

