package org.qubership.atp.orchestrator.clients.dto;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * RerunExecutionRequestDto
 */

@JsonTypeName("RerunExecutionRequest")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2025-07-10T07:28:19.016501341Z[Etc/UTC]")
public class RerunExecutionRequestDto {

  @JsonProperty("emailRecipients")
  @Valid
  private List<String> emailRecipients = null;

  @JsonProperty("environmentId")
  private UUID environmentId;

  @JsonProperty("executionRequestId")
  private UUID executionRequestId;

  @JsonProperty("scopeId")
  private UUID scopeId;

  @JsonProperty("taToolsGroupId")
  private UUID taToolsGroupId;

  @JsonProperty("testRunIds")
  @Valid
  private List<UUID> testRunIds = null;

  @JsonProperty("threads")
  private Integer threads;

  public RerunExecutionRequestDto emailRecipients(List<String> emailRecipients) {
    this.emailRecipients = emailRecipients;
    return this;
  }

  public RerunExecutionRequestDto addEmailRecipientsItem(String emailRecipientsItem) {
    if (this.emailRecipients == null) {
      this.emailRecipients = new ArrayList<>();
    }
    this.emailRecipients.add(emailRecipientsItem);
    return this;
  }

  /**
   * Get emailRecipients
   * @return emailRecipients
  */
  
  @Schema(name = "emailRecipients", required = false)
  public List<String> getEmailRecipients() {
    return emailRecipients;
  }

  public void setEmailRecipients(List<String> emailRecipients) {
    this.emailRecipients = emailRecipients;
  }

  public RerunExecutionRequestDto environmentId(UUID environmentId) {
    this.environmentId = environmentId;
    return this;
  }

  /**
   * Get environmentId
   * @return environmentId
  */
  @Valid 
  @Schema(name = "environmentId", required = false)
  public UUID getEnvironmentId() {
    return environmentId;
  }

  public void setEnvironmentId(UUID environmentId) {
    this.environmentId = environmentId;
  }

  public RerunExecutionRequestDto executionRequestId(UUID executionRequestId) {
    this.executionRequestId = executionRequestId;
    return this;
  }

  /**
   * Get executionRequestId
   * @return executionRequestId
  */
  @Valid 
  @Schema(name = "executionRequestId", required = false)
  public UUID getExecutionRequestId() {
    return executionRequestId;
  }

  public void setExecutionRequestId(UUID executionRequestId) {
    this.executionRequestId = executionRequestId;
  }

  public RerunExecutionRequestDto scopeId(UUID scopeId) {
    this.scopeId = scopeId;
    return this;
  }

  /**
   * Get scopeId
   * @return scopeId
  */
  @Valid 
  @Schema(name = "scopeId", required = false)
  public UUID getScopeId() {
    return scopeId;
  }

  public void setScopeId(UUID scopeId) {
    this.scopeId = scopeId;
  }

  public RerunExecutionRequestDto taToolsGroupId(UUID taToolsGroupId) {
    this.taToolsGroupId = taToolsGroupId;
    return this;
  }

  /**
   * Get taToolsGroupId
   * @return taToolsGroupId
  */
  @Valid 
  @Schema(name = "taToolsGroupId", required = false)
  public UUID getTaToolsGroupId() {
    return taToolsGroupId;
  }

  public void setTaToolsGroupId(UUID taToolsGroupId) {
    this.taToolsGroupId = taToolsGroupId;
  }

  public RerunExecutionRequestDto testRunIds(List<UUID> testRunIds) {
    this.testRunIds = testRunIds;
    return this;
  }

  public RerunExecutionRequestDto addTestRunIdsItem(UUID testRunIdsItem) {
    if (this.testRunIds == null) {
      this.testRunIds = new ArrayList<>();
    }
    this.testRunIds.add(testRunIdsItem);
    return this;
  }

  /**
   * Get testRunIds
   * @return testRunIds
  */
  @Valid 
  @Schema(name = "testRunIds", required = false)
  public List<UUID> getTestRunIds() {
    return testRunIds;
  }

  public void setTestRunIds(List<UUID> testRunIds) {
    this.testRunIds = testRunIds;
  }

  public RerunExecutionRequestDto threads(Integer threads) {
    this.threads = threads;
    return this;
  }

  /**
   * Get threads
   * @return threads
  */
  
  @Schema(name = "threads", required = false)
  public Integer getThreads() {
    return threads;
  }

  public void setThreads(Integer threads) {
    this.threads = threads;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    RerunExecutionRequestDto rerunExecutionRequest = (RerunExecutionRequestDto) o;
    return Objects.equals(this.emailRecipients, rerunExecutionRequest.emailRecipients) &&
        Objects.equals(this.environmentId, rerunExecutionRequest.environmentId) &&
        Objects.equals(this.executionRequestId, rerunExecutionRequest.executionRequestId) &&
        Objects.equals(this.scopeId, rerunExecutionRequest.scopeId) &&
        Objects.equals(this.taToolsGroupId, rerunExecutionRequest.taToolsGroupId) &&
        Objects.equals(this.testRunIds, rerunExecutionRequest.testRunIds) &&
        Objects.equals(this.threads, rerunExecutionRequest.threads);
  }

  @Override
  public int hashCode() {
    return Objects.hash(emailRecipients, environmentId, executionRequestId, scopeId, taToolsGroupId, testRunIds, threads);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class RerunExecutionRequestDto {\n");
    sb.append("    emailRecipients: ").append(toIndentedString(emailRecipients)).append("\n");
    sb.append("    environmentId: ").append(toIndentedString(environmentId)).append("\n");
    sb.append("    executionRequestId: ").append(toIndentedString(executionRequestId)).append("\n");
    sb.append("    scopeId: ").append(toIndentedString(scopeId)).append("\n");
    sb.append("    taToolsGroupId: ").append(toIndentedString(taToolsGroupId)).append("\n");
    sb.append("    testRunIds: ").append(toIndentedString(testRunIds)).append("\n");
    sb.append("    threads: ").append(toIndentedString(threads)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

