package org.qubership.atp.orchestrator.clients.dto;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * TerminateRequestDto
 */

@JsonTypeName("TerminateRequest")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2025-07-10T07:28:19.016501341Z[Etc/UTC]")
public class TerminateRequestDto {

  @JsonProperty("executionRequestIds")
  @Valid
  private List<UUID> executionRequestIds = null;

  @JsonProperty("isGracefully")
  private Boolean isGracefully;

  public TerminateRequestDto executionRequestIds(List<UUID> executionRequestIds) {
    this.executionRequestIds = executionRequestIds;
    return this;
  }

  public TerminateRequestDto addExecutionRequestIdsItem(UUID executionRequestIdsItem) {
    if (this.executionRequestIds == null) {
      this.executionRequestIds = new ArrayList<>();
    }
    this.executionRequestIds.add(executionRequestIdsItem);
    return this;
  }

  /**
   * Get executionRequestIds
   * @return executionRequestIds
  */
  @Valid 
  @Schema(name = "executionRequestIds", required = false)
  public List<UUID> getExecutionRequestIds() {
    return executionRequestIds;
  }

  public void setExecutionRequestIds(List<UUID> executionRequestIds) {
    this.executionRequestIds = executionRequestIds;
  }

  public TerminateRequestDto isGracefully(Boolean isGracefully) {
    this.isGracefully = isGracefully;
    return this;
  }

  /**
   * Get isGracefully
   * @return isGracefully
  */
  
  @Schema(name = "isGracefully", required = false)
  public Boolean getIsGracefully() {
    return isGracefully;
  }

  public void setIsGracefully(Boolean isGracefully) {
    this.isGracefully = isGracefully;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TerminateRequestDto terminateRequest = (TerminateRequestDto) o;
    return Objects.equals(this.executionRequestIds, terminateRequest.executionRequestIds) &&
        Objects.equals(this.isGracefully, terminateRequest.isGracefully);
  }

  @Override
  public int hashCode() {
    return Objects.hash(executionRequestIds, isGracefully);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TerminateRequestDto {\n");
    sb.append("    executionRequestIds: ").append(toIndentedString(executionRequestIds)).append("\n");
    sb.append("    isGracefully: ").append(toIndentedString(isGracefully)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

