package org.qubership.atp.ram.clients.api.dto.catalogue;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.qubership.atp.ram.clients.api.dto.catalogue.ActionParameterDto;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * ActionDto
 */

@JsonTypeName("Action")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2025-07-10T07:28:18.054037499Z[Etc/UTC]")
public class ActionDto {

  @JsonProperty("annotations")
  @Valid
  private List<String> annotations = null;

  @JsonProperty("comment")
  private String comment;

  @JsonProperty("commentedOut")
  private Boolean commentedOut;

  @JsonProperty("deprecated")
  private Boolean deprecated;

  @JsonProperty("description")
  private String description;

  /**
   * Gets or Sets engineType
   */
  public enum EngineTypeEnum {
    BV("BV"),
    
    EXECUTOR("EXECUTOR"),
    
    ITFACTION("ITFACTION"),
    
    ITFCALLCHAIN("ITFCALLCHAIN"),
    
    ITFWARMUP("ITFWARMUP"),
    
    NEWMAN_RUNNER("NEWMAN_RUNNER");

    private String value;

    EngineTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static EngineTypeEnum fromValue(String value) {
      for (EngineTypeEnum b : EngineTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  @JsonProperty("engineType")
  private EngineTypeEnum engineType;

  @JsonProperty("name")
  private String name;

  @JsonProperty("parameters")
  @Valid
  private List<ActionParameterDto> parameters = null;

  @JsonProperty("projectUuid")
  private UUID projectUuid;

  /**
   * Gets or Sets type
   */
  public enum TypeEnum {
    BV("BV"),
    
    COMPOUND("COMPOUND"),
    
    ITF("ITF"),
    
    MIA("MIA"),
    
    NEWMAN("NEWMAN"),
    
    R_B_M("R_B_M"),
    
    REST("REST"),
    
    SQL("SQL"),
    
    SSH("SSH"),
    
    TECHNICAL("TECHNICAL"),
    
    UI("UI");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  @JsonProperty("type")
  private TypeEnum type;

  @JsonProperty("typeAction")
  private String typeAction;

  @JsonProperty("uuid")
  private UUID uuid;

  public ActionDto annotations(List<String> annotations) {
    this.annotations = annotations;
    return this;
  }

  public ActionDto addAnnotationsItem(String annotationsItem) {
    if (this.annotations == null) {
      this.annotations = new ArrayList<>();
    }
    this.annotations.add(annotationsItem);
    return this;
  }

  /**
   * Get annotations
   * @return annotations
  */
  
  @Schema(name = "annotations", required = false)
  public List<String> getAnnotations() {
    return annotations;
  }

  public void setAnnotations(List<String> annotations) {
    this.annotations = annotations;
  }

  public ActionDto comment(String comment) {
    this.comment = comment;
    return this;
  }

  /**
   * Get comment
   * @return comment
  */
  
  @Schema(name = "comment", required = false)
  public String getComment() {
    return comment;
  }

  public void setComment(String comment) {
    this.comment = comment;
  }

  public ActionDto commentedOut(Boolean commentedOut) {
    this.commentedOut = commentedOut;
    return this;
  }

  /**
   * Get commentedOut
   * @return commentedOut
  */
  
  @Schema(name = "commentedOut", required = false)
  public Boolean getCommentedOut() {
    return commentedOut;
  }

  public void setCommentedOut(Boolean commentedOut) {
    this.commentedOut = commentedOut;
  }

  public ActionDto deprecated(Boolean deprecated) {
    this.deprecated = deprecated;
    return this;
  }

  /**
   * Get deprecated
   * @return deprecated
  */
  
  @Schema(name = "deprecated", required = false)
  public Boolean getDeprecated() {
    return deprecated;
  }

  public void setDeprecated(Boolean deprecated) {
    this.deprecated = deprecated;
  }

  public ActionDto description(String description) {
    this.description = description;
    return this;
  }

  /**
   * Get description
   * @return description
  */
  
  @Schema(name = "description", required = false)
  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  public ActionDto engineType(EngineTypeEnum engineType) {
    this.engineType = engineType;
    return this;
  }

  /**
   * Get engineType
   * @return engineType
  */
  
  @Schema(name = "engineType", required = false)
  public EngineTypeEnum getEngineType() {
    return engineType;
  }

  public void setEngineType(EngineTypeEnum engineType) {
    this.engineType = engineType;
  }

  public ActionDto name(String name) {
    this.name = name;
    return this;
  }

  /**
   * Get name
   * @return name
  */
  
  @Schema(name = "name", required = false)
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public ActionDto parameters(List<ActionParameterDto> parameters) {
    this.parameters = parameters;
    return this;
  }

  public ActionDto addParametersItem(ActionParameterDto parametersItem) {
    if (this.parameters == null) {
      this.parameters = new ArrayList<>();
    }
    this.parameters.add(parametersItem);
    return this;
  }

  /**
   * Get parameters
   * @return parameters
  */
  @Valid 
  @Schema(name = "parameters", required = false)
  public List<ActionParameterDto> getParameters() {
    return parameters;
  }

  public void setParameters(List<ActionParameterDto> parameters) {
    this.parameters = parameters;
  }

  public ActionDto projectUuid(UUID projectUuid) {
    this.projectUuid = projectUuid;
    return this;
  }

  /**
   * Get projectUuid
   * @return projectUuid
  */
  @Valid 
  @Schema(name = "projectUuid", required = false)
  public UUID getProjectUuid() {
    return projectUuid;
  }

  public void setProjectUuid(UUID projectUuid) {
    this.projectUuid = projectUuid;
  }

  public ActionDto type(TypeEnum type) {
    this.type = type;
    return this;
  }

  /**
   * Get type
   * @return type
  */
  
  @Schema(name = "type", required = false)
  public TypeEnum getType() {
    return type;
  }

  public void setType(TypeEnum type) {
    this.type = type;
  }

  public ActionDto typeAction(String typeAction) {
    this.typeAction = typeAction;
    return this;
  }

  /**
   * Get typeAction
   * @return typeAction
  */
  
  @Schema(name = "typeAction", required = false)
  public String getTypeAction() {
    return typeAction;
  }

  public void setTypeAction(String typeAction) {
    this.typeAction = typeAction;
  }

  public ActionDto uuid(UUID uuid) {
    this.uuid = uuid;
    return this;
  }

  /**
   * Get uuid
   * @return uuid
  */
  @Valid 
  @Schema(name = "uuid", required = false)
  public UUID getUuid() {
    return uuid;
  }

  public void setUuid(UUID uuid) {
    this.uuid = uuid;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ActionDto action = (ActionDto) o;
    return Objects.equals(this.annotations, action.annotations) &&
        Objects.equals(this.comment, action.comment) &&
        Objects.equals(this.commentedOut, action.commentedOut) &&
        Objects.equals(this.deprecated, action.deprecated) &&
        Objects.equals(this.description, action.description) &&
        Objects.equals(this.engineType, action.engineType) &&
        Objects.equals(this.name, action.name) &&
        Objects.equals(this.parameters, action.parameters) &&
        Objects.equals(this.projectUuid, action.projectUuid) &&
        Objects.equals(this.type, action.type) &&
        Objects.equals(this.typeAction, action.typeAction) &&
        Objects.equals(this.uuid, action.uuid);
  }

  @Override
  public int hashCode() {
    return Objects.hash(annotations, comment, commentedOut, deprecated, description, engineType, name, parameters, projectUuid, type, typeAction, uuid);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ActionDto {\n");
    sb.append("    annotations: ").append(toIndentedString(annotations)).append("\n");
    sb.append("    comment: ").append(toIndentedString(comment)).append("\n");
    sb.append("    commentedOut: ").append(toIndentedString(commentedOut)).append("\n");
    sb.append("    deprecated: ").append(toIndentedString(deprecated)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    engineType: ").append(toIndentedString(engineType)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    parameters: ").append(toIndentedString(parameters)).append("\n");
    sb.append("    projectUuid: ").append(toIndentedString(projectUuid)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    typeAction: ").append(toIndentedString(typeAction)).append("\n");
    sb.append("    uuid: ").append(toIndentedString(uuid)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

