package org.qubership.atp.ram.clients.api.dto.catalogue;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.UUID;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * CopyRequestDto
 */

@JsonTypeName("CopyRequest")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2025-07-10T07:28:18.054037499Z[Etc/UTC]")
public class CopyRequestDto {

  @JsonProperty("items")
  @Valid
  private Set<UUID> items = new LinkedHashSet<>();

  @JsonProperty("testPlanId")
  private UUID testPlanId;

  @JsonProperty("toGroup")
  private UUID toGroup;

  public CopyRequestDto items(Set<UUID> items) {
    this.items = items;
    return this;
  }

  public CopyRequestDto addItemsItem(UUID itemsItem) {
    this.items.add(itemsItem);
    return this;
  }

  /**
   * Get items
   * @return items
  */
  @NotNull @Valid 
  @Schema(name = "items", required = true)
  public Set<UUID> getItems() {
    return items;
  }

  @JsonDeserialize(as = LinkedHashSet.class)
  public void setItems(Set<UUID> items) {
    this.items = items;
  }

  public CopyRequestDto testPlanId(UUID testPlanId) {
    this.testPlanId = testPlanId;
    return this;
  }

  /**
   * Get testPlanId
   * @return testPlanId
  */
  @NotNull @Valid 
  @Schema(name = "testPlanId", required = true)
  public UUID getTestPlanId() {
    return testPlanId;
  }

  public void setTestPlanId(UUID testPlanId) {
    this.testPlanId = testPlanId;
  }

  public CopyRequestDto toGroup(UUID toGroup) {
    this.toGroup = toGroup;
    return this;
  }

  /**
   * Get toGroup
   * @return toGroup
  */
  @Valid 
  @Schema(name = "toGroup", required = false)
  public UUID getToGroup() {
    return toGroup;
  }

  public void setToGroup(UUID toGroup) {
    this.toGroup = toGroup;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CopyRequestDto copyRequest = (CopyRequestDto) o;
    return Objects.equals(this.items, copyRequest.items) &&
        Objects.equals(this.testPlanId, copyRequest.testPlanId) &&
        Objects.equals(this.toGroup, copyRequest.toGroup);
  }

  @Override
  public int hashCode() {
    return Objects.hash(items, testPlanId, toGroup);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CopyRequestDto {\n");
    sb.append("    items: ").append(toIndentedString(items)).append("\n");
    sb.append("    testPlanId: ").append(toIndentedString(testPlanId)).append("\n");
    sb.append("    toGroup: ").append(toIndentedString(toGroup)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

