package org.qubership.atp.ram.clients.api.dto.catalogue;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.qubership.atp.ram.clients.api.dto.catalogue.EnrichedCompoundDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.ProjectDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.TestPlanDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.TestScenarioGroupDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.UserModelDto;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * EnrichedTestScenarioDto
 */

@JsonTypeName("EnrichedTestScenario")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2025-07-10T07:28:18.054037499Z[Etc/UTC]")
public class EnrichedTestScenarioDto {

  @JsonProperty("compounds")
  @Valid
  private List<EnrichedCompoundDto> compounds = null;

  @JsonProperty("description")
  private String description;

  @JsonProperty("group")
  private TestScenarioGroupDto group;

  @JsonProperty("lastEdit")
  private Long lastEdit;

  @JsonProperty("lastModifiedBy")
  private UserModelDto lastModifiedBy;

  @JsonProperty("lastModifyDate")
  private Long lastModifyDate;

  @JsonProperty("name")
  private String name;

  @JsonProperty("project")
  private ProjectDto project;

  @JsonProperty("testPlan")
  private TestPlanDto testPlan;

  @JsonProperty("uuid")
  private UUID uuid;

  public EnrichedTestScenarioDto compounds(List<EnrichedCompoundDto> compounds) {
    this.compounds = compounds;
    return this;
  }

  public EnrichedTestScenarioDto addCompoundsItem(EnrichedCompoundDto compoundsItem) {
    if (this.compounds == null) {
      this.compounds = new ArrayList<>();
    }
    this.compounds.add(compoundsItem);
    return this;
  }

  /**
   * Get compounds
   * @return compounds
  */
  @Valid 
  @Schema(name = "compounds", required = false)
  public List<EnrichedCompoundDto> getCompounds() {
    return compounds;
  }

  public void setCompounds(List<EnrichedCompoundDto> compounds) {
    this.compounds = compounds;
  }

  public EnrichedTestScenarioDto description(String description) {
    this.description = description;
    return this;
  }

  /**
   * Get description
   * @return description
  */
  
  @Schema(name = "description", required = false)
  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  public EnrichedTestScenarioDto group(TestScenarioGroupDto group) {
    this.group = group;
    return this;
  }

  /**
   * Get group
   * @return group
  */
  @Valid 
  @Schema(name = "group", required = false)
  public TestScenarioGroupDto getGroup() {
    return group;
  }

  public void setGroup(TestScenarioGroupDto group) {
    this.group = group;
  }

  public EnrichedTestScenarioDto lastEdit(Long lastEdit) {
    this.lastEdit = lastEdit;
    return this;
  }

  /**
   * Get lastEdit
   * @return lastEdit
  */
  
  @Schema(name = "lastEdit", required = false)
  public Long getLastEdit() {
    return lastEdit;
  }

  public void setLastEdit(Long lastEdit) {
    this.lastEdit = lastEdit;
  }

  public EnrichedTestScenarioDto lastModifiedBy(UserModelDto lastModifiedBy) {
    this.lastModifiedBy = lastModifiedBy;
    return this;
  }

  /**
   * Get lastModifiedBy
   * @return lastModifiedBy
  */
  @Valid 
  @Schema(name = "lastModifiedBy", required = false)
  public UserModelDto getLastModifiedBy() {
    return lastModifiedBy;
  }

  public void setLastModifiedBy(UserModelDto lastModifiedBy) {
    this.lastModifiedBy = lastModifiedBy;
  }

  public EnrichedTestScenarioDto lastModifyDate(Long lastModifyDate) {
    this.lastModifyDate = lastModifyDate;
    return this;
  }

  /**
   * Get lastModifyDate
   * @return lastModifyDate
  */
  
  @Schema(name = "lastModifyDate", required = false)
  public Long getLastModifyDate() {
    return lastModifyDate;
  }

  public void setLastModifyDate(Long lastModifyDate) {
    this.lastModifyDate = lastModifyDate;
  }

  public EnrichedTestScenarioDto name(String name) {
    this.name = name;
    return this;
  }

  /**
   * Get name
   * @return name
  */
  
  @Schema(name = "name", required = false)
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public EnrichedTestScenarioDto project(ProjectDto project) {
    this.project = project;
    return this;
  }

  /**
   * Get project
   * @return project
  */
  @Valid 
  @Schema(name = "project", required = false)
  public ProjectDto getProject() {
    return project;
  }

  public void setProject(ProjectDto project) {
    this.project = project;
  }

  public EnrichedTestScenarioDto testPlan(TestPlanDto testPlan) {
    this.testPlan = testPlan;
    return this;
  }

  /**
   * Get testPlan
   * @return testPlan
  */
  @Valid 
  @Schema(name = "testPlan", required = false)
  public TestPlanDto getTestPlan() {
    return testPlan;
  }

  public void setTestPlan(TestPlanDto testPlan) {
    this.testPlan = testPlan;
  }

  public EnrichedTestScenarioDto uuid(UUID uuid) {
    this.uuid = uuid;
    return this;
  }

  /**
   * Get uuid
   * @return uuid
  */
  @Valid 
  @Schema(name = "uuid", required = false)
  public UUID getUuid() {
    return uuid;
  }

  public void setUuid(UUID uuid) {
    this.uuid = uuid;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    EnrichedTestScenarioDto enrichedTestScenario = (EnrichedTestScenarioDto) o;
    return Objects.equals(this.compounds, enrichedTestScenario.compounds) &&
        Objects.equals(this.description, enrichedTestScenario.description) &&
        Objects.equals(this.group, enrichedTestScenario.group) &&
        Objects.equals(this.lastEdit, enrichedTestScenario.lastEdit) &&
        Objects.equals(this.lastModifiedBy, enrichedTestScenario.lastModifiedBy) &&
        Objects.equals(this.lastModifyDate, enrichedTestScenario.lastModifyDate) &&
        Objects.equals(this.name, enrichedTestScenario.name) &&
        Objects.equals(this.project, enrichedTestScenario.project) &&
        Objects.equals(this.testPlan, enrichedTestScenario.testPlan) &&
        Objects.equals(this.uuid, enrichedTestScenario.uuid);
  }

  @Override
  public int hashCode() {
    return Objects.hash(compounds, description, group, lastEdit, lastModifiedBy, lastModifyDate, name, project, testPlan, uuid);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class EnrichedTestScenarioDto {\n");
    sb.append("    compounds: ").append(toIndentedString(compounds)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    group: ").append(toIndentedString(group)).append("\n");
    sb.append("    lastEdit: ").append(toIndentedString(lastEdit)).append("\n");
    sb.append("    lastModifiedBy: ").append(toIndentedString(lastModifiedBy)).append("\n");
    sb.append("    lastModifyDate: ").append(toIndentedString(lastModifyDate)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    project: ").append(toIndentedString(project)).append("\n");
    sb.append("    testPlan: ").append(toIndentedString(testPlan)).append("\n");
    sb.append("    uuid: ").append(toIndentedString(uuid)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

