package org.qubership.atp.ram.clients.api.dto.catalogue;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.ArrayList;
import java.util.List;
import org.qubership.atp.ram.clients.api.dto.catalogue.FieldsFoundInDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.FieldsIssueTypeDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.FieldsParentDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.FieldsPriorityDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.FieldsProjectDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.FieldsStatusDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.JiraComponentDto;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * FieldsDto
 */

@JsonTypeName("Fields")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2025-07-10T07:28:15.616771633Z[Etc/UTC]")
public class FieldsDto {

  @JsonProperty("summary")
  private String summary;

  @JsonProperty("description")
  private String description;

  @JsonProperty("environment")
  private String environment;

  @JsonProperty("project")
  private FieldsProjectDto project;

  @JsonProperty("priority")
  private FieldsPriorityDto priority;

  @JsonProperty("labels")
  @Valid
  private List<String> labels = null;

  @JsonProperty("issuetype")
  private FieldsIssueTypeDto issuetype;

  @JsonProperty("components")
  @Valid
  private List<JiraComponentDto> components = null;

  @JsonProperty("customfield_17400")
  private String customfield17400;

  @JsonProperty("customfield_27320")
  private String customfield27320;

  @JsonProperty("customfield_10014")
  private FieldsFoundInDto customfield10014;

  @JsonProperty("status")
  private FieldsStatusDto status;

  @JsonProperty("parent")
  private FieldsParentDto parent;

  public FieldsDto summary(String summary) {
    this.summary = summary;
    return this;
  }

  /**
   * Get summary
   * @return summary
  */
  
  @Schema(name = "summary", required = false)
  public String getSummary() {
    return summary;
  }

  public void setSummary(String summary) {
    this.summary = summary;
  }

  public FieldsDto description(String description) {
    this.description = description;
    return this;
  }

  /**
   * Get description
   * @return description
  */
  
  @Schema(name = "description", required = false)
  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  public FieldsDto environment(String environment) {
    this.environment = environment;
    return this;
  }

  /**
   * Get environment
   * @return environment
  */
  
  @Schema(name = "environment", required = false)
  public String getEnvironment() {
    return environment;
  }

  public void setEnvironment(String environment) {
    this.environment = environment;
  }

  public FieldsDto project(FieldsProjectDto project) {
    this.project = project;
    return this;
  }

  /**
   * Get project
   * @return project
  */
  @Valid 
  @Schema(name = "project", required = false)
  public FieldsProjectDto getProject() {
    return project;
  }

  public void setProject(FieldsProjectDto project) {
    this.project = project;
  }

  public FieldsDto priority(FieldsPriorityDto priority) {
    this.priority = priority;
    return this;
  }

  /**
   * Get priority
   * @return priority
  */
  @Valid 
  @Schema(name = "priority", required = false)
  public FieldsPriorityDto getPriority() {
    return priority;
  }

  public void setPriority(FieldsPriorityDto priority) {
    this.priority = priority;
  }

  public FieldsDto labels(List<String> labels) {
    this.labels = labels;
    return this;
  }

  public FieldsDto addLabelsItem(String labelsItem) {
    if (this.labels == null) {
      this.labels = new ArrayList<>();
    }
    this.labels.add(labelsItem);
    return this;
  }

  /**
   * Get labels
   * @return labels
  */
  
  @Schema(name = "labels", required = false)
  public List<String> getLabels() {
    return labels;
  }

  public void setLabels(List<String> labels) {
    this.labels = labels;
  }

  public FieldsDto issuetype(FieldsIssueTypeDto issuetype) {
    this.issuetype = issuetype;
    return this;
  }

  /**
   * Get issuetype
   * @return issuetype
  */
  @Valid 
  @Schema(name = "issuetype", required = false)
  public FieldsIssueTypeDto getIssuetype() {
    return issuetype;
  }

  public void setIssuetype(FieldsIssueTypeDto issuetype) {
    this.issuetype = issuetype;
  }

  public FieldsDto components(List<JiraComponentDto> components) {
    this.components = components;
    return this;
  }

  public FieldsDto addComponentsItem(JiraComponentDto componentsItem) {
    if (this.components == null) {
      this.components = new ArrayList<>();
    }
    this.components.add(componentsItem);
    return this;
  }

  /**
   * Get components
   * @return components
  */
  @Valid 
  @Schema(name = "components", required = false)
  public List<JiraComponentDto> getComponents() {
    return components;
  }

  public void setComponents(List<JiraComponentDto> components) {
    this.components = components;
  }

  public FieldsDto customfield17400(String customfield17400) {
    this.customfield17400 = customfield17400;
    return this;
  }

  /**
   * Get customfield17400
   * @return customfield17400
  */
  
  @Schema(name = "customfield_17400", required = false)
  public String getCustomfield17400() {
    return customfield17400;
  }

  public void setCustomfield17400(String customfield17400) {
    this.customfield17400 = customfield17400;
  }

  public FieldsDto customfield27320(String customfield27320) {
    this.customfield27320 = customfield27320;
    return this;
  }

  /**
   * Get customfield27320
   * @return customfield27320
  */
  
  @Schema(name = "customfield_27320", required = false)
  public String getCustomfield27320() {
    return customfield27320;
  }

  public void setCustomfield27320(String customfield27320) {
    this.customfield27320 = customfield27320;
  }

  public FieldsDto customfield10014(FieldsFoundInDto customfield10014) {
    this.customfield10014 = customfield10014;
    return this;
  }

  /**
   * Get customfield10014
   * @return customfield10014
  */
  @Valid 
  @Schema(name = "customfield_10014", required = false)
  public FieldsFoundInDto getCustomfield10014() {
    return customfield10014;
  }

  public void setCustomfield10014(FieldsFoundInDto customfield10014) {
    this.customfield10014 = customfield10014;
  }

  public FieldsDto status(FieldsStatusDto status) {
    this.status = status;
    return this;
  }

  /**
   * Get status
   * @return status
  */
  @Valid 
  @Schema(name = "status", required = false)
  public FieldsStatusDto getStatus() {
    return status;
  }

  public void setStatus(FieldsStatusDto status) {
    this.status = status;
  }

  public FieldsDto parent(FieldsParentDto parent) {
    this.parent = parent;
    return this;
  }

  /**
   * Get parent
   * @return parent
  */
  @Valid 
  @Schema(name = "parent", required = false)
  public FieldsParentDto getParent() {
    return parent;
  }

  public void setParent(FieldsParentDto parent) {
    this.parent = parent;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    FieldsDto fields = (FieldsDto) o;
    return Objects.equals(this.summary, fields.summary) &&
        Objects.equals(this.description, fields.description) &&
        Objects.equals(this.environment, fields.environment) &&
        Objects.equals(this.project, fields.project) &&
        Objects.equals(this.priority, fields.priority) &&
        Objects.equals(this.labels, fields.labels) &&
        Objects.equals(this.issuetype, fields.issuetype) &&
        Objects.equals(this.components, fields.components) &&
        Objects.equals(this.customfield17400, fields.customfield17400) &&
        Objects.equals(this.customfield27320, fields.customfield27320) &&
        Objects.equals(this.customfield10014, fields.customfield10014) &&
        Objects.equals(this.status, fields.status) &&
        Objects.equals(this.parent, fields.parent);
  }

  @Override
  public int hashCode() {
    return Objects.hash(summary, description, environment, project, priority, labels, issuetype, components, customfield17400, customfield27320, customfield10014, status, parent);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class FieldsDto {\n");
    sb.append("    summary: ").append(toIndentedString(summary)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    environment: ").append(toIndentedString(environment)).append("\n");
    sb.append("    project: ").append(toIndentedString(project)).append("\n");
    sb.append("    priority: ").append(toIndentedString(priority)).append("\n");
    sb.append("    labels: ").append(toIndentedString(labels)).append("\n");
    sb.append("    issuetype: ").append(toIndentedString(issuetype)).append("\n");
    sb.append("    components: ").append(toIndentedString(components)).append("\n");
    sb.append("    customfield17400: ").append(toIndentedString(customfield17400)).append("\n");
    sb.append("    customfield27320: ").append(toIndentedString(customfield27320)).append("\n");
    sb.append("    customfield10014: ").append(toIndentedString(customfield10014)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    parent: ").append(toIndentedString(parent)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

