package org.qubership.atp.ram.clients.api.dto.catalogue;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.qubership.atp.ram.clients.api.dto.catalogue.BugTrackingSystemSynchronizationDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.ObjectOperationDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.UserInfoDto;
import org.springframework.format.annotation.DateTimeFormat;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * TestPlanDto
 */

@JsonTypeName("TestPlan")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2025-07-10T07:28:18.054037499Z[Etc/UTC]")
public class TestPlanDto {

  @JsonProperty("childrenOperations")
  @Valid
  private List<ObjectOperationDto> childrenOperations = null;

  @JsonProperty("createdBy")
  private UserInfoDto createdBy;

  @JsonProperty("createdWhen")
  @DateTimeFormat(iso = DateTimeFormat.ISO.DATE_TIME)
  private OffsetDateTime createdWhen;

  @JsonProperty("description")
  private String description;

  @JsonProperty("disableAutoSyncAtpTestCasesWithJiraTickets")
  private Boolean disableAutoSyncAtpTestCasesWithJiraTickets;

  @JsonProperty("executionRequestClosingTimeoutMin")
  private Integer executionRequestClosingTimeoutMin;

  @JsonProperty("jiraTicketsAutoClosing")
  private Boolean jiraTicketsAutoClosing;

  @JsonProperty("modifiedBy")
  private UserInfoDto modifiedBy;

  @JsonProperty("modifiedWhen")
  @DateTimeFormat(iso = DateTimeFormat.ISO.DATE_TIME)
  private OffsetDateTime modifiedWhen;

  @JsonProperty("name")
  private String name;

  @JsonProperty("notificationMessageSubjectTemplate")
  private String notificationMessageSubjectTemplate;

  @JsonProperty("projectUuid")
  private UUID projectUuid;

  @JsonProperty("qaDslLibraryId")
  private UUID qaDslLibraryId;

  @JsonProperty("synchronization")
  private BugTrackingSystemSynchronizationDto synchronization;

  @JsonProperty("taTools")
  @Valid
  private List<UUID> taTools = null;

  @JsonProperty("uuid")
  private UUID uuid;

  public TestPlanDto childrenOperations(List<ObjectOperationDto> childrenOperations) {
    this.childrenOperations = childrenOperations;
    return this;
  }

  public TestPlanDto addChildrenOperationsItem(ObjectOperationDto childrenOperationsItem) {
    if (this.childrenOperations == null) {
      this.childrenOperations = new ArrayList<>();
    }
    this.childrenOperations.add(childrenOperationsItem);
    return this;
  }

  /**
   * Get childrenOperations
   * @return childrenOperations
  */
  @Valid 
  @Schema(name = "childrenOperations", required = false)
  public List<ObjectOperationDto> getChildrenOperations() {
    return childrenOperations;
  }

  public void setChildrenOperations(List<ObjectOperationDto> childrenOperations) {
    this.childrenOperations = childrenOperations;
  }

  public TestPlanDto createdBy(UserInfoDto createdBy) {
    this.createdBy = createdBy;
    return this;
  }

  /**
   * Get createdBy
   * @return createdBy
  */
  @Valid 
  @Schema(name = "createdBy", required = false)
  public UserInfoDto getCreatedBy() {
    return createdBy;
  }

  public void setCreatedBy(UserInfoDto createdBy) {
    this.createdBy = createdBy;
  }

  public TestPlanDto createdWhen(OffsetDateTime createdWhen) {
    this.createdWhen = createdWhen;
    return this;
  }

  /**
   * Get createdWhen
   * @return createdWhen
  */
  @Valid 
  @Schema(name = "createdWhen", required = false)
  public OffsetDateTime getCreatedWhen() {
    return createdWhen;
  }

  public void setCreatedWhen(OffsetDateTime createdWhen) {
    this.createdWhen = createdWhen;
  }

  public TestPlanDto description(String description) {
    this.description = description;
    return this;
  }

  /**
   * Get description
   * @return description
  */
  
  @Schema(name = "description", required = false)
  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  public TestPlanDto disableAutoSyncAtpTestCasesWithJiraTickets(Boolean disableAutoSyncAtpTestCasesWithJiraTickets) {
    this.disableAutoSyncAtpTestCasesWithJiraTickets = disableAutoSyncAtpTestCasesWithJiraTickets;
    return this;
  }

  /**
   * Get disableAutoSyncAtpTestCasesWithJiraTickets
   * @return disableAutoSyncAtpTestCasesWithJiraTickets
  */
  
  @Schema(name = "disableAutoSyncAtpTestCasesWithJiraTickets", required = false)
  public Boolean getDisableAutoSyncAtpTestCasesWithJiraTickets() {
    return disableAutoSyncAtpTestCasesWithJiraTickets;
  }

  public void setDisableAutoSyncAtpTestCasesWithJiraTickets(Boolean disableAutoSyncAtpTestCasesWithJiraTickets) {
    this.disableAutoSyncAtpTestCasesWithJiraTickets = disableAutoSyncAtpTestCasesWithJiraTickets;
  }

  public TestPlanDto executionRequestClosingTimeoutMin(Integer executionRequestClosingTimeoutMin) {
    this.executionRequestClosingTimeoutMin = executionRequestClosingTimeoutMin;
    return this;
  }

  /**
   * Get executionRequestClosingTimeoutMin
   * @return executionRequestClosingTimeoutMin
  */
  
  @Schema(name = "executionRequestClosingTimeoutMin", required = false)
  public Integer getExecutionRequestClosingTimeoutMin() {
    return executionRequestClosingTimeoutMin;
  }

  public void setExecutionRequestClosingTimeoutMin(Integer executionRequestClosingTimeoutMin) {
    this.executionRequestClosingTimeoutMin = executionRequestClosingTimeoutMin;
  }

  public TestPlanDto jiraTicketsAutoClosing(Boolean jiraTicketsAutoClosing) {
    this.jiraTicketsAutoClosing = jiraTicketsAutoClosing;
    return this;
  }

  /**
   * Get jiraTicketsAutoClosing
   * @return jiraTicketsAutoClosing
  */
  
  @Schema(name = "jiraTicketsAutoClosing", required = false)
  public Boolean getJiraTicketsAutoClosing() {
    return jiraTicketsAutoClosing;
  }

  public void setJiraTicketsAutoClosing(Boolean jiraTicketsAutoClosing) {
    this.jiraTicketsAutoClosing = jiraTicketsAutoClosing;
  }

  public TestPlanDto modifiedBy(UserInfoDto modifiedBy) {
    this.modifiedBy = modifiedBy;
    return this;
  }

  /**
   * Get modifiedBy
   * @return modifiedBy
  */
  @Valid 
  @Schema(name = "modifiedBy", required = false)
  public UserInfoDto getModifiedBy() {
    return modifiedBy;
  }

  public void setModifiedBy(UserInfoDto modifiedBy) {
    this.modifiedBy = modifiedBy;
  }

  public TestPlanDto modifiedWhen(OffsetDateTime modifiedWhen) {
    this.modifiedWhen = modifiedWhen;
    return this;
  }

  /**
   * Get modifiedWhen
   * @return modifiedWhen
  */
  @Valid 
  @Schema(name = "modifiedWhen", required = false)
  public OffsetDateTime getModifiedWhen() {
    return modifiedWhen;
  }

  public void setModifiedWhen(OffsetDateTime modifiedWhen) {
    this.modifiedWhen = modifiedWhen;
  }

  public TestPlanDto name(String name) {
    this.name = name;
    return this;
  }

  /**
   * Get name
   * @return name
  */
  
  @Schema(name = "name", required = false)
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public TestPlanDto notificationMessageSubjectTemplate(String notificationMessageSubjectTemplate) {
    this.notificationMessageSubjectTemplate = notificationMessageSubjectTemplate;
    return this;
  }

  /**
   * Get notificationMessageSubjectTemplate
   * @return notificationMessageSubjectTemplate
  */
  
  @Schema(name = "notificationMessageSubjectTemplate", required = false)
  public String getNotificationMessageSubjectTemplate() {
    return notificationMessageSubjectTemplate;
  }

  public void setNotificationMessageSubjectTemplate(String notificationMessageSubjectTemplate) {
    this.notificationMessageSubjectTemplate = notificationMessageSubjectTemplate;
  }

  public TestPlanDto projectUuid(UUID projectUuid) {
    this.projectUuid = projectUuid;
    return this;
  }

  /**
   * Get projectUuid
   * @return projectUuid
  */
  @Valid 
  @Schema(name = "projectUuid", required = false)
  public UUID getProjectUuid() {
    return projectUuid;
  }

  public void setProjectUuid(UUID projectUuid) {
    this.projectUuid = projectUuid;
  }

  public TestPlanDto qaDslLibraryId(UUID qaDslLibraryId) {
    this.qaDslLibraryId = qaDslLibraryId;
    return this;
  }

  /**
   * Get qaDslLibraryId
   * @return qaDslLibraryId
  */
  @Valid 
  @Schema(name = "qaDslLibraryId", required = false)
  public UUID getQaDslLibraryId() {
    return qaDslLibraryId;
  }

  public void setQaDslLibraryId(UUID qaDslLibraryId) {
    this.qaDslLibraryId = qaDslLibraryId;
  }

  public TestPlanDto synchronization(BugTrackingSystemSynchronizationDto synchronization) {
    this.synchronization = synchronization;
    return this;
  }

  /**
   * Get synchronization
   * @return synchronization
  */
  @Valid 
  @Schema(name = "synchronization", required = false)
  public BugTrackingSystemSynchronizationDto getSynchronization() {
    return synchronization;
  }

  public void setSynchronization(BugTrackingSystemSynchronizationDto synchronization) {
    this.synchronization = synchronization;
  }

  public TestPlanDto taTools(List<UUID> taTools) {
    this.taTools = taTools;
    return this;
  }

  public TestPlanDto addTaToolsItem(UUID taToolsItem) {
    if (this.taTools == null) {
      this.taTools = new ArrayList<>();
    }
    this.taTools.add(taToolsItem);
    return this;
  }

  /**
   * Get taTools
   * @return taTools
  */
  @Valid 
  @Schema(name = "taTools", required = false)
  public List<UUID> getTaTools() {
    return taTools;
  }

  public void setTaTools(List<UUID> taTools) {
    this.taTools = taTools;
  }

  public TestPlanDto uuid(UUID uuid) {
    this.uuid = uuid;
    return this;
  }

  /**
   * Get uuid
   * @return uuid
  */
  @Valid 
  @Schema(name = "uuid", required = false)
  public UUID getUuid() {
    return uuid;
  }

  public void setUuid(UUID uuid) {
    this.uuid = uuid;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TestPlanDto testPlan = (TestPlanDto) o;
    return Objects.equals(this.childrenOperations, testPlan.childrenOperations) &&
        Objects.equals(this.createdBy, testPlan.createdBy) &&
        Objects.equals(this.createdWhen, testPlan.createdWhen) &&
        Objects.equals(this.description, testPlan.description) &&
        Objects.equals(this.disableAutoSyncAtpTestCasesWithJiraTickets, testPlan.disableAutoSyncAtpTestCasesWithJiraTickets) &&
        Objects.equals(this.executionRequestClosingTimeoutMin, testPlan.executionRequestClosingTimeoutMin) &&
        Objects.equals(this.jiraTicketsAutoClosing, testPlan.jiraTicketsAutoClosing) &&
        Objects.equals(this.modifiedBy, testPlan.modifiedBy) &&
        Objects.equals(this.modifiedWhen, testPlan.modifiedWhen) &&
        Objects.equals(this.name, testPlan.name) &&
        Objects.equals(this.notificationMessageSubjectTemplate, testPlan.notificationMessageSubjectTemplate) &&
        Objects.equals(this.projectUuid, testPlan.projectUuid) &&
        Objects.equals(this.qaDslLibraryId, testPlan.qaDslLibraryId) &&
        Objects.equals(this.synchronization, testPlan.synchronization) &&
        Objects.equals(this.taTools, testPlan.taTools) &&
        Objects.equals(this.uuid, testPlan.uuid);
  }

  @Override
  public int hashCode() {
    return Objects.hash(childrenOperations, createdBy, createdWhen, description, disableAutoSyncAtpTestCasesWithJiraTickets, executionRequestClosingTimeoutMin, jiraTicketsAutoClosing, modifiedBy, modifiedWhen, name, notificationMessageSubjectTemplate, projectUuid, qaDslLibraryId, synchronization, taTools, uuid);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TestPlanDto {\n");
    sb.append("    childrenOperations: ").append(toIndentedString(childrenOperations)).append("\n");
    sb.append("    createdBy: ").append(toIndentedString(createdBy)).append("\n");
    sb.append("    createdWhen: ").append(toIndentedString(createdWhen)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    disableAutoSyncAtpTestCasesWithJiraTickets: ").append(toIndentedString(disableAutoSyncAtpTestCasesWithJiraTickets)).append("\n");
    sb.append("    executionRequestClosingTimeoutMin: ").append(toIndentedString(executionRequestClosingTimeoutMin)).append("\n");
    sb.append("    jiraTicketsAutoClosing: ").append(toIndentedString(jiraTicketsAutoClosing)).append("\n");
    sb.append("    modifiedBy: ").append(toIndentedString(modifiedBy)).append("\n");
    sb.append("    modifiedWhen: ").append(toIndentedString(modifiedWhen)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    notificationMessageSubjectTemplate: ").append(toIndentedString(notificationMessageSubjectTemplate)).append("\n");
    sb.append("    projectUuid: ").append(toIndentedString(projectUuid)).append("\n");
    sb.append("    qaDslLibraryId: ").append(toIndentedString(qaDslLibraryId)).append("\n");
    sb.append("    synchronization: ").append(toIndentedString(synchronization)).append("\n");
    sb.append("    taTools: ").append(toIndentedString(taTools)).append("\n");
    sb.append("    uuid: ").append(toIndentedString(uuid)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

