package org.qubership.atp.ram.clients.api.dto.catalogue;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.qubership.atp.ram.clients.api.dto.catalogue.BugTrackingSystemSynchronizationDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.UserInfoReqDto;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * TestPlanDtoDto
 */

@JsonTypeName("TestPlanDto")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2025-07-10T07:28:17.120930265Z[Etc/UTC]")
public class TestPlanDtoDto {

  @JsonProperty("uuid")
  private UUID uuid;

  @JsonProperty("name")
  private String name;

  @JsonProperty("description")
  private String description;

  @JsonProperty("projectUuid")
  private UUID projectUuid;

  @JsonProperty("qaDslLibraryId")
  private UUID qaDslLibraryId;

  @JsonProperty("executionRequestClosingTimeoutMin")
  private Integer executionRequestClosingTimeoutMin;

  @JsonProperty("taTools")
  @Valid
  private List<UUID> taTools = null;

  @JsonProperty("lastModifiedBy")
  private UserInfoReqDto lastModifiedBy;

  @JsonProperty("lastModifyDate")
  private Long lastModifyDate;

  @JsonProperty("createdBy")
  private UserInfoReqDto createdBy;

  @JsonProperty("createdDate")
  private Long createdDate;

  @JsonProperty("disableAutoSyncAtpTestCasesWithJiraTickets")
  private Boolean disableAutoSyncAtpTestCasesWithJiraTickets;

  @JsonProperty("jiraTicketsAutoClosing")
  private Boolean jiraTicketsAutoClosing;

  @JsonProperty("notificationMessageSubjectTemplate")
  private String notificationMessageSubjectTemplate;

  @JsonProperty("synchronization")
  private BugTrackingSystemSynchronizationDto synchronization;

  public TestPlanDtoDto uuid(UUID uuid) {
    this.uuid = uuid;
    return this;
  }

  /**
   * Get uuid
   * @return uuid
  */
  @Valid 
  @Schema(name = "uuid", required = false)
  public UUID getUuid() {
    return uuid;
  }

  public void setUuid(UUID uuid) {
    this.uuid = uuid;
  }

  public TestPlanDtoDto name(String name) {
    this.name = name;
    return this;
  }

  /**
   * Get name
   * @return name
  */
  
  @Schema(name = "name", required = false)
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public TestPlanDtoDto description(String description) {
    this.description = description;
    return this;
  }

  /**
   * Get description
   * @return description
  */
  
  @Schema(name = "description", required = false)
  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  public TestPlanDtoDto projectUuid(UUID projectUuid) {
    this.projectUuid = projectUuid;
    return this;
  }

  /**
   * Get projectUuid
   * @return projectUuid
  */
  @Valid 
  @Schema(name = "projectUuid", required = false)
  public UUID getProjectUuid() {
    return projectUuid;
  }

  public void setProjectUuid(UUID projectUuid) {
    this.projectUuid = projectUuid;
  }

  public TestPlanDtoDto qaDslLibraryId(UUID qaDslLibraryId) {
    this.qaDslLibraryId = qaDslLibraryId;
    return this;
  }

  /**
   * Get qaDslLibraryId
   * @return qaDslLibraryId
  */
  @Valid 
  @Schema(name = "qaDslLibraryId", required = false)
  public UUID getQaDslLibraryId() {
    return qaDslLibraryId;
  }

  public void setQaDslLibraryId(UUID qaDslLibraryId) {
    this.qaDslLibraryId = qaDslLibraryId;
  }

  public TestPlanDtoDto executionRequestClosingTimeoutMin(Integer executionRequestClosingTimeoutMin) {
    this.executionRequestClosingTimeoutMin = executionRequestClosingTimeoutMin;
    return this;
  }

  /**
   * Get executionRequestClosingTimeoutMin
   * @return executionRequestClosingTimeoutMin
  */
  
  @Schema(name = "executionRequestClosingTimeoutMin", required = false)
  public Integer getExecutionRequestClosingTimeoutMin() {
    return executionRequestClosingTimeoutMin;
  }

  public void setExecutionRequestClosingTimeoutMin(Integer executionRequestClosingTimeoutMin) {
    this.executionRequestClosingTimeoutMin = executionRequestClosingTimeoutMin;
  }

  public TestPlanDtoDto taTools(List<UUID> taTools) {
    this.taTools = taTools;
    return this;
  }

  public TestPlanDtoDto addTaToolsItem(UUID taToolsItem) {
    if (this.taTools == null) {
      this.taTools = new ArrayList<>();
    }
    this.taTools.add(taToolsItem);
    return this;
  }

  /**
   * Get taTools
   * @return taTools
  */
  @Valid 
  @Schema(name = "taTools", required = false)
  public List<UUID> getTaTools() {
    return taTools;
  }

  public void setTaTools(List<UUID> taTools) {
    this.taTools = taTools;
  }

  public TestPlanDtoDto lastModifiedBy(UserInfoReqDto lastModifiedBy) {
    this.lastModifiedBy = lastModifiedBy;
    return this;
  }

  /**
   * Get lastModifiedBy
   * @return lastModifiedBy
  */
  @Valid 
  @Schema(name = "lastModifiedBy", required = false)
  public UserInfoReqDto getLastModifiedBy() {
    return lastModifiedBy;
  }

  public void setLastModifiedBy(UserInfoReqDto lastModifiedBy) {
    this.lastModifiedBy = lastModifiedBy;
  }

  public TestPlanDtoDto lastModifyDate(Long lastModifyDate) {
    this.lastModifyDate = lastModifyDate;
    return this;
  }

  /**
   * Get lastModifyDate
   * @return lastModifyDate
  */
  
  @Schema(name = "lastModifyDate", required = false)
  public Long getLastModifyDate() {
    return lastModifyDate;
  }

  public void setLastModifyDate(Long lastModifyDate) {
    this.lastModifyDate = lastModifyDate;
  }

  public TestPlanDtoDto createdBy(UserInfoReqDto createdBy) {
    this.createdBy = createdBy;
    return this;
  }

  /**
   * Get createdBy
   * @return createdBy
  */
  @Valid 
  @Schema(name = "createdBy", required = false)
  public UserInfoReqDto getCreatedBy() {
    return createdBy;
  }

  public void setCreatedBy(UserInfoReqDto createdBy) {
    this.createdBy = createdBy;
  }

  public TestPlanDtoDto createdDate(Long createdDate) {
    this.createdDate = createdDate;
    return this;
  }

  /**
   * Get createdDate
   * @return createdDate
  */
  
  @Schema(name = "createdDate", required = false)
  public Long getCreatedDate() {
    return createdDate;
  }

  public void setCreatedDate(Long createdDate) {
    this.createdDate = createdDate;
  }

  public TestPlanDtoDto disableAutoSyncAtpTestCasesWithJiraTickets(Boolean disableAutoSyncAtpTestCasesWithJiraTickets) {
    this.disableAutoSyncAtpTestCasesWithJiraTickets = disableAutoSyncAtpTestCasesWithJiraTickets;
    return this;
  }

  /**
   * Get disableAutoSyncAtpTestCasesWithJiraTickets
   * @return disableAutoSyncAtpTestCasesWithJiraTickets
  */
  
  @Schema(name = "disableAutoSyncAtpTestCasesWithJiraTickets", required = false)
  public Boolean getDisableAutoSyncAtpTestCasesWithJiraTickets() {
    return disableAutoSyncAtpTestCasesWithJiraTickets;
  }

  public void setDisableAutoSyncAtpTestCasesWithJiraTickets(Boolean disableAutoSyncAtpTestCasesWithJiraTickets) {
    this.disableAutoSyncAtpTestCasesWithJiraTickets = disableAutoSyncAtpTestCasesWithJiraTickets;
  }

  public TestPlanDtoDto jiraTicketsAutoClosing(Boolean jiraTicketsAutoClosing) {
    this.jiraTicketsAutoClosing = jiraTicketsAutoClosing;
    return this;
  }

  /**
   * Get jiraTicketsAutoClosing
   * @return jiraTicketsAutoClosing
  */
  
  @Schema(name = "jiraTicketsAutoClosing", required = false)
  public Boolean getJiraTicketsAutoClosing() {
    return jiraTicketsAutoClosing;
  }

  public void setJiraTicketsAutoClosing(Boolean jiraTicketsAutoClosing) {
    this.jiraTicketsAutoClosing = jiraTicketsAutoClosing;
  }

  public TestPlanDtoDto notificationMessageSubjectTemplate(String notificationMessageSubjectTemplate) {
    this.notificationMessageSubjectTemplate = notificationMessageSubjectTemplate;
    return this;
  }

  /**
   * Get notificationMessageSubjectTemplate
   * @return notificationMessageSubjectTemplate
  */
  
  @Schema(name = "notificationMessageSubjectTemplate", required = false)
  public String getNotificationMessageSubjectTemplate() {
    return notificationMessageSubjectTemplate;
  }

  public void setNotificationMessageSubjectTemplate(String notificationMessageSubjectTemplate) {
    this.notificationMessageSubjectTemplate = notificationMessageSubjectTemplate;
  }

  public TestPlanDtoDto synchronization(BugTrackingSystemSynchronizationDto synchronization) {
    this.synchronization = synchronization;
    return this;
  }

  /**
   * Get synchronization
   * @return synchronization
  */
  @Valid 
  @Schema(name = "synchronization", required = false)
  public BugTrackingSystemSynchronizationDto getSynchronization() {
    return synchronization;
  }

  public void setSynchronization(BugTrackingSystemSynchronizationDto synchronization) {
    this.synchronization = synchronization;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TestPlanDtoDto testPlanDto = (TestPlanDtoDto) o;
    return Objects.equals(this.uuid, testPlanDto.uuid) &&
        Objects.equals(this.name, testPlanDto.name) &&
        Objects.equals(this.description, testPlanDto.description) &&
        Objects.equals(this.projectUuid, testPlanDto.projectUuid) &&
        Objects.equals(this.qaDslLibraryId, testPlanDto.qaDslLibraryId) &&
        Objects.equals(this.executionRequestClosingTimeoutMin, testPlanDto.executionRequestClosingTimeoutMin) &&
        Objects.equals(this.taTools, testPlanDto.taTools) &&
        Objects.equals(this.lastModifiedBy, testPlanDto.lastModifiedBy) &&
        Objects.equals(this.lastModifyDate, testPlanDto.lastModifyDate) &&
        Objects.equals(this.createdBy, testPlanDto.createdBy) &&
        Objects.equals(this.createdDate, testPlanDto.createdDate) &&
        Objects.equals(this.disableAutoSyncAtpTestCasesWithJiraTickets, testPlanDto.disableAutoSyncAtpTestCasesWithJiraTickets) &&
        Objects.equals(this.jiraTicketsAutoClosing, testPlanDto.jiraTicketsAutoClosing) &&
        Objects.equals(this.notificationMessageSubjectTemplate, testPlanDto.notificationMessageSubjectTemplate) &&
        Objects.equals(this.synchronization, testPlanDto.synchronization);
  }

  @Override
  public int hashCode() {
    return Objects.hash(uuid, name, description, projectUuid, qaDslLibraryId, executionRequestClosingTimeoutMin, taTools, lastModifiedBy, lastModifyDate, createdBy, createdDate, disableAutoSyncAtpTestCasesWithJiraTickets, jiraTicketsAutoClosing, notificationMessageSubjectTemplate, synchronization);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TestPlanDtoDto {\n");
    sb.append("    uuid: ").append(toIndentedString(uuid)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    projectUuid: ").append(toIndentedString(projectUuid)).append("\n");
    sb.append("    qaDslLibraryId: ").append(toIndentedString(qaDslLibraryId)).append("\n");
    sb.append("    executionRequestClosingTimeoutMin: ").append(toIndentedString(executionRequestClosingTimeoutMin)).append("\n");
    sb.append("    taTools: ").append(toIndentedString(taTools)).append("\n");
    sb.append("    lastModifiedBy: ").append(toIndentedString(lastModifiedBy)).append("\n");
    sb.append("    lastModifyDate: ").append(toIndentedString(lastModifyDate)).append("\n");
    sb.append("    createdBy: ").append(toIndentedString(createdBy)).append("\n");
    sb.append("    createdDate: ").append(toIndentedString(createdDate)).append("\n");
    sb.append("    disableAutoSyncAtpTestCasesWithJiraTickets: ").append(toIndentedString(disableAutoSyncAtpTestCasesWithJiraTickets)).append("\n");
    sb.append("    jiraTicketsAutoClosing: ").append(toIndentedString(jiraTicketsAutoClosing)).append("\n");
    sb.append("    notificationMessageSubjectTemplate: ").append(toIndentedString(notificationMessageSubjectTemplate)).append("\n");
    sb.append("    synchronization: ").append(toIndentedString(synchronization)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

