package org.qubership.atp.ram.clients.api.dto.catalogue;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.qubership.atp.ram.clients.api.dto.catalogue.TestCaseOrderDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.ToolsDto;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * TestScopeFullInfoDto
 */

@JsonTypeName("TestScopeFullInfo")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2025-07-10T07:28:17.673143037Z[Etc/UTC]")
public class TestScopeFullInfoDto {

  @JsonProperty("description")
  private String description;

  @JsonProperty("environmentUuid")
  private UUID environmentUuid;

  /**
   * Gets or Sets flags
   */
  public enum FlagsEnum {
    COLLECT_LOGS("COLLECT_LOGS"),
    
    COLLECT_LOGS_ON_FAIL("COLLECT_LOGS_ON_FAIL"),
    
    COLLECT_LOGS_ON_SKIPPED("COLLECT_LOGS_ON_SKIPPED"),
    
    COLLECT_LOGS_ON_WARNING("COLLECT_LOGS_ON_WARNING"),
    
    DO_NOT_PASS_INITIAL_CONTEXT("DO_NOT_PASS_INITIAL_CONTEXT"),
    
    EXECUTE_ANYWAY("EXECUTE_ANYWAY"),
    
    FAIL_IMMEDIATELY("FAIL_IMMEDIATELY"),
    
    IGNORE_PREREQUISITE_IN_PASS_RATE("IGNORE_PREREQUISITE_IN_PASS_RATE"),
    
    IGNORE_VALIDATION_IN_PASS_RATE("IGNORE_VALIDATION_IN_PASS_RATE"),
    
    INVERT_RESULT("INVERT_RESULT"),
    
    SKIP("SKIP"),
    
    SKIP_IF_DEPENDENCIES_FAIL("SKIP_IF_DEPENDENCIES_FAIL"),
    
    STOP_ON_FAIL("STOP_ON_FAIL"),
    
    SKIP_ON_PASS("SKIP_ON_PASS"),
    
    TERMINATE_IF_FAIL("TERMINATE_IF_FAIL"),
    
    TERMINATE_IF_PREREQUISITE_FAIL("TERMINATE_IF_PREREQUISITE_FAIL"),
    
    COLLECT_SSM_METRICS_ON_FAIL("COLLECT_SSM_METRICS_ON_FAIL");

    private String value;

    FlagsEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static FlagsEnum fromValue(String value) {
      for (FlagsEnum b : FlagsEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  @JsonProperty("flags")
  @Valid
  private List<FlagsEnum> flags = null;

  @JsonProperty("name")
  private String name;

  @JsonProperty("numberOfThreshold")
  private Integer numberOfThreshold;

  @JsonProperty("order")
  private TestCaseOrderDto order;

  @JsonProperty("tools")
  private ToolsDto tools;

  @JsonProperty("uuid")
  private UUID uuid;

  @JsonProperty("widgetConfigTemplateId")
  private UUID widgetConfigTemplateId;

  public TestScopeFullInfoDto description(String description) {
    this.description = description;
    return this;
  }

  /**
   * Get description
   * @return description
  */
  
  @Schema(name = "description", required = false)
  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  public TestScopeFullInfoDto environmentUuid(UUID environmentUuid) {
    this.environmentUuid = environmentUuid;
    return this;
  }

  /**
   * Get environmentUuid
   * @return environmentUuid
  */
  @Valid 
  @Schema(name = "environmentUuid", required = false)
  public UUID getEnvironmentUuid() {
    return environmentUuid;
  }

  public void setEnvironmentUuid(UUID environmentUuid) {
    this.environmentUuid = environmentUuid;
  }

  public TestScopeFullInfoDto flags(List<FlagsEnum> flags) {
    this.flags = flags;
    return this;
  }

  public TestScopeFullInfoDto addFlagsItem(FlagsEnum flagsItem) {
    if (this.flags == null) {
      this.flags = new ArrayList<>();
    }
    this.flags.add(flagsItem);
    return this;
  }

  /**
   * Get flags
   * @return flags
  */
  
  @Schema(name = "flags", required = false)
  public List<FlagsEnum> getFlags() {
    return flags;
  }

  public void setFlags(List<FlagsEnum> flags) {
    this.flags = flags;
  }

  public TestScopeFullInfoDto name(String name) {
    this.name = name;
    return this;
  }

  /**
   * Get name
   * @return name
  */
  
  @Schema(name = "name", required = false)
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public TestScopeFullInfoDto numberOfThreshold(Integer numberOfThreshold) {
    this.numberOfThreshold = numberOfThreshold;
    return this;
  }

  /**
   * Get numberOfThreshold
   * @return numberOfThreshold
  */
  
  @Schema(name = "numberOfThreshold", required = false)
  public Integer getNumberOfThreshold() {
    return numberOfThreshold;
  }

  public void setNumberOfThreshold(Integer numberOfThreshold) {
    this.numberOfThreshold = numberOfThreshold;
  }

  public TestScopeFullInfoDto order(TestCaseOrderDto order) {
    this.order = order;
    return this;
  }

  /**
   * Get order
   * @return order
  */
  @Valid 
  @Schema(name = "order", required = false)
  public TestCaseOrderDto getOrder() {
    return order;
  }

  public void setOrder(TestCaseOrderDto order) {
    this.order = order;
  }

  public TestScopeFullInfoDto tools(ToolsDto tools) {
    this.tools = tools;
    return this;
  }

  /**
   * Get tools
   * @return tools
  */
  @Valid 
  @Schema(name = "tools", required = false)
  public ToolsDto getTools() {
    return tools;
  }

  public void setTools(ToolsDto tools) {
    this.tools = tools;
  }

  public TestScopeFullInfoDto uuid(UUID uuid) {
    this.uuid = uuid;
    return this;
  }

  /**
   * Get uuid
   * @return uuid
  */
  @Valid 
  @Schema(name = "uuid", required = false)
  public UUID getUuid() {
    return uuid;
  }

  public void setUuid(UUID uuid) {
    this.uuid = uuid;
  }

  public TestScopeFullInfoDto widgetConfigTemplateId(UUID widgetConfigTemplateId) {
    this.widgetConfigTemplateId = widgetConfigTemplateId;
    return this;
  }

  /**
   * Get widgetConfigTemplateId
   * @return widgetConfigTemplateId
  */
  @Valid 
  @Schema(name = "widgetConfigTemplateId", required = false)
  public UUID getWidgetConfigTemplateId() {
    return widgetConfigTemplateId;
  }

  public void setWidgetConfigTemplateId(UUID widgetConfigTemplateId) {
    this.widgetConfigTemplateId = widgetConfigTemplateId;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TestScopeFullInfoDto testScopeFullInfo = (TestScopeFullInfoDto) o;
    return Objects.equals(this.description, testScopeFullInfo.description) &&
        Objects.equals(this.environmentUuid, testScopeFullInfo.environmentUuid) &&
        Objects.equals(this.flags, testScopeFullInfo.flags) &&
        Objects.equals(this.name, testScopeFullInfo.name) &&
        Objects.equals(this.numberOfThreshold, testScopeFullInfo.numberOfThreshold) &&
        Objects.equals(this.order, testScopeFullInfo.order) &&
        Objects.equals(this.tools, testScopeFullInfo.tools) &&
        Objects.equals(this.uuid, testScopeFullInfo.uuid) &&
        Objects.equals(this.widgetConfigTemplateId, testScopeFullInfo.widgetConfigTemplateId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(description, environmentUuid, flags, name, numberOfThreshold, order, tools, uuid, widgetConfigTemplateId);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TestScopeFullInfoDto {\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    environmentUuid: ").append(toIndentedString(environmentUuid)).append("\n");
    sb.append("    flags: ").append(toIndentedString(flags)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    numberOfThreshold: ").append(toIndentedString(numberOfThreshold)).append("\n");
    sb.append("    order: ").append(toIndentedString(order)).append("\n");
    sb.append("    tools: ").append(toIndentedString(tools)).append("\n");
    sb.append("    uuid: ").append(toIndentedString(uuid)).append("\n");
    sb.append("    widgetConfigTemplateId: ").append(toIndentedString(widgetConfigTemplateId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

