package org.qubership.atp.ram.clients.api.dto.catalogue;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.qubership.atp.ram.clients.api.dto.catalogue.TestCaseDependency0Dto;
import org.qubership.atp.ram.clients.api.dto.catalogue.TestCasesRequestDto;
import org.springframework.format.annotation.DateTimeFormat;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * TestScopeUpdateRequestDto
 */

@JsonTypeName("TestScopeUpdateRequest")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2025-07-10T07:28:17.673143037Z[Etc/UTC]")
public class TestScopeUpdateRequestDto {

  @JsonProperty("description")
  private String description;

  @JsonProperty("executionCases")
  @Valid
  private List<TestCasesRequestDto> executionCases = null;

  @JsonProperty("flagIds")
  @Valid
  private List<UUID> flagIds = null;

  @JsonProperty("modifiedWhen")
  @DateTimeFormat(iso = DateTimeFormat.ISO.DATE_TIME)
  private OffsetDateTime modifiedWhen;

  @JsonProperty("name")
  private String name;

  @JsonProperty("prerequisitesCases")
  @Valid
  private List<TestCasesRequestDto> prerequisitesCases = null;

  @JsonProperty("projectUuid")
  private UUID projectUuid;

  @JsonProperty("testCaseDependencies")
  @Valid
  private List<TestCaseDependency0Dto> testCaseDependencies = null;

  @JsonProperty("testPlanUuid")
  private UUID testPlanUuid;

  @JsonProperty("uuid")
  private UUID uuid;

  @JsonProperty("logCollectorTemplateId")
  private UUID logCollectorTemplateId;

  @JsonProperty("validationCases")
  @Valid
  private List<TestCasesRequestDto> validationCases = null;

  @JsonProperty("widgetConfigTemplateId")
  private UUID widgetConfigTemplateId;

  public TestScopeUpdateRequestDto description(String description) {
    this.description = description;
    return this;
  }

  /**
   * Get description
   * @return description
  */
  
  @Schema(name = "description", required = false)
  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  public TestScopeUpdateRequestDto executionCases(List<TestCasesRequestDto> executionCases) {
    this.executionCases = executionCases;
    return this;
  }

  public TestScopeUpdateRequestDto addExecutionCasesItem(TestCasesRequestDto executionCasesItem) {
    if (this.executionCases == null) {
      this.executionCases = new ArrayList<>();
    }
    this.executionCases.add(executionCasesItem);
    return this;
  }

  /**
   * Get executionCases
   * @return executionCases
  */
  @Valid 
  @Schema(name = "executionCases", required = false)
  public List<TestCasesRequestDto> getExecutionCases() {
    return executionCases;
  }

  public void setExecutionCases(List<TestCasesRequestDto> executionCases) {
    this.executionCases = executionCases;
  }

  public TestScopeUpdateRequestDto flagIds(List<UUID> flagIds) {
    this.flagIds = flagIds;
    return this;
  }

  public TestScopeUpdateRequestDto addFlagIdsItem(UUID flagIdsItem) {
    if (this.flagIds == null) {
      this.flagIds = new ArrayList<>();
    }
    this.flagIds.add(flagIdsItem);
    return this;
  }

  /**
   * Get flagIds
   * @return flagIds
  */
  @Valid 
  @Schema(name = "flagIds", required = false)
  public List<UUID> getFlagIds() {
    return flagIds;
  }

  public void setFlagIds(List<UUID> flagIds) {
    this.flagIds = flagIds;
  }

  public TestScopeUpdateRequestDto modifiedWhen(OffsetDateTime modifiedWhen) {
    this.modifiedWhen = modifiedWhen;
    return this;
  }

  /**
   * Get modifiedWhen
   * @return modifiedWhen
  */
  @Valid 
  @Schema(name = "modifiedWhen", required = false)
  public OffsetDateTime getModifiedWhen() {
    return modifiedWhen;
  }

  public void setModifiedWhen(OffsetDateTime modifiedWhen) {
    this.modifiedWhen = modifiedWhen;
  }

  public TestScopeUpdateRequestDto name(String name) {
    this.name = name;
    return this;
  }

  /**
   * Get name
   * @return name
  */
  @NotNull 
  @Schema(name = "name", required = true)
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public TestScopeUpdateRequestDto prerequisitesCases(List<TestCasesRequestDto> prerequisitesCases) {
    this.prerequisitesCases = prerequisitesCases;
    return this;
  }

  public TestScopeUpdateRequestDto addPrerequisitesCasesItem(TestCasesRequestDto prerequisitesCasesItem) {
    if (this.prerequisitesCases == null) {
      this.prerequisitesCases = new ArrayList<>();
    }
    this.prerequisitesCases.add(prerequisitesCasesItem);
    return this;
  }

  /**
   * Get prerequisitesCases
   * @return prerequisitesCases
  */
  @Valid 
  @Schema(name = "prerequisitesCases", required = false)
  public List<TestCasesRequestDto> getPrerequisitesCases() {
    return prerequisitesCases;
  }

  public void setPrerequisitesCases(List<TestCasesRequestDto> prerequisitesCases) {
    this.prerequisitesCases = prerequisitesCases;
  }

  public TestScopeUpdateRequestDto projectUuid(UUID projectUuid) {
    this.projectUuid = projectUuid;
    return this;
  }

  /**
   * Get projectUuid
   * @return projectUuid
  */
  @NotNull @Valid 
  @Schema(name = "projectUuid", required = true)
  public UUID getProjectUuid() {
    return projectUuid;
  }

  public void setProjectUuid(UUID projectUuid) {
    this.projectUuid = projectUuid;
  }

  public TestScopeUpdateRequestDto testCaseDependencies(List<TestCaseDependency0Dto> testCaseDependencies) {
    this.testCaseDependencies = testCaseDependencies;
    return this;
  }

  public TestScopeUpdateRequestDto addTestCaseDependenciesItem(TestCaseDependency0Dto testCaseDependenciesItem) {
    if (this.testCaseDependencies == null) {
      this.testCaseDependencies = new ArrayList<>();
    }
    this.testCaseDependencies.add(testCaseDependenciesItem);
    return this;
  }

  /**
   * Get testCaseDependencies
   * @return testCaseDependencies
  */
  @Valid 
  @Schema(name = "testCaseDependencies", required = false)
  public List<TestCaseDependency0Dto> getTestCaseDependencies() {
    return testCaseDependencies;
  }

  public void setTestCaseDependencies(List<TestCaseDependency0Dto> testCaseDependencies) {
    this.testCaseDependencies = testCaseDependencies;
  }

  public TestScopeUpdateRequestDto testPlanUuid(UUID testPlanUuid) {
    this.testPlanUuid = testPlanUuid;
    return this;
  }

  /**
   * Get testPlanUuid
   * @return testPlanUuid
  */
  @NotNull @Valid 
  @Schema(name = "testPlanUuid", required = true)
  public UUID getTestPlanUuid() {
    return testPlanUuid;
  }

  public void setTestPlanUuid(UUID testPlanUuid) {
    this.testPlanUuid = testPlanUuid;
  }

  public TestScopeUpdateRequestDto uuid(UUID uuid) {
    this.uuid = uuid;
    return this;
  }

  /**
   * Get uuid
   * @return uuid
  */
  @Valid 
  @Schema(name = "uuid", required = false)
  public UUID getUuid() {
    return uuid;
  }

  public void setUuid(UUID uuid) {
    this.uuid = uuid;
  }

  public TestScopeUpdateRequestDto logCollectorTemplateId(UUID logCollectorTemplateId) {
    this.logCollectorTemplateId = logCollectorTemplateId;
    return this;
  }

  /**
   * Get logCollectorTemplateId
   * @return logCollectorTemplateId
  */
  @Valid 
  @Schema(name = "logCollectorTemplateId", required = false)
  public UUID getLogCollectorTemplateId() {
    return logCollectorTemplateId;
  }

  public void setLogCollectorTemplateId(UUID logCollectorTemplateId) {
    this.logCollectorTemplateId = logCollectorTemplateId;
  }

  public TestScopeUpdateRequestDto validationCases(List<TestCasesRequestDto> validationCases) {
    this.validationCases = validationCases;
    return this;
  }

  public TestScopeUpdateRequestDto addValidationCasesItem(TestCasesRequestDto validationCasesItem) {
    if (this.validationCases == null) {
      this.validationCases = new ArrayList<>();
    }
    this.validationCases.add(validationCasesItem);
    return this;
  }

  /**
   * Get validationCases
   * @return validationCases
  */
  @Valid 
  @Schema(name = "validationCases", required = false)
  public List<TestCasesRequestDto> getValidationCases() {
    return validationCases;
  }

  public void setValidationCases(List<TestCasesRequestDto> validationCases) {
    this.validationCases = validationCases;
  }

  public TestScopeUpdateRequestDto widgetConfigTemplateId(UUID widgetConfigTemplateId) {
    this.widgetConfigTemplateId = widgetConfigTemplateId;
    return this;
  }

  /**
   * Get widgetConfigTemplateId
   * @return widgetConfigTemplateId
  */
  @Valid 
  @Schema(name = "widgetConfigTemplateId", required = false)
  public UUID getWidgetConfigTemplateId() {
    return widgetConfigTemplateId;
  }

  public void setWidgetConfigTemplateId(UUID widgetConfigTemplateId) {
    this.widgetConfigTemplateId = widgetConfigTemplateId;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TestScopeUpdateRequestDto testScopeUpdateRequest = (TestScopeUpdateRequestDto) o;
    return Objects.equals(this.description, testScopeUpdateRequest.description) &&
        Objects.equals(this.executionCases, testScopeUpdateRequest.executionCases) &&
        Objects.equals(this.flagIds, testScopeUpdateRequest.flagIds) &&
        Objects.equals(this.modifiedWhen, testScopeUpdateRequest.modifiedWhen) &&
        Objects.equals(this.name, testScopeUpdateRequest.name) &&
        Objects.equals(this.prerequisitesCases, testScopeUpdateRequest.prerequisitesCases) &&
        Objects.equals(this.projectUuid, testScopeUpdateRequest.projectUuid) &&
        Objects.equals(this.testCaseDependencies, testScopeUpdateRequest.testCaseDependencies) &&
        Objects.equals(this.testPlanUuid, testScopeUpdateRequest.testPlanUuid) &&
        Objects.equals(this.uuid, testScopeUpdateRequest.uuid) &&
        Objects.equals(this.logCollectorTemplateId, testScopeUpdateRequest.logCollectorTemplateId) &&
        Objects.equals(this.validationCases, testScopeUpdateRequest.validationCases) &&
        Objects.equals(this.widgetConfigTemplateId, testScopeUpdateRequest.widgetConfigTemplateId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(description, executionCases, flagIds, modifiedWhen, name, prerequisitesCases, projectUuid, testCaseDependencies, testPlanUuid, uuid, logCollectorTemplateId, validationCases, widgetConfigTemplateId);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TestScopeUpdateRequestDto {\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    executionCases: ").append(toIndentedString(executionCases)).append("\n");
    sb.append("    flagIds: ").append(toIndentedString(flagIds)).append("\n");
    sb.append("    modifiedWhen: ").append(toIndentedString(modifiedWhen)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    prerequisitesCases: ").append(toIndentedString(prerequisitesCases)).append("\n");
    sb.append("    projectUuid: ").append(toIndentedString(projectUuid)).append("\n");
    sb.append("    testCaseDependencies: ").append(toIndentedString(testCaseDependencies)).append("\n");
    sb.append("    testPlanUuid: ").append(toIndentedString(testPlanUuid)).append("\n");
    sb.append("    uuid: ").append(toIndentedString(uuid)).append("\n");
    sb.append("    logCollectorTemplateId: ").append(toIndentedString(logCollectorTemplateId)).append("\n");
    sb.append("    validationCases: ").append(toIndentedString(validationCases)).append("\n");
    sb.append("    widgetConfigTemplateId: ").append(toIndentedString(widgetConfigTemplateId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

