package org.qubership.atp.ram.clients.api.dto.environments.environment;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * ConnectionDtoDto
 */

@JsonTypeName("ConnectionDto")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2025-07-10T07:28:18.822336718Z[Etc/UTC]")
public class ConnectionDtoDto {

  @JsonProperty("connectionType")
  private String connectionType;

  @JsonProperty("created")
  private Long created;

  @JsonProperty("createdBy")
  private UUID createdBy;

  @JsonProperty("description")
  private String description;

  @JsonProperty("id")
  private UUID id;

  @JsonProperty("modified")
  private Long modified;

  @JsonProperty("modifiedBy")
  private UUID modifiedBy;

  @JsonProperty("name")
  private String name;

  @JsonProperty("parameters")
  @Valid
  private Map<String, String> parameters = null;

  @JsonProperty("projectId")
  private UUID projectId;

  @JsonProperty("services")
  @Valid
  private List<String> services = null;

  @JsonProperty("sourceTemplateId")
  private UUID sourceTemplateId;

  @JsonProperty("systemId")
  private UUID systemId;

  public ConnectionDtoDto connectionType(String connectionType) {
    this.connectionType = connectionType;
    return this;
  }

  /**
   * Get connectionType
   * @return connectionType
  */
  
  @Schema(name = "connectionType", required = false)
  public String getConnectionType() {
    return connectionType;
  }

  public void setConnectionType(String connectionType) {
    this.connectionType = connectionType;
  }

  public ConnectionDtoDto created(Long created) {
    this.created = created;
    return this;
  }

  /**
   * Get created
   * @return created
  */
  
  @Schema(name = "created", required = false)
  public Long getCreated() {
    return created;
  }

  public void setCreated(Long created) {
    this.created = created;
  }

  public ConnectionDtoDto createdBy(UUID createdBy) {
    this.createdBy = createdBy;
    return this;
  }

  /**
   * Get createdBy
   * @return createdBy
  */
  @Valid 
  @Schema(name = "createdBy", required = false)
  public UUID getCreatedBy() {
    return createdBy;
  }

  public void setCreatedBy(UUID createdBy) {
    this.createdBy = createdBy;
  }

  public ConnectionDtoDto description(String description) {
    this.description = description;
    return this;
  }

  /**
   * Get description
   * @return description
  */
  
  @Schema(name = "description", required = false)
  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  public ConnectionDtoDto id(UUID id) {
    this.id = id;
    return this;
  }

  /**
   * Get id
   * @return id
  */
  @Valid 
  @Schema(name = "id", required = false)
  public UUID getId() {
    return id;
  }

  public void setId(UUID id) {
    this.id = id;
  }

  public ConnectionDtoDto modified(Long modified) {
    this.modified = modified;
    return this;
  }

  /**
   * Get modified
   * @return modified
  */
  
  @Schema(name = "modified", required = false)
  public Long getModified() {
    return modified;
  }

  public void setModified(Long modified) {
    this.modified = modified;
  }

  public ConnectionDtoDto modifiedBy(UUID modifiedBy) {
    this.modifiedBy = modifiedBy;
    return this;
  }

  /**
   * Get modifiedBy
   * @return modifiedBy
  */
  @Valid 
  @Schema(name = "modifiedBy", required = false)
  public UUID getModifiedBy() {
    return modifiedBy;
  }

  public void setModifiedBy(UUID modifiedBy) {
    this.modifiedBy = modifiedBy;
  }

  public ConnectionDtoDto name(String name) {
    this.name = name;
    return this;
  }

  /**
   * Get name
   * @return name
  */
  
  @Schema(name = "name", required = false)
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public ConnectionDtoDto parameters(Map<String, String> parameters) {
    this.parameters = parameters;
    return this;
  }

  public ConnectionDtoDto putParametersItem(String key, String parametersItem) {
    if (this.parameters == null) {
      this.parameters = new HashMap<>();
    }
    this.parameters.put(key, parametersItem);
    return this;
  }

  /**
   * Get parameters
   * @return parameters
  */
  
  @Schema(name = "parameters", required = false)
  public Map<String, String> getParameters() {
    return parameters;
  }

  public void setParameters(Map<String, String> parameters) {
    this.parameters = parameters;
  }

  public ConnectionDtoDto projectId(UUID projectId) {
    this.projectId = projectId;
    return this;
  }

  /**
   * Get projectId
   * @return projectId
  */
  @Valid 
  @Schema(name = "projectId", required = false)
  public UUID getProjectId() {
    return projectId;
  }

  public void setProjectId(UUID projectId) {
    this.projectId = projectId;
  }

  public ConnectionDtoDto services(List<String> services) {
    this.services = services;
    return this;
  }

  public ConnectionDtoDto addServicesItem(String servicesItem) {
    if (this.services == null) {
      this.services = new ArrayList<>();
    }
    this.services.add(servicesItem);
    return this;
  }

  /**
   * Get services
   * @return services
  */
  
  @Schema(name = "services", required = false)
  public List<String> getServices() {
    return services;
  }

  public void setServices(List<String> services) {
    this.services = services;
  }

  public ConnectionDtoDto sourceTemplateId(UUID sourceTemplateId) {
    this.sourceTemplateId = sourceTemplateId;
    return this;
  }

  /**
   * Get sourceTemplateId
   * @return sourceTemplateId
  */
  @Valid 
  @Schema(name = "sourceTemplateId", required = false)
  public UUID getSourceTemplateId() {
    return sourceTemplateId;
  }

  public void setSourceTemplateId(UUID sourceTemplateId) {
    this.sourceTemplateId = sourceTemplateId;
  }

  public ConnectionDtoDto systemId(UUID systemId) {
    this.systemId = systemId;
    return this;
  }

  /**
   * Get systemId
   * @return systemId
  */
  @Valid 
  @Schema(name = "systemId", required = false)
  public UUID getSystemId() {
    return systemId;
  }

  public void setSystemId(UUID systemId) {
    this.systemId = systemId;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ConnectionDtoDto connectionDto = (ConnectionDtoDto) o;
    return Objects.equals(this.connectionType, connectionDto.connectionType) &&
        Objects.equals(this.created, connectionDto.created) &&
        Objects.equals(this.createdBy, connectionDto.createdBy) &&
        Objects.equals(this.description, connectionDto.description) &&
        Objects.equals(this.id, connectionDto.id) &&
        Objects.equals(this.modified, connectionDto.modified) &&
        Objects.equals(this.modifiedBy, connectionDto.modifiedBy) &&
        Objects.equals(this.name, connectionDto.name) &&
        Objects.equals(this.parameters, connectionDto.parameters) &&
        Objects.equals(this.projectId, connectionDto.projectId) &&
        Objects.equals(this.services, connectionDto.services) &&
        Objects.equals(this.sourceTemplateId, connectionDto.sourceTemplateId) &&
        Objects.equals(this.systemId, connectionDto.systemId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(connectionType, created, createdBy, description, id, modified, modifiedBy, name, parameters, projectId, services, sourceTemplateId, systemId);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ConnectionDtoDto {\n");
    sb.append("    connectionType: ").append(toIndentedString(connectionType)).append("\n");
    sb.append("    created: ").append(toIndentedString(created)).append("\n");
    sb.append("    createdBy: ").append(toIndentedString(createdBy)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    modified: ").append(toIndentedString(modified)).append("\n");
    sb.append("    modifiedBy: ").append(toIndentedString(modifiedBy)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    parameters: ").append(toIndentedString(parameters)).append("\n");
    sb.append("    projectId: ").append(toIndentedString(projectId)).append("\n");
    sb.append("    services: ").append(toIndentedString(services)).append("\n");
    sb.append("    sourceTemplateId: ").append(toIndentedString(sourceTemplateId)).append("\n");
    sb.append("    systemId: ").append(toIndentedString(systemId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

