/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.orchestrator.clients.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import java.util.UUID;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.qubership.atp.orchestrator.clients.dto.ExecutionOrderDto;
import org.qubership.atp.orchestrator.clients.dto.FlowExecutionRequestDto;
import org.qubership.atp.orchestrator.clients.dto.RerunExecutionRequestDto;
import org.qubership.atp.orchestrator.clients.dto.TerminateRequestDto;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Validated
@Tag(name="ProcessController", description="Process Controller")
public interface ProcessControllerApi {
    @Operation(operationId="executeOrder", summary="Create new process via Dealer or Exists Engine", tags={"process-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=UUID.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/api/v1/processorchestrator/flow/order"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<List<UUID>> executeOrder(@Parameter(name="authorization", description="authorization") @RequestHeader(value="authorization", required=false) String var1, @Parameter(name="ExecutionOrderDto", description="") @Valid @RequestBody(required=false) ExecutionOrderDto var2);

    @Operation(operationId="executeProcessViaDealer", summary="Create new process via Dealer or Exists Engine", tags={"process-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=UUID.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/api/v1/processorchestrator/flow"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<UUID> executeProcessViaDealer(@Parameter(name="FlowExecutionRequestDto", description="") @Valid @RequestBody(required=false) FlowExecutionRequestDto var1);

    @Operation(operationId="executeProcessViaDynamicBpmnGeneration", summary="Create new process via Dealer or Exists Engine", tags={"process-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=UUID.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/api/v1/processorchestrator/flow/bpmn"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<UUID> executeProcessViaDynamicBpmnGeneration(@Parameter(name="FlowExecutionRequestDto", description="") @Valid @RequestBody(required=false) FlowExecutionRequestDto var1);

    @Operation(operationId="getRunnerProcessIdByExecutionRequestId", summary="Get runner process id by execution request", tags={"process-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=UUID.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/v1/processorchestrator/flow/er/{executionRequestId}/process/id"}, produces={"application/json"})
    public ResponseEntity<UUID> getRunnerProcessIdByExecutionRequestId(@Parameter(name="executionRequestId", description="executionRequestId", required=true) @PathVariable(value="executionRequestId") UUID var1);

    @Operation(operationId="rerunExecutionRequestProcess", summary="Restart ER with selected TR ids activity", tags={"process-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=UUID.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/api/v1/processorchestrator/flow/er/process/rerun"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<UUID> rerunExecutionRequestProcess(@Parameter(name="newExecuteRequestId", description="newExecuteRequestId") @Valid @RequestParam(value="newExecuteRequestId", required=false) UUID var1, @Parameter(name="authorization", description="authorization") @RequestHeader(value="authorization", required=false) String var2, @Parameter(name="RerunExecutionRequestDto", description="") @Valid @RequestBody(required=false) RerunExecutionRequestDto var3);

    @Operation(operationId="rerunTestRunsProcess", summary="Restart ER with selected TR ids activity", tags={"process-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=UUID.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/api/v1/processorchestrator/flow/er/process/restart/{uuid}"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<UUID> rerunTestRunsProcess(@Parameter(name="uuid", description="uuid", required=true) @PathVariable(value="uuid") UUID var1, @Parameter(name="Authorization", description="Authorization") @RequestHeader(value="Authorization", required=false) String var2, @Parameter(name="UUID", description="") @Valid @RequestBody(required=false) List<UUID> var3);

    @Operation(operationId="restartProcess", summary="Restart ER process", tags={"process-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/api/v1/processorchestrator/flow/er/process/restart"}, produces={"text/plain"}, consumes={"application/json"})
    public ResponseEntity<String> restartProcess(@Parameter(name="UUID", description="") @Valid @RequestBody(required=false) List<UUID> var1);

    @Operation(operationId="restartTestRunProcess", summary="Restart TR activity", tags={"process-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/api/v1/processorchestrator/flow/tr/process/restart"}, produces={"text/plain"}, consumes={"application/json"})
    public ResponseEntity<String> restartTestRunProcess(@NotNull @Parameter(name="executionRequestId", description="executionRequestId", required=true) @Valid @RequestParam(value="executionRequestId", required=true) UUID var1, @Parameter(name="UUID", description="") @Valid @RequestBody(required=false) List<UUID> var2);

    @Operation(operationId="resumeProcess", summary="Resume ER process", tags={"process-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/api/v1/processorchestrator/flow/er/process/resume"}, produces={"text/plain"}, consumes={"application/json"})
    public ResponseEntity<String> resumeProcess(@Parameter(name="UUID", description="") @Valid @RequestBody(required=false) List<UUID> var1);

    @Operation(operationId="resumeTestRunProcess", summary="Resume TR activity", tags={"process-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/api/v1/processorchestrator/flow/tr/process/resume"}, produces={"text/plain"}, consumes={"application/json"})
    public ResponseEntity<String> resumeTestRunProcess(@NotNull @Parameter(name="executionRequestId", description="executionRequestId", required=true) @Valid @RequestParam(value="executionRequestId", required=true) UUID var1, @Parameter(name="UUID", description="") @Valid @RequestBody(required=false) List<UUID> var2);

    @Operation(operationId="stopProcess", summary="Stop ER process", tags={"process-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/api/v1/processorchestrator/flow/er/process/stop"}, produces={"text/plain"}, consumes={"application/json"})
    public ResponseEntity<String> stopProcess(@Parameter(name="UUID", description="") @Valid @RequestBody(required=false) List<UUID> var1);

    @Operation(operationId="stopTestRunProcess", summary="Stop TR activity", tags={"process-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/api/v1/processorchestrator/flow/tr/process/stop"}, produces={"text/plain"}, consumes={"application/json"})
    public ResponseEntity<String> stopTestRunProcess(@NotNull @Parameter(name="executionRequestId", description="executionRequestId", required=true) @Valid @RequestParam(value="executionRequestId", required=true) UUID var1, @Parameter(name="UUID", description="") @Valid @RequestBody(required=false) List<UUID> var2);

    @Operation(operationId="storeExecutionOrder", summary="Store Execution Order to Orchestrator Database", tags={"process-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=UUID.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/api/v1/processorchestrator/flow/store"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<List<UUID>> storeExecutionOrder(@Parameter(name="authorization", description="authorization") @RequestHeader(value="authorization", required=false) String var1, @Parameter(name="ExecutionOrderDto", description="") @Valid @RequestBody(required=false) ExecutionOrderDto var2);

    @Operation(operationId="terminateProcess", summary="Terminate ER process", tags={"process-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/api/v1/processorchestrator/flow/er/process/terminate"}, produces={"text/plain"}, consumes={"application/json"})
    public ResponseEntity<String> terminateProcess(@Parameter(name="TerminateRequestDto", description="") @Valid @RequestBody(required=false) TerminateRequestDto var1);

    @Operation(operationId="terminateTestRunProcess", summary="Terminate TR activity", tags={"process-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/api/v1/processorchestrator/flow/tr/process/terminate"}, produces={"text/plain"}, consumes={"application/json"})
    public ResponseEntity<String> terminateTestRunProcess(@Parameter(name="UUID", description="") @Valid @RequestBody(required=false) List<UUID> var1);
}

