/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ram.clients.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.qubership.atp.ram.clients.api.dto.catalogue.JiraComponentDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.JiraIssueCreateRequestDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.JiraIssueCreateResponseDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.JiraIssueDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.JiraIssueSearchRequestDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.JiraIssueSearchResponseDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.ProjectSearchRequestDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.TestRunToJiraInfoDto;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Validated
@Tag(name="IntegrationController", description="Integration Controller")
public interface IntegrationControllerApi {
    @Deprecated
    @Operation(operationId="autoSyncExecutionRequestWithJira", summary="autoSyncExecutionRequestWithJira", tags={"integration-controller"}, responses={@ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="204", description="No Content"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/catalog/api/v1/integrations/autosync/executionrequest/{uuid}"})
    public ResponseEntity<Void> autoSyncExecutionRequestWithJira(@Parameter(name="uuid", description="uuid", required=true) @PathVariable(value="uuid") UUID var1, @NotNull @Parameter(name="syncTestCases", description="syncTestCases", required=true) @Valid @RequestParam(value="syncTestCases", required=true) Boolean var2, @NotNull @Parameter(name="syncTestRuns", description="syncTestRuns", required=true) @Valid @RequestParam(value="syncTestRuns", required=true) Boolean var3);

    @Operation(operationId="autoSyncTestRunsWithJira", summary="autoSyncTestRunsWithJira", tags={"integration-controller"}, responses={@ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="204", description="No Content"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/catalog/api/v1/integrations/project/{projectId}/executionrequest/{executionRequestId}/autosync"}, consumes={"application/json"})
    public ResponseEntity<Void> autoSyncTestRunsWithJira(@Parameter(name="projectId", description="project identifier", required=true) @PathVariable(value="projectId") UUID var1, @Parameter(name="executionRequestId", description="execution request identifier", required=true) @PathVariable(value="executionRequestId") UUID var2, @NotNull @Parameter(name="syncTestCases", description="syncTestCases", required=true) @Valid @RequestParam(value="syncTestCases", required=true) Boolean var3, @NotNull @Parameter(name="syncTestRuns", description="syncTestRuns", required=true) @Valid @RequestParam(value="syncTestRuns", required=true) Boolean var4, @Parameter(name="TestRunToJiraInfoDto", description="") @Valid @RequestBody(required=false) List<TestRunToJiraInfoDto> var5);

    @Operation(operationId="commentOnE2ETickets", summary="commentOnE2ETickets", tags={"integration-controller"}, responses={@ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="204", description="No Content"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/catalog/api/v1/integrations/propagate/testcases/comment"}, consumes={"application/json"})
    public ResponseEntity<Void> commentOnE2ETickets(@Parameter(name="TestRunToJiraInfoDto", description="") @Valid @RequestBody(required=false) List<TestRunToJiraInfoDto> var1);

    @Operation(operationId="createJiraTicket", summary="createJiraTicket", tags={"integration-controller"}, responses={@ApiResponse(responseCode="201", description="Created", content={@Content(mediaType="application/json", schema=@Schema(implementation=JiraIssueCreateResponseDto.class))}), @ApiResponse(responseCode="204", description="No Content"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/catalog/api/v1/integrations/jira/ticket/create"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<JiraIssueCreateResponseDto> createJiraTicket(@NotNull @Parameter(name="testPlanId", description="", required=true) @Valid @RequestParam(value="testPlanId", required=true) UUID var1, @Parameter(name="JiraIssueCreateRequestDto", description="") @Valid @RequestBody(required=false) JiraIssueCreateRequestDto var2);

    @Operation(operationId="createJiraTicketForTestRun", summary="createJiraTicketForTestRun", tags={"integration-controller"}, responses={@ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="204", description="No Content"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/catalog/api/v1/integrations/create/testruns"}, consumes={"application/json"})
    public ResponseEntity<Void> createJiraTicketForTestRun(@Parameter(name="UUID", description="") @Valid @RequestBody(required=false) Set<UUID> var1);

    @Operation(operationId="getJiraTicketByKey", summary="getJiraTicketByKey", tags={"integration-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=JiraIssueDto.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="204", description="No Content"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/catalog/api/v1/integrations/jira/ticket"}, produces={"application/json"})
    public ResponseEntity<JiraIssueDto> getJiraTicketByKey(@NotNull @Parameter(name="testPlanId", description="", required=true) @Valid @RequestParam(value="testPlanId", required=true) UUID var1, @NotNull @Parameter(name="key", description="", required=true) @Valid @RequestParam(value="key", required=true) String var2);

    @Operation(operationId="getTestPlanJiraComponents", summary="getTestPlanJiraComponents", tags={"integration-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=JiraComponentDto.class))}), @ApiResponse(responseCode="204", description="No Content"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/catalog/api/v1/integrations/testplan/{uuid}/components"}, produces={"application/json"})
    public ResponseEntity<List<JiraComponentDto>> getTestPlanJiraComponents(@Parameter(name="uuid", description="", required=true) @PathVariable(value="uuid") UUID var1);

    @Operation(operationId="propagateTestCasesToJira", summary="propagateTestCasesToJira", tags={"integration-controller"}, responses={@ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="204", description="No Content"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/catalog/api/v1/integrations/propagate/testcases"}, consumes={"application/json"})
    public ResponseEntity<Void> propagateTestCasesToJira(@Parameter(name="UUID", description="") @Valid @RequestBody(required=false) Set<UUID> var1);

    @Operation(operationId="propagateTestPlanToJira", summary="propagateTestPlanToJira", tags={"integration-controller"}, responses={@ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="204", description="No Content"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/catalog/api/v1/integrations/propagate/testplan/{uuid}"})
    public ResponseEntity<Void> propagateTestPlanToJira(@Parameter(name="uuid", description="uuid", required=true) @PathVariable(value="uuid") UUID var1);

    @Operation(operationId="propagateTestRunsToJira", summary="propagateTestRunsToJira", tags={"integration-controller"}, responses={@ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="204", description="No Content"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/catalog/api/v1/integrations/propagate/testruns"}, consumes={"application/json"})
    public ResponseEntity<Void> propagateTestRunsToJira(@Parameter(name="UUID", description="") @Valid @RequestBody(required=false) Set<UUID> var1);

    @Operation(operationId="propagateTestRunsToJiraByExecutionRequestId", summary="propagateTestRunsToJiraByExecutionRequestId", tags={"integration-controller"}, responses={@ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="204", description="No Content"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/catalog/api/v1/integrations/propagate/executionrequest/{uuid}"})
    public ResponseEntity<Void> propagateTestRunsToJiraByExecutionRequestId(@Parameter(name="uuid", description="uuid", required=true) @PathVariable(value="uuid") UUID var1);

    @Operation(operationId="resetTransitionMap", summary="resetTransitionMap", tags={"integration-controller"}, responses={@ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="204", description="No Content"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/catalog/api/v1/integrations/transitions/refresh"})
    public ResponseEntity<Void> resetTransitionMap();

    @Operation(operationId="searchIssues", summary="searchIssues", tags={"integration-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=JiraIssueSearchResponseDto.class))}), @ApiResponse(responseCode="204", description="No Content"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/catalog/api/v1/integrations/jira/ticket/search"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<JiraIssueSearchResponseDto> searchIssues(@Parameter(name="JiraIssueSearchRequestDto", description="") @Valid @RequestBody(required=false) JiraIssueSearchRequestDto var1);

    @Operation(operationId="searchProjectByKey", summary="searchProjectByKey", tags={"integration-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=Object.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/catalog/api/v1/integrations/{name}/projects/search"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<Object> searchProjectByKey(@Parameter(name="name", description="name", required=true) @PathVariable(value="name") String var1, @Parameter(name="ProjectSearchRequestDto", description="") @Valid @RequestBody(required=false) ProjectSearchRequestDto var2);

    @Operation(operationId="searchProjectByTestPlanId", summary="searchProjectByTestPlanId", tags={"integration-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=Object.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/catalog/api/v1/integrations/testplan/{uuid}/projects/search"}, produces={"application/json"})
    public ResponseEntity<Object> searchProjectByTestPlanId(@Parameter(name="uuid", description="uuid", required=true) @PathVariable(value="uuid") UUID var1);

    @Operation(operationId="updateTestCasesFromJira", summary="updateTestCasesFromJira", tags={"integration-controller"}, responses={@ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="204", description="No Content"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/catalog/api/v1/integrations/refresh/testcases"}, consumes={"application/json"})
    public ResponseEntity<Void> updateTestCasesFromJira(@Parameter(name="UUID", description="") @Valid @RequestBody(required=false) Set<UUID> var1);

    @Operation(operationId="updateTestPlanFromJira", summary="updateTestPlanFromJira", tags={"integration-controller"}, responses={@ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="204", description="No Content"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/catalog/api/v1/integrations/refresh/testplan/{uuid}"})
    public ResponseEntity<Void> updateTestPlanFromJira(@Parameter(name="uuid", description="uuid", required=true) @PathVariable(value="uuid") UUID var1);

    @Operation(operationId="updateTestRunsFromJira", summary="updateTestRunsFromJira", tags={"integration-controller"}, responses={@ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="204", description="No Content"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/catalog/api/v1/integrations/refresh/testruns"}, consumes={"application/json"})
    public ResponseEntity<Void> updateTestRunsFromJira(@Parameter(name="UUID", description="") @Valid @RequestBody(required=false) Set<UUID> var1);
}

