/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ram.clients.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.qubership.atp.ram.clients.api.dto.catalogue.CaseCreationRequestDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.CasePatchUpdateRequestDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.CaseSearchRequestDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.CaseUpdateRequestDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.CompareCopyRequestDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.CompareItemCopyRequestDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.CompareTestCasesDatasetsRequestDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.CompareTestCasesDatasetsResponseDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.CopyRequestDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.EnrichedCaseDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.JiraComponentDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.LabelsRequestDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.MoveRequestDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.PageAbstractEntityResponseDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.PaginationResponseDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.TestCaseCompareCopyResponseDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.TestCaseComponentsDeleteRequestDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.TestCaseComponentsDeleteResponseDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.TestCaseComponentsSearchRequestDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.TestCaseComponentsSetRequestDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.TestCaseDatasetsSetRequestDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.TestCaseDependenciesResponseDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.TestCaseDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.TestCaseLabelResponseDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.TestCaseLastStatusDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.TestCaseResponseDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.TestCaseSearchRequestDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.TestCasesCopyRequestDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.TestCasesDataSetReplaceRequestDto;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Validated
@Tag(name="TestCaseController", description="Test Case Controller")
public interface TestCaseControllerApi {
    @Operation(operationId="addLabelsToTestCases", summary="addLabelsToTestCases", tags={"test-case-controller"}, responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/catalog/api/v1/testcases/labels"}, consumes={"application/json"})
    public ResponseEntity<Void> addLabelsToTestCases(@Parameter(name="LabelsRequestDto", description="") @Valid @RequestBody(required=false) LabelsRequestDto var1);

    @Operation(operationId="bulkCopyTestCasesWhileTestPlansCompare", summary="bulkCopyTestCasesWhileTestPlansCompare", tags={"test-case-controller"}, responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/catalog/api/v1/testcases/compare/copy/bulk"}, consumes={"application/json"})
    public ResponseEntity<Void> bulkCopyTestCasesWhileTestPlansCompare(@Parameter(name="CompareCopyRequestDto", description="") @Valid @RequestBody(required=false) CompareCopyRequestDto var1);

    @Operation(operationId="calculateDependencies", summary="calculateDependencies", tags={"test-case-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=TestCaseDependenciesResponseDto.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/catalog/api/v1/testcases/calculate-dependencies"}, produces={"application/json"})
    public ResponseEntity<TestCaseDependenciesResponseDto> calculateDependencies(@NotNull @Parameter(name="dataSetId", description="dataSetId", required=true) @Valid @RequestParam(value="dataSetId", required=true) UUID var1);

    @Operation(operationId="compareTestCasesDatasets", summary="compareTestCasesDatasets", tags={"test-case-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=CompareTestCasesDatasetsResponseDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/catalog/api/v1/testcases/datasets/compare"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<CompareTestCasesDatasetsResponseDto> compareTestCasesDatasets(@Parameter(name="CompareTestCasesDatasetsRequestDto", description="") @Valid @RequestBody(required=false) CompareTestCasesDatasetsRequestDto var1);

    @Operation(operationId="copyTestCaseWhileTestPlansCompare", summary="copyTestCaseWhileTestPlansCompare", tags={"test-case-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=TestCaseCompareCopyResponseDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/catalog/api/v1/testcases/compare/copy"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<TestCaseCompareCopyResponseDto> copyTestCaseWhileTestPlansCompare(@Parameter(name="CompareItemCopyRequestDto", description="") @Valid @RequestBody(required=false) CompareItemCopyRequestDto var1);

    @Operation(operationId="copyTestCases", summary="copyTestCases", tags={"test-case-controller"}, responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/catalog/api/v1/testcases/copy"}, consumes={"application/json"})
    public ResponseEntity<Void> copyTestCases(@Parameter(name="CopyRequestDto", description="") @Valid @RequestBody(required=false) CopyRequestDto var1);

    @Operation(operationId="copyTestCasesWithScenarios", summary="copyTestCasesWithScenarios", tags={"test-case-controller"}, responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/catalog/api/v1/testcases/testscenarios/copy"}, consumes={"application/json"})
    public ResponseEntity<Void> copyTestCasesWithScenarios(@Parameter(name="TestCasesCopyRequestDto", description="") @Valid @RequestBody(required=false) TestCasesCopyRequestDto var1);

    @Operation(operationId="create", summary="create", tags={"test-case-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=UUID.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/catalog/api/v1/testcases"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<List<UUID>> create(@Parameter(name="CaseCreationRequestDto", description="") @Valid @RequestBody(required=false) CaseCreationRequestDto var1);

    @Operation(operationId="delete", summary="delete", tags={"test-case-controller"}, responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="204", description="No Content"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden")})
    @RequestMapping(method={RequestMethod.DELETE}, value={"/catalog/api/v1/testcases"}, consumes={"application/json"})
    public ResponseEntity<Void> delete(@Parameter(name="UUID", description="") @Valid @RequestBody(required=false) Set<UUID> var1);

    @Operation(operationId="deleteLabelsFromTestCases", summary="deleteLabelsFromTestCases", tags={"test-case-controller"}, responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="204", description="No Content"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden")})
    @RequestMapping(method={RequestMethod.DELETE}, value={"/catalog/api/v1/testcases/labels"}, consumes={"application/json"})
    public ResponseEntity<Void> deleteLabelsFromTestCases(@Parameter(name="LabelsRequestDto", description="") @Valid @RequestBody(required=false) LabelsRequestDto var1);

    @Operation(operationId="deleteTestCaseComponents", summary="delete test case components", tags={"test-case-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=TestCaseComponentsDeleteResponseDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.DELETE}, value={"/catalog/api/v1/testcases/components"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<TestCaseComponentsDeleteResponseDto> deleteTestCaseComponents(@Parameter(name="TestCaseComponentsDeleteRequestDto", description="") @Valid @RequestBody(required=false) TestCaseComponentsDeleteRequestDto var1);

    @Operation(operationId="getAll", summary="getAll", tags={"test-case-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=TestCaseDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/catalog/api/v1/testcases"}, produces={"application/json"})
    public ResponseEntity<List<TestCaseDto>> getAll();

    @Operation(operationId="getAllNamesByNameWithPagination", summary="getAllNamesByNameWithPagination", tags={"test-case-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=PageAbstractEntityResponseDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/catalog/api/v1/testcases/find-name-pagination"}, produces={"application/json"})
    public ResponseEntity<PageAbstractEntityResponseDto> getAllNamesByNameWithPagination(@NotNull @Parameter(name="projectId", description="projectId", required=true) @Valid @RequestParam(value="projectId", required=true) UUID var1, @NotNull @Parameter(name="testPlanId", description="testPlanId", required=true) @Valid @RequestParam(value="testPlanId", required=true) UUID var2, @NotNull @Parameter(name="name", description="name", required=true) @Valid @RequestParam(value="name", required=true) String var3, @Parameter(name="offset", description="") @Valid @RequestParam(value="offset", required=false) Long var4, @Parameter(name="pageNumber", description="") @Valid @RequestParam(value="pageNumber", required=false) Integer var5, @Parameter(name="pageSize", description="") @Valid @RequestParam(value="pageSize", required=false) Integer var6, @Parameter(name="paged", description="") @Valid @RequestParam(value="paged", required=false) Boolean var7, @Parameter(name="sort.sorted", description="") @Valid @RequestParam(value="sort.sorted", required=false) Boolean var8, @Parameter(name="sort.unsorted", description="") @Valid @RequestParam(value="sort.unsorted", required=false) Boolean var9, @Parameter(name="unpaged", description="") @Valid @RequestParam(value="unpaged", required=false) Boolean var10);

    @Operation(operationId="getCaseLabels", summary="getCaseLabels", tags={"test-case-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=TestCaseLabelResponseDto.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/catalog/api/v1/testcases/labels/search"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<List<TestCaseLabelResponseDto>> getCaseLabels(@Parameter(name="UUID", description="") @Valid @RequestBody(required=false) Set<UUID> var1);

    @Operation(operationId="getDataSetListTestCasesUsages", summary="getDataSetListTestCasesUsages", tags={"test-case-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=PaginationResponseDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/catalog/api/v1/testcases/dataSetLists/{dslId}/usages"}, produces={"application/json"})
    public ResponseEntity<PaginationResponseDto> getDataSetListTestCasesUsages(@Parameter(name="dslId", description="data set list id", required=true) @PathVariable(value="dslId") UUID var1, @NotNull @Parameter(name="page", description="page number", required=true) @Valid @RequestParam(value="page", required=true) Integer var2, @NotNull @Parameter(name="size", description="size number", required=true) @Valid @RequestParam(value="size", required=true) Integer var3);

    @Operation(operationId="getDataSetListTestCasesUsagesCount", summary="getDataSetListTestCasesUsagesCount", tags={"test-case-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=Integer.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/catalog/api/v1/testcases/dataSetLists/{dslId}/usages/count"}, produces={"application/json"})
    public ResponseEntity<Integer> getDataSetListTestCasesUsagesCount(@Parameter(name="dslId", description="data set list id", required=true) @PathVariable(value="dslId") UUID var1);

    @Operation(operationId="getDataSetTestCasesUsages", summary="getDataSetTestCasesUsages", tags={"test-case-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=PaginationResponseDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/catalog/api/v1/testcases/datasets/{dslId}/usages"}, produces={"application/json"})
    public ResponseEntity<PaginationResponseDto> getDataSetTestCasesUsages(@Parameter(name="dslId", description="data set list id", required=true) @PathVariable(value="dslId") UUID var1, @NotNull @Parameter(name="page", description="page number", required=true) @Valid @RequestParam(value="page", required=true) Integer var2, @NotNull @Parameter(name="size", description="size number", required=true) @Valid @RequestParam(value="size", required=true) Integer var3);

    @Operation(operationId="getDataSetTestCasesUsagesCount", summary="getDataSetTestCasesUsagesCount", tags={"test-case-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=Integer.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/catalog/api/v1/testcases/datasets/{dsId}/usages/count"}, produces={"application/json"})
    public ResponseEntity<Integer> getDataSetTestCasesUsagesCount(@Parameter(name="dsId", description="data set id", required=true) @PathVariable(value="dsId") UUID var1);

    @Operation(operationId="getDetailedCase", summary="getDetailedCase", tags={"test-case-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=TestCaseResponseDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/catalog/api/v1/testcases/{uuid}/detailed"}, produces={"application/json"})
    public ResponseEntity<TestCaseResponseDto> getDetailedCase(@Parameter(name="uuid", description="uuid", required=true) @PathVariable(value="uuid") UUID var1);

    @Operation(operationId="getDetailedCases", summary="getDetailedCases", tags={"test-case-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=TestCaseResponseDto.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/catalog/api/v1/testcases/detailed"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<List<TestCaseResponseDto>> getDetailedCases(@Parameter(name="UUID", description="") @Valid @RequestBody(required=false) Set<UUID> var1);

    @Operation(operationId="getEnrichedCase", summary="getEnrichedCase", tags={"test-case-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=EnrichedCaseDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/catalog/api/v1/testcases/{uuid}/enriched"}, produces={"application/json"})
    public ResponseEntity<EnrichedCaseDto> getEnrichedCase(@Parameter(name="uuid", description="uuid", required=true) @PathVariable(value="uuid") UUID var1, @Parameter(name="testscopeid", description="testscopeid") @Valid @RequestParam(value="testscopeid", required=false) UUID var2);

    @Operation(operationId="getEnrichedCases", summary="getEnrichedCases", tags={"test-case-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=EnrichedCaseDto.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/catalog/api/v1/testcases/enriched"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<List<EnrichedCaseDto>> getEnrichedCases(@Parameter(name="testscopeid", description="testscopeid") @Valid @RequestParam(value="testscopeid", required=false) UUID var1, @Parameter(name="UUID", description="") @Valid @RequestBody(required=false) Set<UUID> var2);

    @Operation(operationId="getScenarioIdByTestCaseId", summary="getScenarioIdByTestCaseId", tags={"test-case-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=UUID.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/catalog/api/v1/testcases/{uuid}/testscenario-id"}, produces={"application/json"})
    public ResponseEntity<UUID> getScenarioIdByTestCaseId(@Parameter(name="uuid", description="uuid", required=true) @PathVariable(value="uuid") UUID var1);

    @Operation(operationId="getTestCaseComponents", summary="search test case components", tags={"test-case-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=JiraComponentDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/catalog/api/v1/testcases/components/search"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<List<JiraComponentDto>> getTestCaseComponents(@Parameter(name="TestCaseComponentsSearchRequestDto", description="") @Valid @RequestBody(required=false) TestCaseComponentsSearchRequestDto var1);

    @Operation(operationId="getTestCaseWithLabelsByUuid", summary="getTestCaseWithLabelsByUuid", tags={"test-case-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=TestCaseDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/catalog/api/v1/testcases/{uuid}"}, produces={"application/json"})
    public ResponseEntity<TestCaseDto> getTestCaseWithLabelsByUuid(@Parameter(name="uuid", description="uuid", required=true) @PathVariable(value="uuid") UUID var1);

    @Operation(operationId="getTestCasesByDsId", summary="getTestCasesByDsId", tags={"test-case-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=Integer.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/catalog/api/v1/testcases/search/DS/{uuid}"}, produces={"application/json"})
    public ResponseEntity<Integer> getTestCasesByDsId(@Parameter(name="uuid", description="uuid", required=true) @PathVariable(value="uuid") UUID var1);

    @Operation(operationId="getTestCasesByIds", summary="getTestCasesByIds", tags={"test-case-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=TestCaseDto.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/catalog/api/v1/testcases/search/by_ids"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<List<TestCaseDto>> getTestCasesByIds(@Parameter(name="CaseSearchRequestDto", description="") @Valid @RequestBody(required=false) CaseSearchRequestDto var1);

    @Operation(operationId="getTestCasesByProjectUuid", summary="getTestCasesByProjectUuid", tags={"test-case-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=TestCaseResponseDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/catalog/api/v1/testcases/project/{uuid}"}, produces={"application/json"})
    public ResponseEntity<List<TestCaseResponseDto>> getTestCasesByProjectUuid(@Parameter(name="uuid", description="uuid", required=true) @PathVariable(value="uuid") UUID var1);

    @Operation(operationId="moveTestCases", summary="moveTestCases", tags={"test-case-controller"}, responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/catalog/api/v1/testcases/move"}, consumes={"application/json"})
    public ResponseEntity<Void> moveTestCases(@Parameter(name="MoveRequestDto", description="") @Valid @RequestBody(required=false) MoveRequestDto var1);

    @Operation(operationId="patch", summary="patch", tags={"test-case-controller"}, responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="204", description="No Content"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden")})
    @RequestMapping(method={RequestMethod.PATCH}, value={"/catalog/api/v1/testcases/{uuid}"}, consumes={"application/json"})
    public ResponseEntity<Void> patch(@Parameter(name="uuid", description="uuid", required=true) @PathVariable(value="uuid") UUID var1, @Parameter(name="CasePatchUpdateRequestDto", description="") @Valid @RequestBody(required=false) CasePatchUpdateRequestDto var2);

    @Deprecated
    @Operation(operationId="patchUpdate", summary="patchUpdate", tags={"test-case-controller"}, responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.PUT}, value={"/catalog/api/v1/testcases/{uuid}/patch"}, consumes={"application/json"})
    public ResponseEntity<Void> patchUpdate(@Parameter(name="uuid", description="uuid", required=true) @PathVariable(value="uuid") UUID var1, @Parameter(name="CasePatchUpdateRequestDto", description="") @Valid @RequestBody(required=false) CasePatchUpdateRequestDto var2);

    @Operation(operationId="replaceTestCasesDataset", summary="replaceTestCasesDataset", tags={"test-case-controller"}, responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="204", description="No Content"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/catalog/api/v1/testcases/dataset/replace"}, consumes={"application/json"})
    public ResponseEntity<Void> replaceTestCasesDataset(@Parameter(name="TestCasesDataSetReplaceRequestDto", description="") @Valid @RequestBody(required=false) TestCasesDataSetReplaceRequestDto var1);

    @Operation(operationId="search", summary="search test cases", tags={"test-case-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=TestCaseDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/catalog/api/v1/testcases/search"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<TestCaseDto> search(@Parameter(name="TestCaseSearchRequestDto", description="") @Valid @RequestBody(required=false) TestCaseSearchRequestDto var1);

    @Operation(operationId="searchEnrichedCases", summary="searchEnrichedCases", tags={"test-case-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=EnrichedCaseDto.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/catalog/api/v1/testcases/enriched/search"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<List<EnrichedCaseDto>> searchEnrichedCases(@Parameter(name="testscopeid", description="testscopeid") @Valid @RequestParam(value="testscopeid", required=false) UUID var1, @Parameter(name="CaseSearchRequestDto", description="") @Valid @RequestBody(required=false) CaseSearchRequestDto var2);

    @Operation(operationId="setTestCaseComponents", summary="set test case components", tags={"test-case-controller"}, responses={@ApiResponse(responseCode="204", description="No Content"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/catalog/api/v1/testcases/components/set"}, consumes={"application/json"})
    public ResponseEntity<Void> setTestCaseComponents(@Parameter(name="TestCaseComponentsSetRequestDto", description="") @Valid @RequestBody(required=false) TestCaseComponentsSetRequestDto var1);

    @Operation(operationId="setTestCaseDatasets", summary="setTestCaseDatasets", tags={"test-case-controller"}, responses={@ApiResponse(responseCode="204", description="No Content"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/catalog/api/v1/testcases/datasets/set"}, consumes={"application/json"})
    public ResponseEntity<Void> setTestCaseDatasets(@Parameter(name="TestCaseDatasetsSetRequestDto", description="") @Valid @RequestBody(required=false) TestCaseDatasetsSetRequestDto var1);

    @Operation(operationId="update", summary="update", tags={"test-case-controller"}, responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.PUT}, value={"/catalog/api/v1/testcases/{uuid}"}, consumes={"application/json"})
    public ResponseEntity<Void> update(@Parameter(name="uuid", description="uuid", required=true) @PathVariable(value="uuid") UUID var1, @Parameter(name="CaseUpdateRequestDto", description="") @Valid @RequestBody(required=false) CaseUpdateRequestDto var2);

    @Operation(operationId="updateCaseStatuses", summary="updateCaseStatuses", tags={"test-case-controller"}, responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/catalog/api/v1/testcases/status-update"}, consumes={"application/json"})
    public ResponseEntity<Void> updateCaseStatuses(@Parameter(name="TestCaseLastStatusDto", description="") @Valid @RequestBody(required=false) List<TestCaseLastStatusDto> var1);
}

