/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ram.clients.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.qubership.atp.ram.clients.api.dto.catalogue.CheckTestScopeUniquenessRequestDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.CheckTestScopeUniquenessResponseDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.DetailedTestScopeResponseDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.EnrichedScopeDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.PageAbstractEntityResponseDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.TestScopeCreationRequestDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.TestScopeDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.TestScopeFullInfoDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.TestScopeUpdateRequestDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.TestScopeUpdateShortRequestDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.TestScopesCopyRequestDto;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Validated
@Tag(name="TestScopeController", description="Test Scope Controller")
public interface TestScopeControllerApi {
    @Operation(operationId="addExecutionCases", summary="addExecutionCases", tags={"test-scope-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=UUID.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.PUT}, value={"/catalog/api/v1/testscopes/{uuid}/testcases/save"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<UUID> addExecutionCases(@Parameter(name="uuid", description="uuid", required=true) @PathVariable(value="uuid") UUID var1, @Parameter(name="TestScopeDto", description="") @Valid @RequestBody(required=false) TestScopeDto var2);

    @Operation(operationId="checkUniquenessByName", summary="checkUniquenessByName", tags={"test-scope-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=CheckTestScopeUniquenessResponseDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/catalog/api/v1/testscopes/checkUniquenessByName"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<CheckTestScopeUniquenessResponseDto> checkUniquenessByName(@Parameter(name="CheckTestScopeUniquenessRequestDto", description="") @Valid @RequestBody(required=false) CheckTestScopeUniquenessRequestDto var1);

    @Operation(operationId="copyTestScopes", summary="copyTestScopes", tags={"test-scope-controller"}, responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/catalog/api/v1/testscopes/copy"}, consumes={"application/json"})
    public ResponseEntity<Void> copyTestScopes(@Parameter(name="TestScopesCopyRequestDto", description="") @Valid @RequestBody(required=false) TestScopesCopyRequestDto var1);

    @Operation(operationId="create", summary="create", tags={"test-scope-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=UUID.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/catalog/api/v1/testscopes/create"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<UUID> create(@Parameter(name="TestScopeCreationRequestDto", description="") @Valid @RequestBody(required=false) TestScopeCreationRequestDto var1);

    @Operation(operationId="delete", summary="delete", tags={"test-scope-controller"}, responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="204", description="No Content"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden")})
    @RequestMapping(method={RequestMethod.DELETE}, value={"/catalog/api/v1/testscopes"}, consumes={"application/json"})
    public ResponseEntity<Void> delete(@Parameter(name="UUID", description="") @Valid @RequestBody(required=false) Set<UUID> var1);

    @Operation(operationId="getAll", summary="getAll", tags={"test-scope-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=TestScopeDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/catalog/api/v1/testscopes"}, produces={"application/json"})
    public ResponseEntity<List<TestScopeDto>> getAll();

    @Operation(operationId="getAllNamesByNameWithPagination", summary="getAllNamesByNameWithPagination", tags={"test-scope-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=PageAbstractEntityResponseDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/catalog/api/v1/testscopes/find-name-pagination"}, produces={"application/json"})
    public ResponseEntity<PageAbstractEntityResponseDto> getAllNamesByNameWithPagination(@NotNull @Parameter(name="projectId", description="projectId", required=true) @Valid @RequestParam(value="projectId", required=true) UUID var1, @NotNull @Parameter(name="testPlanId", description="testPlanId", required=true) @Valid @RequestParam(value="testPlanId", required=true) UUID var2, @NotNull @Parameter(name="name", description="name", required=true) @Valid @RequestParam(value="name", required=true) String var3, @Parameter(name="offset", description="") @Valid @RequestParam(value="offset", required=false) Long var4, @Parameter(name="pageNumber", description="") @Valid @RequestParam(value="pageNumber", required=false) Integer var5, @Parameter(name="pageSize", description="") @Valid @RequestParam(value="pageSize", required=false) Integer var6, @Parameter(name="paged", description="") @Valid @RequestParam(value="paged", required=false) Boolean var7, @Parameter(name="sort.sorted", description="") @Valid @RequestParam(value="sort.sorted", required=false) Boolean var8, @Parameter(name="sort.unsorted", description="") @Valid @RequestParam(value="sort.unsorted", required=false) Boolean var9, @Parameter(name="unpaged", description="") @Valid @RequestParam(value="unpaged", required=false) Boolean var10);

    @Operation(operationId="getCountTestScopeDetailed", summary="getCountTestScopeDetailed", tags={"test-scope-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=Long.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/catalog/api/v1/testscopes/detailed/count"}, produces={"application/json"})
    public ResponseEntity<Long> getCountTestScopeDetailed(@NotNull @Parameter(name="projectId", description="projectId", required=true) @Valid @RequestParam(value="projectId", required=true) UUID var1, @Parameter(name="testPlanId", description="testPlanId") @Valid @RequestParam(value="testPlanId", required=false) UUID var2);

    @Operation(operationId="getCsvImportSampleFile", summary="getCsvImportSampleFile", tags={"test-scope-controller"}, responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/catalog/api/v1/testscopes/import/csv/sample"})
    public ResponseEntity<Void> getCsvImportSampleFile();

    @Operation(operationId="getDatasetsFromScopes", summary="getDatasetsFromScopes", tags={"test-scope-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=UUID.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/catalog/api/v1/testscopes/datasetsFromScopes"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<Set<UUID>> getDatasetsFromScopes(@Parameter(name="UUID", description="") @Valid @RequestBody(required=false) Set<UUID> var1);

    @Operation(operationId="getDetailedScope", summary="getDetailedScope", tags={"test-scope-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=DetailedTestScopeResponseDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/catalog/api/v1/testscopes/{testScopeId}/detailed"}, produces={"application/json"})
    public ResponseEntity<DetailedTestScopeResponseDto> getDetailedScope(@Parameter(name="testScopeId", description="uuid", required=true) @PathVariable(value="testScopeId") UUID var1, @Parameter(name="testPlanId", description="testPlanId") @Valid @RequestParam(value="testPlanId", required=false) UUID var2);

    @Operation(operationId="getEnrichedScope", summary="getEnrichedScope", tags={"test-scope-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=EnrichedScopeDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/catalog/api/v1/testscopes/{uuid}/enriched"}, produces={"application/json"})
    public ResponseEntity<EnrichedScopeDto> getEnrichedScope(@Parameter(name="uuid", description="uuid", required=true) @PathVariable(value="uuid") UUID var1);

    @Operation(operationId="getTestScopeByUuid", summary="getTestScopeByUuid", tags={"test-scope-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=TestScopeDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/catalog/api/v1/testscopes/{uuid}"}, produces={"application/json"})
    public ResponseEntity<TestScopeDto> getTestScopeByUuid(@Parameter(name="uuid", description="uuid", required=true) @PathVariable(value="uuid") UUID var1);

    @Operation(operationId="getTestScopesDetailed", summary="getTestScopesDetailed", tags={"test-scope-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=TestScopeFullInfoDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/catalog/api/v1/testscopes/detailed"}, produces={"application/json"})
    public ResponseEntity<List<TestScopeFullInfoDto>> getTestScopesDetailed(@NotNull @Parameter(name="projectId", description="projectId", required=true) @Valid @RequestParam(value="projectId", required=true) UUID var1, @Parameter(name="testPlanId", description="testPlanId") @Valid @RequestParam(value="testPlanId", required=false) UUID var2);

    @Operation(operationId="getTestScopesDetailedPaging", summary="getTestScopesDetailedPaging", tags={"test-scope-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=TestScopeFullInfoDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/catalog/api/v1/testscopes/detailed/start-index/{startIndex}/end-index/{endIndex}"}, produces={"application/json"})
    public ResponseEntity<List<TestScopeFullInfoDto>> getTestScopesDetailedPaging(@NotNull @Parameter(name="projectId", description="projectId", required=true) @Valid @RequestParam(value="projectId", required=true) UUID var1, @Parameter(name="startIndex", description="startIndex", required=true) @PathVariable(value="startIndex") Integer var2, @Parameter(name="endIndex", description="endIndex", required=true) @PathVariable(value="endIndex") Integer var3, @Parameter(name="testPlanId", description="testPlanId") @Valid @RequestParam(value="testPlanId", required=false) UUID var4);

    @Operation(operationId="importTestScopeFromCsv", summary="importTestScopeFromCsv", tags={"test-scope-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=UUID.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/catalog/api/v1/testscopes/import/csv"}, produces={"application/json"}, consumes={"multipart/form-data"})
    public ResponseEntity<UUID> importTestScopeFromCsv(@NotNull @Parameter(name="testScopeName", description="testScopeName", required=true) @Valid @RequestParam(value="testScopeName", required=true) String var1, @NotNull @Parameter(name="testPlanId", description="testPlanId", required=true) @Valid @RequestParam(value="testPlanId", required=true) UUID var2, @NotNull @Parameter(name="projectId", description="projectId", required=true) @Valid @RequestParam(value="projectId", required=true) UUID var3, @Parameter(name="file", description="") @Valid @RequestParam(value="file", required=false) Object var4);

    @Operation(operationId="update", summary="update", tags={"test-scope-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=UUID.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.PUT}, value={"/catalog/api/v1/testscopes/save"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<UUID> update(@Parameter(name="TestScopeDto", description="") @Valid @RequestBody(required=false) TestScopeDto var1);

    @Operation(operationId="updateDetailed", summary="updateDetailed", tags={"test-scope-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=DetailedTestScopeResponseDto.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.PUT}, value={"/catalog/api/v1/testscopes/save/detailed"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<DetailedTestScopeResponseDto> updateDetailed(@Parameter(name="TestScopeUpdateRequestDto", description="") @Valid @RequestBody(required=false) TestScopeUpdateRequestDto var1);

    @Operation(operationId="updateEnriched", summary="updateEnriched", tags={"test-scope-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=EnrichedScopeDto.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.PUT}, value={"/catalog/api/v1/testscopes/save/enriched"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<EnrichedScopeDto> updateEnriched(@Parameter(name="TestScopeDto", description="") @Valid @RequestBody(required=false) TestScopeDto var1);

    @Operation(operationId="updateShort", summary="updateShort", tags={"test-scope-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=TestScopeDto.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.PUT}, value={"/catalog/api/v1/testscopes/save/short"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<TestScopeDto> updateShort(@Parameter(name="TestScopeUpdateShortRequestDto", description="") @Valid @RequestBody(required=false) TestScopeUpdateShortRequestDto var1);
}

