/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ram.clients.api.dto.catalogue;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.validation.Valid;
import org.qubership.atp.ram.clients.api.dto.catalogue.ActionParameterDto;

@JsonTypeName(value="ActionEntity")
public class ActionEntityDto {
    @JsonProperty(value="engineType")
    private EngineTypeEnum engineType;
    @JsonProperty(value="id")
    private UUID id;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="parameters")
    @Valid
    private List<ActionParameterDto> parameters = null;
    @JsonProperty(value="type")
    private TypeEnum type;

    public ActionEntityDto engineType(EngineTypeEnum engineType) {
        this.engineType = engineType;
        return this;
    }

    @Schema(name="engineType", required=false)
    public EngineTypeEnum getEngineType() {
        return this.engineType;
    }

    public void setEngineType(EngineTypeEnum engineType) {
        this.engineType = engineType;
    }

    public ActionEntityDto id(UUID id) {
        this.id = id;
        return this;
    }

    @Valid
    @Schema(name="id", required=false)
    public UUID getId() {
        return this.id;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public ActionEntityDto name(String name) {
        this.name = name;
        return this;
    }

    @Schema(name="name", required=false)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ActionEntityDto parameters(List<ActionParameterDto> parameters) {
        this.parameters = parameters;
        return this;
    }

    public ActionEntityDto addParametersItem(ActionParameterDto parametersItem) {
        if (this.parameters == null) {
            this.parameters = new ArrayList<ActionParameterDto>();
        }
        this.parameters.add(parametersItem);
        return this;
    }

    @Valid
    @Schema(name="parameters", required=false)
    public List<ActionParameterDto> getParameters() {
        return this.parameters;
    }

    public void setParameters(List<ActionParameterDto> parameters) {
        this.parameters = parameters;
    }

    public ActionEntityDto type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Schema(name="type", required=false)
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ActionEntityDto actionEntity = (ActionEntityDto)o;
        return Objects.equals((Object)this.engineType, (Object)actionEntity.engineType) && Objects.equals(this.id, actionEntity.id) && Objects.equals(this.name, actionEntity.name) && Objects.equals(this.parameters, actionEntity.parameters) && Objects.equals((Object)this.type, (Object)actionEntity.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.engineType, this.id, this.name, this.parameters, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ActionEntityDto {\n");
        sb.append("    engineType: ").append(this.toIndentedString((Object)this.engineType)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    parameters: ").append(this.toIndentedString(this.parameters)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum EngineTypeEnum {
        BV("BV"),
        EXECUTOR("EXECUTOR"),
        ITFACTION("ITFACTION"),
        ITFCALLCHAIN("ITFCALLCHAIN"),
        ITFWARMUP("ITFWARMUP"),
        NEWMAN_RUNNER("NEWMAN_RUNNER");

        private String value;

        private EngineTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static EngineTypeEnum fromValue(String value) {
            for (EngineTypeEnum b : EngineTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum TypeEnum {
        BV("BV"),
        COMPOUND("COMPOUND"),
        ITF("ITF"),
        MIA("MIA"),
        NEWMAN("NEWMAN"),
        R_B_M("R_B_M"),
        REST("REST"),
        SQL("SQL"),
        SSH("SSH"),
        TECHNICAL("TECHNICAL"),
        UI("UI");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

